/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.ricalcolotariffe;

import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.common.model.TipoTrattamento;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.services.StrategiesManager;
import biz.elabor.prebilling.services.common.CheckStatusStrategy;
import biz.elabor.prebilling.services.common.FileCopyStrategy;
import biz.elabor.prebilling.services.common.GetCalendarStrategy;
import biz.elabor.prebilling.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.services.ricalcolotariffe.RicalcoloTariffeDispatcherStrategy;
import biz.elabor.prebilling.services.ricalcolotariffe.RicalcoloTariffeResellerStrategy;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.GetAliquotePerditeStrategy;
import biz.elabor.prebilling.services.tariffe.GetApplicazioniStrategy;
import biz.elabor.prebilling.services.tariffe.GetComuniStrategy;
import biz.elabor.prebilling.services.tariffe.GetOfferteStrategy;
import biz.elabor.prebilling.services.tariffe.GetPraStrategy;
import biz.elabor.prebilling.services.tariffe.RecordStatoTariffeStrategy;
import biz.elabor.prebilling.services.tariffe.TipoCalcolo;
import biz.elabor.prebilling.web.common.AbstractStrategiesHandler;
import biz.elabor.prebilling.web.tariffe.ExportErroriTariffeLog;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class RicalcoloTariffeStrategiesHandler
extends AbstractStrategiesHandler {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM/yyyy");
    private String inizioTxt;
    private String fineTxt;
    private TipoCalcolo tipo;
    private Destinatari destinatari;
    private List<String> pods;
    private boolean scivoloEnabled;
    private boolean scivoloForced;
    private final TipoTrattamento tipoTrattamento;
    private final String reseller;
    private final boolean bloccoIndice;

    public RicalcoloTariffeStrategiesHandler(String inizioTxt, String fineTxt, List<String> pods, String reseller, TipoCalcolo tipo, Destinatari destinatari, boolean scivoloEnabled, boolean scivoloForced, TipoTrattamento tipoTrattamento, boolean bloccoIndice, ConfigurationInstance configurationInstance, TalkManager talkManager) {
        super(configurationInstance, talkManager);
        this.inizioTxt = inizioTxt;
        this.fineTxt = fineTxt;
        this.reseller = reseller;
        this.tipo = tipo;
        this.destinatari = destinatari;
        this.pods = pods;
        this.scivoloEnabled = scivoloEnabled;
        this.scivoloForced = scivoloForced;
        this.tipoTrattamento = tipoTrattamento;
        this.bloccoIndice = bloccoIndice;
    }

    @Override
    public StrategiesManager buildStrategiesManager() throws InvalidParameterValue {
        Date dataInizio = ControllerHelper.checkData("data_inizio", this.inizioTxt, DATE_FORMAT);
        Date dataFine = ControllerHelper.checkData("data_fine", this.fineTxt, DATE_FORMAT);
        ControllerHelper.checkEmpty("pod", this.pods);
        return this.buildStrategiesManager(dataInizio, dataFine);
    }

    private StrategiesManager buildStrategiesManager(Date inizio, Date fine) {
        StrategiesManager service = new StrategiesManager(this.configuration);
        String ambito = CheckStatusStrategy.getAmbito(this.destinatari, "");
        service.addStrategy(new CheckStatusStrategy(Funzionalita.TARIFFE, ambito, "check", this.configuration, this.prebillingDao, this.talkManager));
        boolean consumoComplessivo = this.configuration.isConsumoComplessivo();
        service.addStrategy(new GetCalendarStrategy(this.configuration, this.prebillingDao));
        service.addStrategy(new GetComuniStrategy(this.misureDao));
        service.addStrategy(new GetPraStrategy(this.misureDao, consumoComplessivo));
        service.addStrategy(new GetOfferteStrategy(this.prebillingDao));
        service.addStrategy(new GetApplicazioniStrategy(this.prebillingDao));
        service.addStrategy(new GetAliquotePerditeStrategy(this.misureDao));
        this.addMonthStrategies(inizio, fine, service);
        service.addStrategy(new ExportErroriTariffeLog(this.configuration, this.talkManager));
        service.addStrategy(new RecordStatoTariffeStrategy(this.misureDao, this.talkManager));
        service.addStrategy(new UpdateStatusStrategy(Funzionalita.TARIFFE, ambito, TipoStato.COPIA_FILE, this.configuration, this.prebillingDao));
        service.addStrategy(new FileCopyStrategy(Funzionalita.TARIFFE, this.configuration, this.talkManager));
        service.addStrategy(new UpdateStatusStrategy(Funzionalita.TARIFFE, ambito, TipoStato.NO_ESECUZIONE, this.configuration, this.prebillingDao));
        return service;
    }

    private void addMonthStrategies(Date inizio, Date fine, StrategiesManager service) {
        ElaborCalendar calendarInizio = new ElaborCalendar(inizio);
        int annoStart = calendarInizio.getAnno();
        Month meseStart = calendarInizio.getMese();
        ElaborCalendar calendarFine = new ElaborCalendar(fine);
        int annoEnd = calendarFine.getAnno();
        Month meseEnd = calendarFine.getMese();
        calendarInizio.resetTime();
        calendarFine.resetTime();
        while (!calendarInizio.after(calendarFine)) {
            int anno = calendarInizio.getAnno();
            Month mese = calendarInizio.getMese();
            if (this.destinatari.hasReseller()) {
                RicalcoloTariffeResellerStrategy ricalcoloTariffeResellerStrategy = new RicalcoloTariffeResellerStrategy(anno, mese, annoStart, meseStart, annoEnd, meseEnd, this.tipo, this.tipoTrattamento, this.scivoloEnabled, this.scivoloForced, this.pods, this.reseller, this.bloccoIndice, this.configuration, this.giadaDao, this.misureDao, this.indiciDao, this.talkManager);
                service.addStrategy(ricalcoloTariffeResellerStrategy);
            }
            if (this.destinatari.hasDispatcher()) {
                RicalcoloTariffeDispatcherStrategy ricalcoloTariffeDispatcherStrategy = new RicalcoloTariffeDispatcherStrategy(anno, mese, annoStart, meseStart, annoEnd, meseEnd, this.tipo, this.tipoTrattamento, this.scivoloEnabled, this.scivoloForced, this.pods, this.reseller, this.bloccoIndice, this.configuration, this.giadaDao, this.misureDao, this.indiciDao, this.talkManager);
                service.addStrategy(ricalcoloTariffeDispatcherStrategy);
            }
            calendarInizio.addMesi(1);
        }
    }
}

