/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.letture;

import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.TipoEstrazione;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.services.StrategiesManager;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.CheckStatusStrategy;
import biz.elabor.prebilling.services.common.ExportLettureTecnicheStrategy;
import biz.elabor.prebilling.services.common.FileCopyStrategy;
import biz.elabor.prebilling.services.common.GetCalendarStrategy;
import biz.elabor.prebilling.services.common.GetPivStrategy;
import biz.elabor.prebilling.services.common.GetPrestazioniStrategy;
import biz.elabor.prebilling.services.common.GetResellersStrategy;
import biz.elabor.prebilling.services.common.GetRnoStrategy;
import biz.elabor.prebilling.services.common.GetSmartPodStrategy;
import biz.elabor.prebilling.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.services.letture.AggregationNoPivStrategy;
import biz.elabor.prebilling.services.letture.AggregationPivStrategy;
import biz.elabor.prebilling.services.letture.ExportLogSostituzioniStrategy;
import biz.elabor.prebilling.services.letture.ExportSwitchOutStrategy;
import biz.elabor.prebilling.services.letture.ExportVoltureOrarieNoCrmStartegy;
import biz.elabor.prebilling.services.letture.ExportVoltureVirtualiStrategy;
import biz.elabor.prebilling.services.letture.GetDispatchingFlussiStrategy;
import biz.elabor.prebilling.services.letture.GetPdoLettureStrategy;
import biz.elabor.prebilling.services.letture.GetPnoStrategy;
import biz.elabor.prebilling.services.letture.GetRfoLettureStrategy;
import biz.elabor.prebilling.services.letture.GetSmisStrategy;
import biz.elabor.prebilling.services.letture.GetVirtualPivStrategy;
import biz.elabor.prebilling.services.letture.LetturePrestazioneStrategy;
import biz.elabor.prebilling.services.letture.RecordLettureStrategy;
import biz.elabor.prebilling.services.letture.RecordStatoLettureStrategy;
import biz.elabor.prebilling.services.rettifiche.ExportRfoStrategy;
import biz.elabor.prebilling.services.rettifiche.ExportRsnRnvStrategy;
import biz.elabor.prebilling.services.rettifiche.GetRsnRnvStrategy;
import biz.elabor.prebilling.services.tariffe.GetComuniStrategy;
import biz.elabor.prebilling.services.tariffe.GetPraStrategy;
import biz.elabor.prebilling.services.volture.GetVnoStrategy;
import biz.elabor.prebilling.web.PrebillingControllerHelper;
import biz.elabor.prebilling.web.common.AbstractStrategiesHandler;
import biz.elabor.prebilling.web.letture.ConsolidamentoStrategiesHandler;
import biz.elabor.prebilling.web.letture.ExportLetturePeriodoNoPivStrategy;
import biz.elabor.prebilling.web.letture.ExportLetturePeriodoPivStrategy;
import biz.elabor.prebilling.web.letture.InitPnoStrategy;
import java.util.Date;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class LettureStrategiesHandler
extends AbstractStrategiesHandler {
    private String azienda;
    private String annoTxt;
    private String meseTxt;
    private String tipoTxt;
    private String onlyPod;

    public LettureStrategiesHandler(String azienda, String annoTxt, String meseTxt, String tipoTxt, String onlyPod, ConfigurationInstance configurationInstance, TalkManager talkManager) {
        super(configurationInstance, talkManager);
        this.azienda = azienda;
        this.annoTxt = annoTxt;
        this.meseTxt = meseTxt;
        this.tipoTxt = tipoTxt;
        this.onlyPod = onlyPod;
    }

    @Override
    public StrategiesManager buildStrategiesManager() throws InvalidParameterValue {
        ConsolidamentoStrategiesHandler consolidamentoSH = new ConsolidamentoStrategiesHandler(this.annoTxt, this.meseTxt, this.onlyPod, this.configurationInstance, this.talkManager);
        StrategiesManager manager = consolidamentoSH.buildStrategiesManager();
        int anno = ControllerHelper.checkInt("anno", this.annoTxt);
        Month mese = ControllerHelper.checkEnum("mese", this.meseTxt, Month.class);
        TipoEstrazione tipo = PrebillingControllerHelper.checkTipo(this.tipoTxt);
        Reseller reseller = this.prebillingDao.getReseller(this.azienda);
        Date timestamp = new Date();
        manager.addStrategy(new CheckStatusStrategy(Funzionalita.LETTURE, "*", "letture.check", this.configuration, this.prebillingDao, this.talkManager));
        manager.addStrategy(new GetDispatchingFlussiStrategy(this.prebillingDao));
        manager.addStrategy(new GetCalendarStrategy(this.configuration, this.prebillingDao));
        manager.addStrategy(new GetResellersStrategy(this.prebillingDao));
        manager.addStrategy(new GetPrestazioniStrategy(this.misureDao));
        manager.addStrategy(new InitPnoStrategy(tipo, reseller, this.misureDao, this.talkManager));
        manager.addStrategy(new GetSmartPodStrategy(anno, mese, this.onlyPod, this.configuration, this.giadaDao));
        manager.addStrategy(new GetSmisStrategy(anno, mese, this.azienda, tipo, this.onlyPod, this.misureDao, this.talkManager));
        manager.addStrategy(new GetPdoLettureStrategy(anno, mese, this.azienda, this.onlyPod, this.misureDao));
        manager.addStrategy(new GetPnoStrategy(anno, mese, this.onlyPod, this.misureDao, this.talkManager));
        manager.addStrategy(new GetRnoStrategy(reseller, this.onlyPod, this.misureDao));
        manager.addStrategy(new GetRfoLettureStrategy(this.onlyPod, this.misureDao, this.talkManager));
        manager.addStrategy(new GetRsnRnvStrategy(anno, mese, this.onlyPod, this.misureDao));
        manager.addStrategy(new GetVnoStrategy(this.onlyPod, this.misureDao));
        manager.addStrategy(new GetPivStrategy(anno, mese, this.azienda, this.onlyPod, this.giadaDao, StrategyHelper.LETTURE_CDUNIPRE_LIST));
        manager.addStrategy(new GetVirtualPivStrategy(this.misureDao));
        manager.addStrategy(new GetComuniStrategy(this.misureDao));
        manager.addStrategy(new GetPraStrategy(this.misureDao, false));
        manager.addStrategy(new ExportVoltureVirtualiStrategy(this.misureDao, this.talkManager, this.configuration));
        manager.addStrategy(new AggregationNoPivStrategy(anno, mese, "export.stdlet.strategy", reseller, tipo, this.misureDao, this.talkManager, this.configuration));
        manager.addStrategy(new LetturePrestazioneStrategy(this.misureDao, this.talkManager, this.configuration));
        manager.addStrategy(new ExportLetturePeriodoNoPivStrategy(anno, mese, this.configuration, this.misureDao, this.talkManager, timestamp));
        manager.addStrategy(new ExportLogSostituzioniStrategy(anno, mese, this.configuration, this.talkManager));
        manager.addStrategy(new ExportRsnRnvStrategy(anno, mese, this.configuration, this.misureDao, this.talkManager, timestamp));
        manager.addStrategy(new RecordStatoLettureStrategy(this.misureDao, this.talkManager));
        manager.addStrategy(new AggregationPivStrategy(anno, mese, "export.stdlet.strategy", reseller, tipo, this.misureDao, this.talkManager, this.configuration));
        manager.addStrategy(new ExportRfoStrategy(anno, mese, reseller, tipo, this.onlyPod, this.configuration, this.giadaDao, this.misureDao, this.talkManager));
        manager.addStrategy(new ExportLetturePeriodoPivStrategy(anno, mese, this.configuration, this.misureDao, this.talkManager, timestamp));
        manager.addStrategy(new ExportVoltureOrarieNoCrmStartegy(this.configuration, this.talkManager));
        manager.addStrategy(new ExportLettureTecnicheStrategy(Funzionalita.LETTURE, anno, mese, this.onlyPod, this.configuration, this.misureDao, this.talkManager));
        manager.addStrategy(new ExportSwitchOutStrategy(Funzionalita.LETTURE, anno, mese, this.configuration, this.talkManager));
        manager.addStrategy(new RecordLettureStrategy(this.misureDao, this.talkManager));
        manager.addStrategy(new RecordStatoLettureStrategy(this.misureDao, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.LETTURE, "*", TipoStato.COPIA_FILE, this.configuration, this.prebillingDao));
        manager.addStrategy(new FileCopyStrategy(Funzionalita.LETTURE, this.configuration, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.LETTURE, "*", TipoStato.NO_ESECUZIONE, this.configuration, this.prebillingDao));
        return manager;
    }
}

