/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.letture;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.util.Results;
import biz.elabor.prebilling.web.common.AbstractRequestHandler;
import biz.elabor.prebilling.web.common.JsonRequestHandler;
import biz.elabor.prebilling.web.letture.LateProcessingStrategiesHandler;
import biz.elabor.prebilling.web.letture.SpecificaPrestazione;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class LateProcessingJsonPostHandler
extends AbstractRequestHandler
implements JsonRequestHandler {
    private final List<String> prestazioniTxt;
    private final List<String> ritardiTxt;
    private final List<String> scostamentiTxt;
    private final String reseller;
    private final String onlyPod;

    public LateProcessingJsonPostHandler(List<String> prestazioniTxt, List<String> ritardiTxt, List<String> scostamentiTxt, String reseller, String onlyPod, TalkManager talkManager) {
        super("letture", talkManager);
        this.prestazioniTxt = prestazioniTxt;
        this.ritardiTxt = ritardiTxt;
        this.scostamentiTxt = scostamentiTxt;
        this.reseller = reseller;
        this.onlyPod = onlyPod;
    }

    @Override
    public String handleRequest(ConfigurationInstance instance) throws InvalidParameterValue {
        PrebillingConfiguration configuration = instance.getConfiguration();
        int size = this.prestazioniTxt.size();
        if (size != this.ritardiTxt.size() || size != this.scostamentiTxt.size()) {
            throw new InvalidParameterValue("prestazione", "");
        }
        HashMap<String, SpecificaPrestazione> prestazioni = new HashMap<String, SpecificaPrestazione>();
        try {
            int index = 0;
            while (index < this.prestazioniTxt.size()) {
                String prestazione = this.prestazioniTxt.get(index);
                int ritardo = Integer.parseInt(this.ritardiTxt.get(index));
                int scostamento = Integer.parseInt(this.scostamentiTxt.get(index));
                prestazioni.put(prestazione, new SpecificaPrestazione(prestazione, ritardo, scostamento));
                ++index;
            }
        }
        catch (Exception exc) {
            throw new InvalidParameterValue("prestazione", "");
        }
        LateProcessingStrategiesHandler handler = new LateProcessingStrategiesHandler(prestazioni, this.reseller, this.onlyPod, instance, this.talkManager);
        PrebillingDao prebillingDao = instance.getPrebillingDao();
        Results results = this.handleRequest(handler, configuration, prebillingDao);
        return JsonHelper.buildMessage(configuration, results, this.talkManager);
    }

    @Override
    protected String getReseller() {
        return this.reseller;
    }

    @Override
    protected LinkedHashMap<String, Object> getParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("prestazione", this.prestazioniTxt);
        params.put("ritardo", this.ritardiTxt);
        params.put("scostamento", this.scostamentiTxt);
        params.put("pod", this.onlyPod);
        return params;
    }
}

