/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.letture;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.MappaMisureAzienda;
import biz.elabor.prebilling.model.misure.Misure;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.letture.ExportLetturePeriodoStrategy;
import biz.elabor.prebilling.services.letture.PivExistsChecker;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public class ExportLetturePeriodoPivStrategy
extends ExportLetturePeriodoStrategy {
    public ExportLetturePeriodoPivStrategy(int anno, Month mese, PrebillingConfiguration configuration, MisureDao misureDao, TalkManager talkManager, Date timestamp) {
        super(anno, mese, configuration, misureDao, talkManager, new PivExistsChecker(), timestamp);
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok = super.execute(status);
        if (ok) {
            ListMap<String, PraticaVolo> piv = status.getPiv();
            for (List list : piv) {
                this.handlePivPod(list, status);
            }
        }
        return ok;
    }

    private void handlePivPod(List<PraticaVolo> pivPod, ServiceStatus status) {
        for (PraticaVolo pratica : pivPod) {
            Mno vno;
            String prestazione;
            if (pratica.isHandled() || !(prestazione = pratica.getCodicePrestazione()).equals("VT4") || (vno = ExportLetturePeriodoPivStrategy.findVno(pratica, status)) == null) continue;
            try {
                String dispatcher = vno.getCodContrDisp();
                Pod pod = ExportLetturePeriodoPivStrategy.findPod(dispatcher, pratica, status);
                MappaMisureAzienda pno = status.getPnos();
                pno.addSwitchout(pod, vno);
            }
            catch (DataNotFoundException exc) {
                String message = exc.getMessage();
                Message sentence = new Message("export.stdlet.strategy", message);
                String key = exc.getKey();
                sentence.addParam(key);
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
                MnoResult result = new MnoResult(vno, errore, descrizione);
                String codiceFlusso = vno.getCodiceFlusso();
                if (codiceFlusso.toLowerCase().contains("2g")) {
                    status.addPdo2GRSospeso(result);
                    continue;
                }
                status.addVnoSospeso(result);
            }
        }
    }

    private static Pod findPod(String dispatcher, PraticaVolo pratica, ServiceStatus status) throws DataNotFoundException {
        String codicePod = pratica.getCodicePod();
        PodMap podMap = status.getPodMap();
        return podMap.get(dispatcher, codicePod);
    }

    private static Mno findVno(PraticaVolo pratica, ServiceStatus status) {
        String codicePod = pratica.getCodicePod();
        SpecificaTecnica specificaTecnica = pratica.getSpecificaTecnica();
        Date dataPrestazione = specificaTecnica.getData();
        return ExportLetturePeriodoPivStrategy.findVno(codicePod, dataPrestazione, status);
    }

    private static Mno findVno(String codicePod, Date dataPrestazione, ServiceStatus status) {
        Misure<Mno> misurePdo2GRV = status.getPdo2GRV();
        Mno vno = ExportLetturePeriodoPivStrategy.findVno(codicePod, dataPrestazione, misurePdo2GRV);
        if (vno == null) {
            Misure<Mno> misureVno = status.getVno();
            vno = ExportLetturePeriodoPivStrategy.findVno(codicePod, dataPrestazione, misureVno);
        }
        return vno;
    }

    private static Mno findVno(String codicePod, Date dataPrestazione, Misure<Mno> misure) {
        Mno vno = null;
        try {
            List vnoPod = (List)misure.get(codicePod);
            Iterator iterator = vnoPod.iterator();
            while (vno == null && iterator.hasNext()) {
                Mno current = (Mno)iterator.next();
                if (!dataPrestazione.equals(current.getDataPrestazione())) continue;
                vno = current;
            }
        }
        catch (DataNotFoundException dataNotFoundException) {
            // empty catch block
        }
        return vno;
    }
}

