/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.letture;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.services.letture.ConsumiPodService;
import biz.elabor.prebilling.web.letture.AbstractConsumiJsonHandler;
import java.text.DateFormat;
import java.util.Date;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class ConsumiPodJsonHandler
extends AbstractConsumiJsonHandler {
    private final String codicePod;
    private final String dataInizioStr;
    private final String dataFineStr;
    private final String idCalendario;
    private final String reseller;

    public ConsumiPodJsonHandler(String codicePod, String dataInizioStr, String dataFineStr, String idCalendario, String reseller, TalkManager talkManager) {
        super(talkManager);
        this.codicePod = codicePod;
        this.dataInizioStr = dataInizioStr;
        this.dataFineStr = dataFineStr;
        this.idCalendario = idCalendario;
        this.reseller = reseller;
    }

    @Override
    public String handleRequest(ConfigurationInstance instance) throws InvalidParameterValue {
        DateFormat dateFormat = StrategyCommonHelper.getAlternateDateFormat();
        Date dataInizio = ControllerHelper.checkData("datainizio", this.dataInizioStr, dateFormat);
        Date dataFine = ControllerHelper.checkData("datafine", this.dataFineStr, dateFormat);
        PrebillingDao prebillingDao = instance.getPrebillingDao();
        MisureDao misureDao = instance.getMisureDao();
        PrebillingConfiguration configuration = instance.getConfiguration();
        ConsumiPodService service = new ConsumiPodService(this.codicePod, dataInizio, dataFine, this.idCalendario, this.reseller, prebillingDao, misureDao, configuration, this.talkManager);
        return this.handleRequest(service, configuration);
    }
}

