/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.letture;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.util.Results;
import biz.elabor.prebilling.web.common.AbstractRequestHandler;
import biz.elabor.prebilling.web.common.JsonRequestHandler;
import biz.elabor.prebilling.web.letture.ConsolidamentoStrategiesHandler;
import java.util.LinkedHashMap;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class ConsolidamentoJsonHandler
extends AbstractRequestHandler
implements JsonRequestHandler {
    private final String annoTxt;
    private final String meseTxt;
    private final String onlyPod;

    public ConsolidamentoJsonHandler(String annoTxt, String meseTxt, String onlyPod, TalkManager talkManager) {
        super("consolidamento", talkManager);
        this.annoTxt = annoTxt;
        this.meseTxt = meseTxt;
        this.onlyPod = onlyPod;
    }

    @Override
    public String handleRequest(ConfigurationInstance instance) {
        PrebillingConfiguration configuration = instance.getConfiguration();
        ConsolidamentoStrategiesHandler handler = new ConsolidamentoStrategiesHandler(this.annoTxt, this.meseTxt, this.onlyPod, instance, this.talkManager);
        PrebillingDao prebillingDao = instance.getPrebillingDao();
        Results results = this.handleRequest(handler, configuration, prebillingDao);
        return JsonHelper.buildMessage(configuration, results, this.talkManager);
    }

    @Override
    protected String getReseller() {
        return null;
    }

    @Override
    protected LinkedHashMap<String, Object> getParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("anno", this.annoTxt);
        params.put("mese", this.meseTxt);
        params.put("pod", this.onlyPod);
        return params;
    }
}

