/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.fasce;

import biz.elabor.misure.model.fasce.CalendarioFasce;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.services.AcquisizioneFasce;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.web.common.AbstractRequestHandler;
import biz.elabor.prebilling.web.common.JsonRequestHandler;
import java.util.LinkedHashMap;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.file.InvalidFileFormat;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.springframework.web.multipart.MultipartFile;

public class CalendarioFasceJsonPostHandler
extends AbstractRequestHandler
implements JsonRequestHandler {
    private String id;
    private String annoStr;
    private MultipartFile file;

    public CalendarioFasceJsonPostHandler(String id, String annoStr, MultipartFile file, TalkManager talkManager) {
        super("get.calendario.fasce", talkManager);
        this.id = id;
        this.annoStr = annoStr;
        this.file = file;
    }

    @Override
    public String handleRequest(ConfigurationInstance configurationInstance) {
        try {
            PrebillingDao prebillingDao = configurationInstance.getPrebillingDao();
            int anno = ControllerHelper.checkInt("anno", this.annoStr);
            ControllerHelper.checkFile("file", this.file);
            AcquisizioneFasce acquisitore = new AcquisizioneFasce(this.id, anno);
            acquisitore.acquisisci(this.file);
            CalendarioFasce calendario = acquisitore.getCalendario();
            prebillingDao.saveCalendarioFasce(calendario);
            Message sentence = new Message("get.calendario.fasce", "procedure.successful");
            sentence.setCss("alert-success");
            this.talkManager.addSentence(sentence);
        }
        catch (InvalidParameterValue exc) {
            Warning sentence = new Warning("get.calendario.fasce", exc.getMessage());
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            this.talkManager.addSentence(sentence);
        }
        catch (InvalidFileFormat exc) {
            Warning sentence = new Warning("get.calendario.fasce", exc.getMessage());
            sentence.setCss("alert-danger");
            this.talkManager.addSentence(sentence);
        }
        catch (InvalidValueException exc) {
            Warning sentence = new Warning("get.calendario.fasce", "file.invalidvalue");
            sentence.addParam(exc.getMessage());
            sentence.addParam(exc.getValue());
            sentence.addParam(String.valueOf(exc.getnRiga()));
            sentence.setCss("alert-danger");
            this.talkManager.addSentence(sentence);
        }
        catch (Exception exc) {
            Warning sentence = new Warning("get.calendario.fasce", "file.invalidformat");
            sentence.addParam(this.file.getOriginalFilename());
            sentence.setCss("alert-danger");
            exc.printStackTrace();
            this.talkManager.addSentence(sentence);
        }
        PrebillingConfiguration configuration = configurationInstance.getConfiguration();
        return JsonHelper.buildMessage(configuration, null, this.talkManager);
    }

    @Override
    protected String getReseller() {
        return null;
    }

    @Override
    protected LinkedHashMap<String, Object> getParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("anno", this.annoStr);
        params.put("file", this.file.getName());
        return params;
    }
}

