/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web;

import biz.elabor.prebilling.common.model.TipoTrattamento;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.TipoCalcolo;
import biz.elabor.prebilling.web.common.AbstractPrebillingController;
import biz.elabor.prebilling.web.common.BasicJsonGetHandler;
import biz.elabor.prebilling.web.ricalcolotariffe.RicalcoloTariffeGetHandler;
import biz.elabor.prebilling.web.ricalcolotariffe.RicalcoloTariffeJsonPostHandler;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RicalcoloTariffeController
extends AbstractPrebillingController {
    public static final String RICALCOLO_TARIFFE = "ricalcolotariffe";
    private static final String RICALCOLO_TARIFFE_URL = "/ricalcolotariffe.srvl";
    private static final String INIZIO = "inizio";
    private static final String FINE = "fine";
    private static final String POD = "pod";

    public RicalcoloTariffeController() {
        super("ricalcolo.tariffe");
    }

    @RequestMapping(value={"/ricalcolotariffe.srvl"}, method={RequestMethod.GET})
    public String tariffeGet(@RequestParam(value="config") String config, ModelMap model, HttpSession session) {
        RicalcoloTariffeGetHandler handler = new RicalcoloTariffeGetHandler();
        return this.handleJspRequest(config, model, session, handler);
    }

    @RequestMapping(value={"/ricalcolotariffe.srvl"}, params={"app"}, method={RequestMethod.GET})
    @ResponseBody
    public String tariffeJsonGet(@RequestParam(value="config") String config) {
        TalkManager talkManager = this.getTalkManager();
        BasicJsonGetHandler handler = new BasicJsonGetHandler(talkManager);
        return this.handleJsonRequest(config, handler, talkManager);
    }

    @RequestMapping(value={"/ricalcolotariffe.srvl"})
    @ResponseBody
    public String ricalcoloTariffeJsonPost(@RequestParam(value="inizio") String inizio, @RequestParam(value="fine") String fine, @RequestParam(value="pod") List<String> pods, @RequestParam(value="tipo") TipoCalcolo tipo, @RequestParam(value="trattamento", required=false) TipoTrattamento trattamento, @RequestParam(value="destinatari") Destinatari destinatari, @RequestParam(value="scivolo", required=false, defaultValue="false") boolean scivoloEnabled, @RequestParam(value="forzato", required=false, defaultValue="false") boolean scivoloForced, @RequestParam(value="blocco_indice", required=false, defaultValue="false") boolean bloccoIndice, @RequestParam(value="reseller", required=false) String reseller, @RequestParam(value="config") String config) {
        TalkManager talkManager = this.getTalkManager();
        RicalcoloTariffeJsonPostHandler handler = new RicalcoloTariffeJsonPostHandler(inizio, fine, pods, reseller, tipo, destinatari, scivoloEnabled, scivoloForced, trattamento, bloccoIndice, talkManager);
        return this.handleJsonRequest(config, handler, talkManager);
    }
}

