/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web;

import biz.elabor.prebilling.services.attivazioni.AttivazioniHandler;
import biz.elabor.prebilling.services.cessazioni.CessazioniHandler;
import biz.elabor.prebilling.services.consumi.ConsumiOrariJsonHandler;
import biz.elabor.prebilling.services.consumi.ConsumiQuartorariJsonHandler;
import biz.elabor.prebilling.services.variazionipotenza.VariazioniPotenzaHandler;
import biz.elabor.prebilling.web.common.AbstractPrebillingController;
import biz.elabor.prebilling.web.common.BasicJsonGetHandler;
import biz.elabor.prebilling.web.letture.ConsolidamentoJsonHandler;
import biz.elabor.prebilling.web.letture.ConsumiIdJsonHandler;
import biz.elabor.prebilling.web.letture.ConsumiPodJsonHandler;
import biz.elabor.prebilling.web.letture.LateProcessingJsonPostHandler;
import biz.elabor.prebilling.web.letture.LettureJsonPostHandler;
import biz.elabor.prebilling.web.letture.LettureJspGetHandler;
import biz.elabor.prebilling.web.letture.LetturePostHandler;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LettureController
extends AbstractPrebillingController {
    public static final String LETTURE = "letture";
    public static final String LETTURE_URL = "/letture.srvl";
    public static final String LATE_PROCESSING = "lateprocessing";
    private static final String LATE_PROCESSING_URL = "/lateprocessing.srvl";
    public static final String CONSUMI = "consumi";
    private static final String CONSUMI_URL = "/consumi.srvl";
    private static final String CONSUMI_ORARI = "consumiorari";
    private static final String CONSUMI_ORARI_URL = "/consumiorari.srvl";
    private static final String CONSUMI_QUARTORARI = "consumiquartorari";
    private static final String CONSUMI_QUARTORARI_URL = "/consumiquartorari.srvl";
    public static final String CONSOLIDAMENTO = "consolidamento";
    private static final String CONSOLIDAMENTO_URL = "/consolidamento.srvl";
    private static final String CESSAZIONI = "cessazioni";
    private static final String CESSAZIONI_URL = "/cessazioni.srvl";
    private static final String ATTIVAZIONI = "attivazioni";
    private static final String ATTIVAZIONI_URL = "/attivazioni.srvl";
    private static final String VARIAZIONI_POTENZA = "variazionipotenza";
    private static final String VARIAZIONI_POTENZA_URL = "/variazionipotenza.srvl";

    public LettureController() {
        super("export.letture");
    }

    @RequestMapping(value={"/letture.srvl"}, method={RequestMethod.GET})
    public String lettureGet(@RequestParam(value="config") String config, ModelMap model, HttpSession session) {
        LettureJspGetHandler handler = new LettureJspGetHandler();
        return this.handleJspRequest(config, model, session, handler);
    }

    @RequestMapping(value={"/letture.srvl"}, method={RequestMethod.POST})
    public String letturePost(@RequestParam(value="reseller") String reseller, @RequestParam(value="mese") String mese, @RequestParam(value="anno") String anno, @RequestParam(value="tipo") String tipo, @RequestParam(value="pod", required=false, defaultValue="") String filtroPod, @RequestParam(value="config") String config, ModelMap model, HttpSession session) {
        TalkManager talkManager = this.getTalkManager();
        LetturePostHandler handler = new LetturePostHandler(reseller, anno, mese, tipo, filtroPod, talkManager);
        return this.handleJspRequest(config, model, session, handler);
    }

    @RequestMapping(value={"/letture.srvl"}, params={"app"}, method={RequestMethod.GET})
    @ResponseBody
    public String lettureJsonGet(@RequestParam(value="config") String config) {
        TalkManager talkManager = this.getTalkManager();
        BasicJsonGetHandler handler = new BasicJsonGetHandler(talkManager);
        return this.handleJsonRequest(config, handler, talkManager);
    }

    @RequestMapping(value={"/letture.srvl"}, params={"app", "reseller"})
    @ResponseBody
    public String lettureJsonPost(@RequestParam(value="reseller") String resellerTxt, @RequestParam(value="anno") String anno, @RequestParam(value="mese") String mese, @RequestParam(value="tipo") String tipoTxt, @RequestParam(value="pod", required=false, defaultValue="") String onlyPod, @RequestParam(value="config") String config) {
        TalkManager talkManager = this.getTalkManager();
        LettureJsonPostHandler handler = new LettureJsonPostHandler(resellerTxt, anno, mese, tipoTxt, onlyPod, talkManager);
        return this.handleJsonRequest(config, handler, talkManager);
    }

    @RequestMapping(value={"/cessazioni.srvl"})
    @ResponseBody
    public String cessazioni(@RequestParam(value="anno", required=false, defaultValue="") String anno, @RequestParam(value="mese", required=false, defaultValue="") String mese, @RequestParam(value="config") String config) {
        TalkManager talkManager = this.getTalkManager();
        CessazioniHandler handler = new CessazioniHandler(anno, mese, talkManager);
        return this.handleJsonRequest(config, handler, talkManager);
    }

    @RequestMapping(value={"/attivazioni.srvl"})
    @ResponseBody
    public String attivazioni(@RequestParam(value="config") String config) {
        TalkManager talkManager = this.getTalkManager();
        AttivazioniHandler handler = new AttivazioniHandler(talkManager);
        return this.handleJsonRequest(config, handler, talkManager);
    }

    @RequestMapping(value={"/variazionipotenza.srvl"})
    @ResponseBody
    public String variazioniPotenza(@RequestParam(value="config") String config) {
        TalkManager talkManager = this.getTalkManager();
        VariazioniPotenzaHandler handler = new VariazioniPotenzaHandler(talkManager);
        return this.handleJsonRequest(config, handler, talkManager);
    }

    @RequestMapping(value={"/lateprocessing.srvl"}, method={RequestMethod.GET})
    @ResponseBody
    public String lateSwitchoutJsonGet(@RequestParam(value="config") String config) {
        TalkManager talkManager = this.getTalkManager();
        BasicJsonGetHandler handler = new BasicJsonGetHandler(talkManager);
        return this.handleJsonRequest(config, handler, talkManager);
    }

    @RequestMapping(value={"/lateprocessing.srvl"}, params={"app", "reseller"})
    @ResponseBody
    public String lateSwitchoutJsonPost(@RequestParam(value="prestazione") List<String> prestazioni, @RequestParam(value="ritardo") List<String> ritardi, @RequestParam(value="scostamento") List<String> scostamenti, @RequestParam(value="reseller") String resellerTxt, @RequestParam(value="pod", required=false, defaultValue="") String onlyPod, @RequestParam(value="config") String config) {
        TalkManager talkManager = this.getTalkManager();
        LateProcessingJsonPostHandler handler = new LateProcessingJsonPostHandler(prestazioni, ritardi, scostamenti, resellerTxt, onlyPod, talkManager);
        return this.handleJsonRequest(config, handler, talkManager);
    }

    @RequestMapping(value={"/consumi.srvl"}, params={"id"})
    @ResponseBody
    public String consumiIdJson(@RequestParam(value="id") String id, @RequestParam(value="ggini") int inizio, @RequestParam(value="ggfine") int fine, @RequestParam(value="config") String config, @RequestParam(value="idcalendario", required=false, defaultValue="") String idCalendario) {
        TalkManager talkManager = this.getTalkManager();
        ConsumiIdJsonHandler handler = new ConsumiIdJsonHandler(id, inizio, fine, idCalendario, talkManager);
        return this.handleJsonRequest(config, handler, talkManager);
    }

    @RequestMapping(value={"/consumi.srvl"}, params={"pod"})
    @ResponseBody
    public String consumiPodJson(@RequestParam(value="pod") String codicePod, @RequestParam(value="datainizio") String dataInizio, @RequestParam(value="datafine") String dataFine, @RequestParam(value="config") String config, @RequestParam(value="reseller", required=false) String reseller, @RequestParam(value="idcalendario", required=false, defaultValue="") String idCalendario) {
        TalkManager talkManager = this.getTalkManager();
        ConsumiPodJsonHandler handler = new ConsumiPodJsonHandler(codicePod, dataInizio, dataFine, idCalendario, reseller, talkManager);
        return this.handleJsonRequest(config, handler, talkManager);
    }

    @RequestMapping(value={"/consumiorari.srvl"})
    @ResponseBody
    public String consumiOrariJson(@RequestParam(value="pod") List<String> codiciPod, @RequestParam(value="datainizio") String dataInizio, @RequestParam(value="datafine") String dataFine, @RequestParam(value="config") String config, @RequestParam(value="reseller", required=false) String reseller) {
        TalkManager talkManager = this.getTalkManager();
        ConsumiOrariJsonHandler handler = new ConsumiOrariJsonHandler(codiciPod, dataInizio, dataFine, reseller, talkManager);
        return this.handleJsonRequest(config, handler, talkManager);
    }

    @RequestMapping(value={"/consumiquartorari.srvl"})
    @ResponseBody
    public String consumiQuartorariJson(@RequestParam(value="pod") List<String> codiciPod, @RequestParam(value="datainizio") String dataInizio, @RequestParam(value="datafine") String dataFine, @RequestParam(value="config") String config, @RequestParam(value="reseller", required=false) String reseller) {
        TalkManager talkManager = this.getTalkManager();
        ConsumiQuartorariJsonHandler handler = new ConsumiQuartorariJsonHandler(codiciPod, dataInizio, dataFine, reseller, talkManager);
        return this.handleJsonRequest(config, handler, talkManager);
    }

    @RequestMapping(value={"/consolidamento.srvl"})
    @ResponseBody
    public String consolidamentoJson(@RequestParam(value="anno") String anno, @RequestParam(value="mese") String mese, @RequestParam(value="config") String config, @RequestParam(value="pod", required=false, defaultValue="") String onlyPod) {
        TalkManager talkManager = this.getTalkManager();
        ConsolidamentoJsonHandler handler = new ConsolidamentoJsonHandler(anno, mese, onlyPod, talkManager);
        return this.handleJsonRequest(config, handler, talkManager);
    }
}

