/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web;

import biz.elabor.prebilling.common.config.InvalidConfigurationException;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.web.common.AbstractPrebillingController;
import java.io.IOException;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class IndexController
extends AbstractPrebillingController {
    public IndexController() {
        super(null);
    }

    @RequestMapping(value={"/index.srvl"})
    public String index(@RequestParam(value="config") String config, ModelMap model) {
        String jsp = "index";
        TalkManager talkManager = this.getTalkManager();
        try {
            ControllerHelper.checkEmpty("config", config);
            ConfigurationInstance instance = this.configurationLoader.loadConfigurationInstance(config);
            try {
                PrebillingConfiguration configuration = instance.getConfiguration();
                IndexController.handleVersion(model, configuration);
            }
            finally {
                instance.closeConnections();
            }
            model.addAttribute("config", config);
        }
        catch (IOException exc) {
            Warning sentence = new Warning("index.page", "not.found.config");
            String message = exc.getMessage();
            sentence.addParam(message);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidConfigurationException exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("index.page", message);
            String key = exc.getKey();
            sentence.addParam(key);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidParameterValue exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("index.page", message);
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (Exception exc) {
            String message = exc.getMessage();
            Message sentence = new Message("index.page", message);
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        return jsp;
    }
}

