/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web;

import biz.elabor.prebilling.common.AbstractController;
import biz.elabor.prebilling.common.config.InvalidConfigurationException;
import biz.elabor.prebilling.common.model.Applicazione;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.web.common.AbstractPrebillingController;
import java.io.IOException;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.NotDeletableException;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ApplicazioniController
extends AbstractPrebillingController {
    private static final String LIST = "applicazioni";
    private static final String ADD = "addapplicazione";
    private static final String DELETE = "deleteapplicazione";
    private static final String EDIT = "editapplicazione";
    private static final String LIST_URL = "/applicazioni.srvl";
    private static final String ADD_URL = "/addapplicazione.srvl";
    private static final String DELETE_URL = "/deleteapplicazione.srvl";
    private static final String EDIT_URL = "/editapplicazione.srvl";

    public ApplicazioniController() {
        super("manage.applicazioni");
    }

    @RequestMapping(value={"/addapplicazione.srvl"}, method={RequestMethod.GET})
    public String aggiungiApplicazione(@RequestParam(value="config") String config, ModelMap model) {
        String jsp = ADD;
        TalkManager talkManager = this.getTalkManager();
        try {
            ControllerHelper.checkEmpty("config", config);
            ConfigurationInstance instance = this.configurationLoader.loadConfigurationInstance(config);
            PrebillingConfiguration configuration = instance.getConfiguration();
            ApplicazioniController.handleVersion(model, configuration);
            model.addAttribute("config", config);
        }
        catch (IOException exc) {
            Warning sentence = new Warning("manage.applicazioni", "not.found.config");
            String message = exc.getMessage();
            sentence.addParam(message);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        catch (InvalidConfigurationException exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.applicazioni", message);
            String key = exc.getKey();
            sentence.addParam(key);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        catch (InvalidParameterValue exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.applicazioni", message);
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        return jsp;
    }

    @RequestMapping(value={"/deleteapplicazione.srvl"}, method={RequestMethod.GET})
    public String deleteApplicazione(@RequestParam(value="config") String config, @RequestParam(value="tipo") String tipoTxt, ModelMap model) {
        String jsp = DELETE;
        TalkManager talkManager = this.getTalkManager();
        try {
            ControllerHelper.checkEmpty("config", config);
            ConfigurationInstance instance = this.configurationLoader.loadConfigurationInstance(config);
            PrebillingConfiguration configuration = instance.getConfiguration();
            PrebillingDao prebillingDao = instance.getPrebillingDao();
            try {
                model.addAttribute("config", config);
                AbstractController.handleVersion(model, configuration);
                int tipo = ControllerHelper.checkInt("tipo", tipoTxt);
                Applicazione applicazione = prebillingDao.getApplicazione(tipo);
                model.addAttribute("applicazione", applicazione);
            }
            catch (InvalidParameterValue exc) {
                Message sentence = new Message("manage.applicazioni", "invalid.data");
                sentence.setCss("alert-warning");
                talkManager.addSentence(sentence);
                jsp = "redirect:/applicazioni.srvl";
            }
            catch (DataNotFoundException exc) {
                Message sentence = new Message("manage.applicazioni", "applicazione.notfound");
                sentence.addParam(exc.getKey());
                sentence.setCss("alert-warning");
                talkManager.addSentence(sentence);
                jsp = "redirect:/applicazioni.srvl";
            }
        }
        catch (IOException exc) {
            Warning sentence = new Warning("manage.applicazioni", "not.found.config");
            String message = exc.getMessage();
            sentence.addParam(message);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        catch (InvalidConfigurationException exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.applicazioni", message);
            String key = exc.getKey();
            sentence.addParam(key);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        catch (InvalidParameterValue exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.applicazioni", message);
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        return jsp;
    }

    /*
     * Loose catch block
     */
    @RequestMapping(value={"/deleteapplicazione.srvl"}, method={RequestMethod.POST})
    public String effettuaDelete(@RequestParam(value="tipo") String tipoTxt, @RequestParam(value="config") String config, ModelMap model) {
        String jsp = "redirect:/applicazioni.srvl";
        TalkManager talkManager = this.getTalkManager();
        try {
            ControllerHelper.checkEmpty("config", config);
            ConfigurationInstance instance = this.configurationLoader.loadConfigurationInstance(config);
            try {
                try {
                    PrebillingDao prebillingDao = instance.getPrebillingDao();
                    model.addAttribute("config", config);
                    int tipo = ControllerHelper.checkInt("tipo", tipoTxt);
                    Applicazione applicazione = prebillingDao.getApplicazione(tipo);
                    prebillingDao.deleteApplicazione(applicazione);
                }
                catch (InvalidParameterValue exc) {
                    Message sentence = new Message("manage.applicazioni", "invalid.data");
                    sentence.setCss("alert-warning");
                    talkManager.addSentence(sentence);
                    instance.closeConnections();
                }
                catch (NotDeletableException exc) {
                    Message sentence = new Message("manage.applicazioni", "delete.error");
                    sentence.setCss("alert-danger");
                    talkManager.addSentence(sentence);
                    instance.closeConnections();
                }
                catch (DataNotFoundException exc) {
                    Message sentence = new Message("manage.applicazioni", "applicazione.notfound");
                    sentence.addParam(exc.getKey());
                    sentence.setCss("alert-warning");
                    talkManager.addSentence(sentence);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    instance.closeConnections();
                }
            }
            finally {
                instance.closeConnections();
            }
        }
        catch (IOException exc) {
            Warning sentence = new Warning("manage.applicazioni", "not.found.config");
            String message = exc.getMessage();
            sentence.addParam(message);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidConfigurationException exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.applicazioni", message);
            String key = exc.getKey();
            sentence.addParam(key);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidParameterValue exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.applicazioni", message);
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (Exception exc) {
            String message = exc.getMessage();
            Message sentence = new Message("manage.applicazioni", message);
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        return jsp;
    }

    @RequestMapping(value={"/editapplicazione.srvl"}, method={RequestMethod.GET})
    public String edit(@RequestParam(value="tipo") String tipoTxt, @RequestParam(value="config") String config, ModelMap model) {
        String jsp = EDIT;
        TalkManager talkManager = this.getTalkManager();
        try {
            ControllerHelper.checkEmpty("config", config);
            ConfigurationInstance instance = this.configurationLoader.loadConfigurationInstance(config);
            try {
                try {
                    PrebillingConfiguration configuration = instance.getConfiguration();
                    PrebillingDao prebillingDao = instance.getPrebillingDao();
                    model.addAttribute("config", config);
                    ApplicazioniController.handleVersion(model, configuration);
                    int tipo = ControllerHelper.checkInt("tipo", tipoTxt);
                    Applicazione applicazione = prebillingDao.getApplicazione(tipo);
                    model.addAttribute("tipo", tipoTxt);
                    boolean spread = applicazione.isSpread();
                    model.addAttribute("spread", spread);
                }
                catch (DataNotFoundException exc) {
                    jsp = "redirect:/applicazioni.srvl";
                    Message sentence = new Message("manage.applicazioni", "applicazione.notfound");
                    sentence.addParam(exc.getKey());
                    sentence.setCss("alert-warning");
                    talkManager.addSentence(sentence);
                    instance.closeConnections();
                }
                catch (InvalidParameterValue exc) {
                    Message sentence = new Message("manage.applicazioni", "invalid.data");
                    sentence.setCss("alert-warning");
                    talkManager.addSentence(sentence);
                    jsp = "redirect:/applicazioni.srvl";
                    instance.closeConnections();
                }
            }
            finally {
                instance.closeConnections();
            }
        }
        catch (IOException exc) {
            Warning sentence = new Warning("manage.applicazioni", "not.found.config");
            String message = exc.getMessage();
            sentence.addParam(message);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidConfigurationException exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.applicazioni", message);
            String key = exc.getKey();
            sentence.addParam(key);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidParameterValue exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.applicazioni", message);
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (Exception exc) {
            String message = exc.getMessage();
            Message sentence = new Message("manage.applicazioni", message);
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        return jsp;
    }
}

