/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.utilities.aggregate;

import biz.elabor.prebilling.utilities.aggregate.ResultGiorno;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;

class ResultMese {
    private final int anno;
    private final Month mese;
    private final List<ResultGiorno> results;
    private final List<String> pods;

    public ResultMese(int anno, Month mese) {
        this.anno = anno;
        this.mese = mese;
        this.results = new ArrayList<ResultGiorno>();
        this.pods = new ArrayList<String>();
    }

    public void addCodicePod(String codicePod) {
        this.pods.add(codicePod);
    }

    public List<ResultGiorno> getResults() {
        return this.results;
    }

    public ResultGiorno get(int day) {
        int index = day - 1;
        if (index >= this.results.size()) {
            Date date = CalendarTools.getDate(this.anno, this.mese, day);
            ResultGiorno resultGiorno = new ResultGiorno(date);
            this.results.add(resultGiorno);
        }
        return this.results.get(index);
    }

    public List<String> getPods() {
        return this.pods;
    }
}

