/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.utilities.aggregate;

import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.config.FileConfiguration;
import biz.elabor.prebilling.dao.JdbcMisureDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.utilities.aggregate.ResultGiorno;
import biz.elabor.prebilling.utilities.aggregate.ResultMese;
import biz.elabor.prebilling.utilities.aggregate.ResultOra;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.DaysOfMonthIterable;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.csv.CsvReaderCloseable;
import org.homelinux.elabor.text.Format;

public class PDOAggregatiExtractor {
    private static final DecimalFormat MESE_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "00");
    private static final DecimalFormat ATTIVA_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "0.000");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public static void main(String[] args) throws IOException {
        String config = args[0];
        String podFileName = args[1];
        int anno = Integer.parseInt(args[2]);
        Month mese = Month.valueOf(Integer.parseInt(args[3]));
        PDOAggregatiExtractor.extract(config, podFileName, anno, mese);
    }

    private static void extract(String config, String podFileName, int anno, Month mese) throws IOException {
        File folder = new File(".");
        FileConfiguration configuration = new FileConfiguration(folder, config, "none");
        JdbcMisureDao misureDao = new JdbcMisureDao(configuration);
        ResultMese resultMese = PDOAggregatiExtractor.aggregate(podFileName, anno, mese, misureDao);
        PDOAggregatiExtractor.export(anno, mese, resultMese);
    }

    public static ResultMese aggregate(String podFileName, int anno, Month mese, MisureDao misureDao) throws IOException {
        ResultMese resultMese = new ResultMese(anno, mese);
        Throwable throwable = null;
        Object var6_7 = null;
        try (CsvReaderCloseable csvReader = new CsvReaderCloseable();){
            csvReader.setFile(podFileName);
            while (csvReader.hasNext()) {
                String[] row = csvReader.next();
                String codicePod = row[0].trim();
                System.out.println(String.valueOf(codicePod) + " " + anno + " " + (Object)((Object)mese));
                resultMese.addCodicePod(codicePod);
                List<Pdo> pdos = misureDao.getPdoMese(anno, mese, codicePod, null, Arrays.asList(StatoMisure.values()));
                PDOAggregatiExtractor.aggregate(pdos, anno, mese, resultMese);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return resultMese;
    }

    private static void aggregate(List<Pdo> pdos, int anno, Month mese, ResultMese resultMese) {
        if (pdos.isEmpty()) {
            RilMese rilMese = new RilMese(null, anno, mese, null);
            PDOAggregatiExtractor.aggregate(anno, mese, rilMese, resultMese);
        } else {
            for (Pdo pdo : pdos) {
                PDOAggregatiExtractor.aggregate(pdo, anno, mese, resultMese);
            }
        }
    }

    private static void aggregate(Pdo pdo, int anno, Month mese, ResultMese resultMese) {
        RilMese rilMese = pdo.getRilMese();
        PDOAggregatiExtractor.aggregate(anno, mese, rilMese, resultMese);
    }

    public static void aggregate(int anno, Month mese, RilMese rilMese, ResultMese resultMese) {
        for (int day : new DaysOfMonthIterable(anno, mese)) {
            Date date = CalendarTools.getDate(anno, mese, day);
            ResultGiorno resultGiorno = resultMese.get(day);
            RilGiorno rilGiorno = rilMese == null ? null : rilMese.getRilGiorno(date);
            PDOAggregatiExtractor.aggregate(rilGiorno, date, resultGiorno);
        }
    }

    private static void aggregate(RilGiorno rilGiorno, Date date, ResultGiorno resultGiorno) {
        int indexOra = 0;
        while (indexOra < CalendarTools.getHoursOfDay(date)) {
            Double attiva = null;
            double attivaValue = 0.0;
            int quarto = 0;
            while (quarto < 4) {
                Double value;
                RilQuarto rilQuarto;
                int indexQuarto = indexOra * 4 + quarto;
                if (rilGiorno != null && indexQuarto < rilGiorno.size() && (rilQuarto = (RilQuarto)rilGiorno.get(indexQuarto)) != null && (value = rilQuarto.getAttiva()) != null) {
                    double ka = rilQuarto.getKa();
                    attiva = attivaValue += value * ka;
                }
                ++quarto;
            }
            int ora = indexOra + 1;
            ResultOra resultOra = resultGiorno.get(ora);
            resultOra.aggregate(attiva);
            ++indexOra;
        }
    }

    private static void export(int anno, Month mese, ResultMese resultMese) throws FileNotFoundException {
        String idMese = MESE_FORMAT.format(mese.getIndex());
        Throwable throwable = null;
        Object var5_6 = null;
        try (PrintWriter writer = new PrintWriter("aggregate-" + anno + "-" + idMese + ".csv");){
            writer.print("data;ora;");
            for (String codicePod : resultMese.getPods()) {
                writer.print(String.valueOf(codicePod) + ";");
            }
            writer.println("totale;numero");
            for (ResultGiorno resultGiorno : resultMese.getResults()) {
                Date date = resultGiorno.getDate();
                String dateFmt = DATE_FORMAT.format(date);
                for (ResultOra resultOra : resultGiorno.getResults()) {
                    int ora = resultOra.getOra();
                    writer.print(String.valueOf(dateFmt) + ";" + ora + ";");
                    int count = 0;
                    double totale = 0.0;
                    for (Double value : resultOra.getValues()) {
                        if (value != null) {
                            double attiva = value;
                            String attivaFmt = ATTIVA_FORMAT.format(attiva);
                            writer.print(attivaFmt);
                            totale += attiva;
                            ++count;
                        }
                        writer.print(";");
                    }
                    String totaleFmt = ATTIVA_FORMAT.format(totale);
                    writer.println(String.valueOf(totaleFmt) + ";" + count);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

