/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.test;

import biz.elabor.prebilling.config.FileConfiguration;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.config.map.DefaultConfigurationInstance;
import biz.elabor.prebilling.dao.IndiciDao;
import biz.elabor.prebilling.dao.JdbcIndiciDao;
import biz.elabor.prebilling.dao.JdbcPrebillingDao;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.functest.TestInitialiser;
import biz.elabor.prebilling.test.AbstractPrebillingTest;
import biz.elabor.prebilling.test.Names;
import biz.elabor.prebilling.test.TestGiadaDao;
import biz.elabor.prebilling.test.TestInvalidParameterValue;
import biz.elabor.prebilling.test.TestMisureDao;
import biz.elabor.prebilling.web.common.JsonRequestHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import org.homelinux.elabor.db.DbmsType;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class PrebillingTest
extends AbstractPrebillingTest {
    private TestGiadaDao giadaDao;
    private TestMisureDao misureDao;
    private PrebillingDao prebillingDao;
    private IndiciDao indiciDao;
    private PrebillingConfiguration configuration;

    @Override
    protected void closeTest() {
        if (this.giadaDao != null) {
            this.giadaDao.close();
        }
        if (this.misureDao != null) {
            this.misureDao.close();
        }
        if (this.prebillingDao != null) {
            this.prebillingDao.close();
        }
        if (this.indiciDao != null) {
            this.indiciDao.close();
        }
    }

    @Override
    protected String performTest() throws TestInvalidParameterValue {
        String result;
        ConfigurationInstance configurationInstance = this.buildConfigurationInstance();
        try {
            JsonRequestHandler handler = PrebillingTest.buildHandler(configurationInstance);
            result = handler.handleRequest(configurationInstance);
        }
        catch (Exception exc) {
            throw new TestInvalidParameterValue(exc);
        }
        return result;
    }

    private static JsonRequestHandler buildHandler(ConfigurationInstance configurationInstance) throws IOException, ParseException {
        File initFile = new File(testFolder, "init.csv");
        String[] params = PrebillingTest.loadParams(initFile);
        TestInitialiser initialiser = TestInitialiser.valueOf(params[0].trim().toUpperCase());
        params = Arrays.copyOfRange(params, 1, params.length);
        TalkManager talkManager = PrebillingTest.buildTalkManager();
        return initialiser.loadHandler(params, configurationInstance, talkManager);
    }

    private ConfigurationInstance buildConfigurationInstance() {
        return new DefaultConfigurationInstance(this.prebillingDao, this.misureDao, this.giadaDao, this.indiciDao, this.configuration);
    }

    private void initDatabase(DbmsType dbType) throws IOException, SQLException, ParseException {
        this.clearDatabase();
        System.out.println("database cleared");
        File inputFolder = new File(testFolder, "input");
        PrebillingTest.importFiles(inputFolder, Names.GIADA_NAMES, this.giadaDao, dbType);
        PrebillingTest.importFiles(inputFolder, Names.MISURE_NAMES, this.misureDao, dbType);
    }

    private void clearDatabase() throws SQLException {
        PrebillingTest.clearDatabase(Names.GIADA_NAMES, this.giadaDao);
        PrebillingTest.clearDatabase(Names.MISURE_NAMES, this.misureDao);
    }

    @Override
    protected void dumpDatabase(File dumpFolder) throws SQLException, FileNotFoundException {
        dumpFolder.mkdirs();
        PrebillingTest.dumpFiles(dumpFolder, Names.GIADA_NAMES, this.giadaDao);
        PrebillingTest.dumpFiles(dumpFolder, Names.MISURE_NAMES, this.misureDao);
    }

    @Override
    protected void openTest(List<File> configFiles) throws IOException, SQLException, ParseException {
        this.configuration = new FileConfiguration(testFolder, configFiles, "test");
        DbmsType dbType = this.configuration.getGiadaType();
        this.giadaDao = new TestGiadaDao(this.configuration);
        this.misureDao = new TestMisureDao(this.configuration);
        this.prebillingDao = new JdbcPrebillingDao(this.configuration);
        this.indiciDao = new JdbcIndiciDao(this.configuration);
        this.initDatabase(dbType);
    }
}

