/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.periodo;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Mno2GE;
import biz.elabor.prebilling.services.xml.AbstractGetXmlStrategy;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.periodo.GetPno2GPeriodoXmlGetter;
import biz.elabor.prebilling.services.xml.periodo.GetPnoEA;
import biz.elabor.prebilling.services.xml.periodo.GetPnoER;
import biz.elabor.prebilling.web.xml.IsolableServiceStrategy;
import biz.elabor.prebilling.web.xml.Partition;
import biz.elabor.prebilling.web.xml.filtri.FiltriXml;
import java.util.List;
import org.homelinux.elabor.structures.listmap.ListMap;

public class GetPno2GXmlStrategy
extends AbstractGetXmlStrategy
implements IsolableServiceStrategy {
    private final String azienda;

    public GetPno2GXmlStrategy(String azienda, FiltriXml filtri, MisureDao misureDao) {
        super(filtri, misureDao);
        this.azienda = azienda;
    }

    @Override
    public boolean executePartition(ServiceStatus status, Partition partition) {
        GetPno2GPeriodoXmlGetter periodo2GGetter = new GetPno2GPeriodoXmlGetter(partition);
        List<Mno> misure = this.getFlussiRaccolta(this.azienda, TipoFlusso.PNO2G, periodo2GGetter);
        status.setPno2GXml(misure);
        this.set2GE(status, partition, this.azienda);
        return true;
    }

    private void set2GE(ServiceStatus status, Partition partition, String azienda) {
        GetPnoEA getterA = new GetPnoEA();
        List<Mno2GE> misureA = this.getFlussi(azienda, TipoFlusso.PNO2G, partition, getterA);
        if (!misureA.isEmpty()) {
            GetPnoER getterR = new GetPnoER();
            List<Mno2GE> misureR = this.getFlussi(azienda, TipoFlusso.PNO2G, partition, getterR);
            ListMap<String, Mno2GE> misureRMap = GetPno2GXmlStrategy.buildMisureMap(misureR);
            status.setMisure2gEA(misureA);
            status.setMisure2gER(GetPno2GXmlStrategy.getMisure(misureRMap, "T"));
            status.setMisure2gERc(GetPno2GXmlStrategy.getMisure(misureRMap, "C"));
            status.setMisure2gERi(GetPno2GXmlStrategy.getMisure(misureRMap, "I"));
        }
    }

    @Override
    public boolean execute(ServiceStatus status) {
        throw new RuntimeException("not allowed");
    }
}

