/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.export;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.d479.DefaultMnoDatiPodPrinter;
import biz.elabor.prebilling.services.xml.d65.BasicExtraPrinter;
import biz.elabor.prebilling.services.xml.d65.ExtraPrinter;
import biz.elabor.prebilling.services.xml.export.AbstractExportXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportXmlHandler;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public class ExportVp2gXmlStrategy
extends AbstractExportXmlStrategy<Mno> {
    private static final ExtraPrinter<Mno> EXTRA_PRINTER = new BasicExtraPrinter<Mno>();
    private final ExportXmlHandler handler;

    public ExportVp2gXmlStrategy(Funzionalita funzionalita, ExportXmlHandler handler, String reseller, PrebillingConfiguration configuration, TalkManager talkManager, String folderSuffix) {
        super(TipoFlusso.VP2G, funzionalita, configuration, reseller, talkManager, folderSuffix);
        this.handler = handler;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        ListMap<Delibera, Mno> snms = this.handler.getVp2gs(status);
        return this.export(snms, status);
    }

    @Override
    public void printItem(Mno item, ServiceStatus status, PrintWriter writer) {
        String className = this.getClass().getSimpleName();
        if (item.getDelibera().isDelibera65()) {
            HashSet<String> banned = new HashSet<String>();
            ExportXmlHelper.printDatiPod(className, item, null, banned, EXTRA_PRINTER, this.configuration, writer, this.itEnergyFormat, this.longDataFormat, this.dataFormat);
        } else {
            Map<String, String> misureType = status.getMisureType();
            DefaultMnoDatiPodPrinter datiPodPrinter = new DefaultMnoDatiPodPrinter(this.configuration, misureType);
            datiPodPrinter.print(className, item, writer);
        }
        MnoResult result = new MnoResult(item, ErroriElaborazione.OK, "");
        status.addSnmEsportato(result);
    }
}

