/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.export;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.model.misure.Snf;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.SnfResult;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.d479.SnfDatiPodPrinter;
import biz.elabor.prebilling.services.xml.export.AbstractExportXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportXmlHandler;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public class ExportSnfXmlStrategy
extends AbstractExportXmlStrategy<Snf> {
    private final ExportXmlHandler handler;

    public ExportSnfXmlStrategy(Funzionalita funzionalita, ExportXmlHandler handler, String reseller, PrebillingConfiguration configuration, TalkManager talkManager, String folderSuffix) {
        super(TipoFlusso.SNF, funzionalita, configuration, reseller, talkManager, folderSuffix);
        this.handler = handler;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        ListMap<Delibera, Snf> snfs = this.handler.getSnfs(status);
        return this.export(snfs, status);
    }

    @Override
    public void printItem(Snf item, ServiceStatus status, PrintWriter writer) {
        String className = this.getClass().getSimpleName();
        if (item.getDelibera().isDelibera65()) {
            ExportXmlHelper.printDatiPod(className, item, this.configuration, writer, this.itEnergyFormat, this.longDataFormat, this.dataFormat);
        } else {
            SnfDatiPodPrinter<Snf> datiPodPrinter = new SnfDatiPodPrinter<Snf>();
            datiPodPrinter.print(className, item, writer);
        }
        SnfResult result = new SnfResult(item, ErroriElaborazione.OK, "");
        status.addSnfEsportato(result);
    }
}

