/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.export;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.PdoResult;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.d479.PDODatiPodPrinter;
import biz.elabor.prebilling.services.xml.d65.BasicExtraPrinter;
import biz.elabor.prebilling.services.xml.d65.ExtraPrinter;
import biz.elabor.prebilling.services.xml.export.AbstractExportXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportXmlHandler;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import biz.elabor.prebilling.web.xml.IsolableServiceStrategy;
import biz.elabor.prebilling.web.xml.Partition;
import java.io.PrintWriter;
import java.util.Map;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public class ExportPdoXmlStrategy
extends AbstractExportXmlStrategy<Pdo>
implements IsolableServiceStrategy {
    private static final ExtraPrinter<Pdo> EXTRA_PRINTER = new BasicExtraPrinter<Pdo>();
    private ExportXmlHandler handler;

    public ExportPdoXmlStrategy(Funzionalita funzionalita, TipoFlusso tipo, String reseller, ExportXmlHandler handler, PrebillingConfiguration configuration, TalkManager talkManager, String folderSuffix) {
        super(tipo, funzionalita, configuration, reseller, talkManager, folderSuffix);
        this.handler = handler;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        ListMap<Delibera, Pdo> pdos = this.handler.getPdos(status);
        return this.export(pdos, status);
    }

    @Override
    public void printItem(Pdo item, ServiceStatus status, PrintWriter writer) {
        String className = this.getClass().getSimpleName();
        if (item.getDelibera().isDelibera65()) {
            ExportXmlHelper.printDatiPod(className, item, EXTRA_PRINTER, this.configuration, writer, this.giornoFormat, this.meseFormat, this.itEnergyFormat, this.longDataFormat, this.dataFormat);
        } else {
            Map<String, String> misuraType = status.getMisureType();
            PDODatiPodPrinter datiPodPrinter = new PDODatiPodPrinter(this.configuration, misuraType);
            datiPodPrinter.print(className, item, writer);
        }
        PdoResult result = new PdoResult(item, ErroriElaborazione.OK, "");
        status.addPdoEsportato(result);
    }

    @Override
    public boolean executePartition(ServiceStatus status, Partition partition) {
        return this.execute(status);
    }
}

