/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.ds;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.d479.RettificheDatiPodPrinter;
import biz.elabor.prebilling.services.xml.d65.BasicExtraPrinter;
import biz.elabor.prebilling.services.xml.d65.ExtraPrinter;
import biz.elabor.prebilling.services.xml.d65.RettificaExtraPrinter;
import biz.elabor.prebilling.services.xml.export.AbstractExportXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportXmlHandler;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public class ExportDSRXmlStrategy
extends AbstractExportXmlStrategy<Mno> {
    private ExportXmlHandler handler;
    private static final ExtraPrinter<Mno> EXTRA_PRINTER = new RettificaExtraPrinter<Mno>(new BasicExtraPrinter());

    public ExportDSRXmlStrategy(ExportXmlHandler handler, String reseller, PrebillingConfiguration configuration, TalkManager talkManager, String folderSuffix) {
        super(TipoFlusso.DSR, Funzionalita.XML_DEL65, configuration, reseller, talkManager, folderSuffix);
        this.handler = handler;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        ListMap<Delibera, Mno> rnos = this.handler.getDSRs(status);
        return this.export(rnos, status);
    }

    @Override
    public void printItem(Mno item, ServiceStatus status, PrintWriter writer) {
        String className = this.getClass().getSimpleName();
        Delibera delibera = item.getDelibera();
        if (delibera.isDelibera65()) {
            HashSet<String> banned = new HashSet<String>();
            ExportXmlHelper.printDatiPod(className, item, null, banned, EXTRA_PRINTER, this.configuration, writer, this.itEnergyFormat, this.longDataFormat, this.dataFormat);
        } else {
            Map<String, String> misureType = status.getMisureType();
            RilGiorno rilgiorno = this.handler.getRilGiorno(item, status);
            String potMax = this.handler.getPotMax(item);
            Date dataPrest = this.handler.getDataPrest(item);
            String codPratSII = this.handler.getCodPratSii(item);
            String causaOstativa = item.getCausaOstativa();
            RettificheDatiPodPrinter datiPodPrinter = new RettificheDatiPodPrinter(potMax, causaOstativa, dataPrest, codPratSII, rilgiorno, this.configuration, misureType);
            datiPodPrinter.print(className, item, writer);
        }
        MnoResult result = new MnoResult(item, ErroriElaborazione.OK, "");
        status.addRnoEsportato(result);
    }
}

