/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.d65;

import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.d65.ExtraPrinter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public class RettificaVolturaExtraPrinter
implements ExtraPrinter<Mno> {
    private final ExtraPrinter<Mno> baseExtraPrinter;
    private final DateFormat dataFormat;

    public RettificaVolturaExtraPrinter(ExtraPrinter<Mno> baseExtraPrinter) {
        this.baseExtraPrinter = baseExtraPrinter;
        this.dataFormat = StrategyHelper.getDataFormat();
    }

    @Override
    public void print(Mno dati, Date dataMisura, PrintWriter writer) {
        Date dataVoltura = dati.getDataVoltura();
        if (dataVoltura != null) {
            String dataString = this.dataFormat.format(dataVoltura);
            writer.println("<DataVoltura>" + dataString + "</DataVoltura>");
        }
        this.baseExtraPrinter.print(dati, dataMisura, writer);
        if (!dati.getDelibera().isDelibera65()) {
            writer.println("<TipoRettifica>" + dati.getTipoRettifica() + "</TipoRettifica>");
            Date dataRilevazione = dati.getDataRilevazione();
            if (dataRilevazione != null) {
                String dataString = this.dataFormat.format(dataRilevazione);
                writer.println("<DataRilevazione>" + dataString + "</DataRilevazione>");
            }
        }
        writer.println("<Motivazione>" + dati.getMotivazione() + "</Motivazione>");
    }
}

