/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.d479;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.services.StrategyHelper;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class SmisDatiPodPrinter {
    private static final String[] KEYS = new String[]{"TipoMisuratore", "DataMisura", "DataMessaRegime2G", "TipoDato", "Tensione", "Ka", "Kr", "Kp", "MatrAtt", "MatrRea", "MatrPot", "CifreAtt", "CifreRea", "CifrePot", "EaF1", "EaF2", "EaF3", "EaF4", "EaF5", "EaF6", "ErF1", "ErF2", "ErF3", "ErF4", "ErF5", "ErF6", "PotF1", "PotF2", "PotF3", "PotF4", "PotF5", "PotF6", "ErcF1", "ErcF2", "ErcF3", "ErcF4", "ErcF5", "ErcF6", "EriF1", "EriF2", "EriF3", "EriF4", "EriF5", "EriF6", "EaM", "ErM", "PotM"};
    private final PrebillingConfiguration configuration;
    private final DecimalFormat itEnergyFormat;
    private final DateFormat dataFormat;
    private DateFormat longDataFormat;

    public SmisDatiPodPrinter(PrebillingConfiguration configuration) {
        this.configuration = configuration;
        this.itEnergyFormat = StrategyHelper.getItEnergyFormat();
        this.dataFormat = StrategyHelper.getDataFormat();
        this.longDataFormat = StrategyHelper.getFullDateFormat();
    }

    public void print(Mno smontaggio, Mno montaggio, PrintWriter writer) {
        String codicePod = montaggio.getCodicePod();
        String motivazione = montaggio.getMotivazione();
        writer.println("<DatiPod>");
        writer.println("<Pod>" + codicePod + "</Pod>");
        writer.println("<Motivazione>" + motivazione + "</Motivazione>");
        if (smontaggio != null) {
            double ka = StrategyHelper.getK(smontaggio.getKa());
            double kr = StrategyHelper.getK(smontaggio.getKr());
            double kp = StrategyHelper.getK(smontaggio.getKp());
            Map<String, String> mapPrevious = this.generaSmontaggioMap(smontaggio);
            this.printSmis(mapPrevious, "Smontaggio", writer, ka, kr, kp);
        }
        Map<String, String> mapActual = this.generaMontaggioMap(montaggio);
        double ka = StrategyHelper.getK(montaggio.getKa());
        double kr = StrategyHelper.getK(montaggio.getKr());
        double kp = StrategyHelper.getK(montaggio.getKp());
        this.printSmis(mapActual, "Montaggio", writer, ka, kr, kp);
        writer.println("</DatiPod>");
    }

    private void printSmis(Map<String, String> map, String tipoTabella, PrintWriter writer, double ka, double kr, double kp) {
        writer.println("<" + tipoTabella + ">");
        String[] stringArray = KEYS;
        int n2 = KEYS.length;
        int n3 = 0;
        while (n3 < n2) {
            String key = stringArray[n3];
            String value = map.get(key);
            if (value != null) {
                StrategyHelper.print(false, this.itEnergyFormat, this.configuration, writer, key, value, null, this.longDataFormat, this.dataFormat, ka, kr, kp);
            }
            ++n3;
        }
        writer.println("</" + tipoTabella + ">");
    }

    private Map<String, String> generaSmontaggioMap(Mno smontaggio) {
        Map<String, String> map = this.generaBasicMap(smontaggio);
        String tipoDato = smontaggio.getTipoDato();
        map.put("TipoDato", tipoDato);
        return map;
    }

    private Map<String, String> generaMontaggioMap(Mno montaggio) {
        Map<String, String> map = this.generaBasicMap(montaggio);
        String ka = montaggio.getKaSegnale();
        String kr = montaggio.getKrSegnale();
        String kp = montaggio.getKpSegnale();
        String matricolaAtt = montaggio.getMatricolaAtt();
        String matricolaRea = montaggio.getMatricolaRea();
        String matricolaPot = montaggio.getMatricolaPot();
        String tensione = montaggio.getTensione();
        String getcifreAtt = montaggio.getCifreAtt();
        String cifreRea = montaggio.getCifreRea();
        String cifrePot = montaggio.getCifrePot();
        map.put("Ka", ka);
        map.put("Kr", kr);
        map.put("Kp", kp);
        map.put("MatrAtt", matricolaAtt);
        map.put("MatrRea", matricolaRea);
        map.put("MatrPot", matricolaPot);
        map.put("Tensione", tensione);
        map.put("CifreAtt", getcifreAtt);
        map.put("CifreRea", cifreRea);
        map.put("CifrePot", cifrePot);
        Date data = montaggio.getDataMessaRegime2G();
        if (data != null) {
            map.put("DataMessaRegime2G", this.dataFormat.format(data));
        }
        return map;
    }

    private Map<String, String> generaBasicMap(Mno mno) {
        Date dataMisura = mno.getDataMisura();
        String dataString = this.dataFormat.format(dataMisura);
        String tipoMisuratore = mno.getTipoMisuratore();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("TipoMisuratore", tipoMisuratore);
        map.put("DataMisura", dataString);
        if (mno.getTrattamento().isMono()) {
            String eam = mno.getEAM();
            String erm = mno.getERM();
            String potm = mno.getPotMOrig();
            map.put("EaM", eam);
            map.put("ErM", erm);
            map.put("PotM", potm);
        } else {
            String eaf1 = mno.getEAF1();
            String eaf2 = mno.getEAF2();
            String eaf3 = mno.getEAF3();
            String eaf4 = mno.getEAF4();
            String eaf5 = mno.getEAF5();
            String eaf6 = mno.getEAF6();
            String erf1 = mno.getERF1();
            String erf2 = mno.getERF2();
            String erf3 = mno.getERF3();
            String erf4 = mno.getERF4();
            String erf5 = mno.getERF5();
            String erf6 = mno.getERF6();
            String ercf1 = mno.getERCF1();
            String ercf2 = mno.getERCF2();
            String ercf3 = mno.getERCF3();
            String ercf4 = mno.getERCF4();
            String ercf5 = mno.getERCF5();
            String ercf6 = mno.getERCF6();
            String erif1 = mno.getERIF1();
            String erif2 = mno.getERIF2();
            String erif3 = mno.getERIF3();
            String erif4 = mno.getERIF4();
            String erif5 = mno.getERIF5();
            String erif6 = mno.getERIF6();
            String potF1 = mno.getPotF1Orig();
            String potF2 = mno.getPotF2Orig();
            String potF3 = mno.getPotF3Orig();
            String potF4 = mno.getPotF4Orig();
            String potF5 = mno.getPotF5Orig();
            String potF6 = mno.getPotF6Orig();
            map.put("EaF1", eaf1);
            map.put("EaF2", eaf2);
            map.put("EaF3", eaf3);
            map.put("EaF4", eaf4);
            map.put("EaF5", eaf5);
            map.put("EaF6", eaf6);
            map.put("ErF1", erf1);
            map.put("ErF2", erf2);
            map.put("ErF3", erf3);
            map.put("ErF4", erf4);
            map.put("ErF5", erf5);
            map.put("ErF6", erf6);
            map.put("PotF1", potF1);
            map.put("PotF2", potF2);
            map.put("PotF3", potF3);
            map.put("PotF4", potF4);
            map.put("PotF5", potF5);
            map.put("PotF6", potF6);
            map.put("ErcF1", ercf1);
            map.put("ErcF2", ercf2);
            map.put("ErcF3", ercf3);
            map.put("ErcF4", ercf4);
            map.put("ErcF5", ercf5);
            map.put("ErcF6", ercf6);
            map.put("EriF1", erif1);
            map.put("EriF2", erif2);
            map.put("EriF3", erif3);
            map.put("EriF4", erif4);
            map.put("EriF5", erif5);
            map.put("EriF6", erif6);
        }
        return map;
    }
}

