/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.d479;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.services.xml.d479.AbstractRMNODatiPodPrinter;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;

public class RettificheDatiPodPrinter
extends AbstractRMNODatiPodPrinter {
    private String potMax;
    private Date dataPrest;
    private String codPratSII;
    private String causaOstativa;

    public RettificheDatiPodPrinter(String potMax, String causaOstativa, Date dataPrest, String codPratSII, RilGiorno rilGiorno, PrebillingConfiguration configuration, Map<String, String> misuraType) {
        super(configuration, misuraType, rilGiorno);
        this.potMax = potMax;
        this.causaOstativa = causaOstativa;
        this.dataPrest = dataPrest;
        this.codPratSII = codPratSII;
    }

    @Override
    public void printDatiPod(Mno mno, PrintWriter writer) {
        Date dataMisura = mno.getDataMisura();
        if (Trattamento.O.equals((Object)mno.getTrattamento())) {
            ExportXmlHelper.printTag("MeseAnno", dataMisura, writer, this.meseAnnoFormat);
        } else {
            ExportXmlHelper.printTag("DataMisura", dataMisura, writer, this.dataFormat);
        }
        ExportXmlHelper.printTag("TipoRettifica", mno.getTipoRettifica(), writer);
        ExportXmlHelper.printTag("DataRilevazione", mno.getDataRilevazione(), writer, this.dataFormat);
        ExportXmlHelper.printTag("Motivazione", mno.getMotivazione(), writer);
        ExportXmlHelper.printTag("DataPrest", this.dataPrest, writer, this.dataFormat);
        ExportXmlHelper.printTag("CodPrat_SII", this.codPratSII, writer);
        this.printDatiPdp(mno, writer);
        this.printMisura(mno, this.potMax, this.causaOstativa, this.rilGiorno, writer);
    }
}

