/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.d479;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.d479.AbstractOrariDatiPodPrinter;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.Month;

public class PDODatiPodPrinter
extends AbstractOrariDatiPodPrinter {
    public PDODatiPodPrinter(PrebillingConfiguration configuration, Map<String, String> misuraType) {
        super(configuration, misuraType);
    }

    @Override
    public void printDatiPod(Pdo pdo, PrintWriter writer) {
        RilMese rilMese = pdo.getRilMese();
        int anno = rilMese.getAnno();
        Month mese = rilMese.getMese();
        int meseIndice = mese.getIndex();
        String meseTxt = this.meseFormat.format(meseIndice);
        String meseAnno = String.valueOf(meseTxt) + "/" + anno;
        ExportXmlHelper.printTag("MeseAnno", meseAnno, writer);
        this.printDatiPdp(pdo, writer);
        this.printMisura(pdo, writer);
    }

    @Override
    protected void printDatiPdp(Pdo pdo, PrintWriter writer) {
        writer.println("<DatiPdp>");
        String trattamento = pdo.getTrattamento().name();
        ExportXmlHelper.printTag("Trattamento", trattamento, writer);
        ExportXmlHelper.printTag("Tensione", pdo.getTensione(), writer);
        String forfait = pdo.getForfait() == null || pdo.getForfait().isEmpty() ? "NO" : pdo.getForfait();
        String gruppoMisura = pdo.getGruppoMisura() == null || pdo.getGruppoMisura().isEmpty() ? "SI" : pdo.getGruppoMisura();
        ExportXmlHelper.printTag("Forfait", forfait, writer);
        ExportXmlHelper.printTag("GruppoMis", gruppoMisura, writer);
        String kaString = pdo.getKaString();
        String krString = pdo.getKrString();
        String kpString = pdo.getKpString();
        double ka = pdo.getKa();
        double kr = pdo.getKr();
        double kp = pdo.getKp();
        StrategyHelper.print(false, this.itEnergyFormat, this.configuration, writer, "Ka", kaString, null, this.longDataFormat, this.dataFormat, ka, kr, kp);
        StrategyHelper.print(false, this.itEnergyFormat, this.configuration, writer, "Kr", krString, null, this.longDataFormat, this.dataFormat, ka, kr, kp);
        StrategyHelper.print(false, this.itEnergyFormat, this.configuration, writer, "Kp", kpString, null, this.longDataFormat, this.dataFormat, ka, kr, kp);
        writer.println("</DatiPdp>");
    }

    @Override
    public void printDatiMisura(Pdo pdo, PrintWriter writer, Set<String> banned) {
        String raccolta = pdo.getRaccolta();
        ExportXmlHelper.printTag("Raccolta", raccolta, writer);
        String tipoDato = pdo.getTipoDato();
        ExportXmlHelper.printTag("TipoDato", tipoDato, writer);
        if (tipoDato.equals("S")) {
            String motivazioneStima = pdo.getMotivazioneStima();
            ExportXmlHelper.printTag("CausaOstativa", motivazioneStima, writer);
        }
        ExportXmlHelper.printTag("Validato", pdo.getValidato(), writer);
        String potMax = pdo.getPotMax().toString();
        double ka = pdo.getKa();
        double kr = pdo.getKr();
        double kp = pdo.getKp();
        StrategyHelper.print(false, this.itEnergyFormat, this.configuration, writer, "PotMax", potMax, null, this.longDataFormat, this.dataFormat, ka, kr, kp);
        ExportXmlHelper.printCurva(pdo, writer, this.giornoFormat, this.itEnergyFormat);
        Map<String, String> dettagli = pdo.getDatiPod().get("Misura");
        banned.addAll(PDODatiPodPrinter.buildBanned());
        StrategyHelper.printValueMap(dettagli, null, banned, false, this.itEnergyFormat, this.configuration, writer, this.longDataFormat, this.dataFormat, ka, kr, kp);
    }
}

