/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.d479;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.d479.SNM2GDatiPodPrinter;
import biz.elabor.prebilling.services.xml.export.AbstractExportXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportXmlHandler;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class ExportSnm2GXmlStrategy
extends AbstractExportXmlStrategy<Mno> {
    private final ExportXmlHandler handler;

    public ExportSnm2GXmlStrategy(Funzionalita funzionalita, ExportXmlHandler handler, String reseller, PrebillingConfiguration configuration, TalkManager talkManager, String folderSuffix) {
        super(TipoFlusso.SNM2G, funzionalita, configuration, reseller, talkManager, folderSuffix);
        this.handler = handler;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        List<Mno> snms = this.handler.getSnms2g(status);
        return this.export(Delibera.D479, snms, status);
    }

    @Override
    public void printItem(Mno item, ServiceStatus status, PrintWriter writer) {
        Class<?> thisClass = this.getClass();
        String className = thisClass.getSimpleName();
        Map<String, String> misureType = status.getMisureType();
        SNM2GDatiPodPrinter datiPodPrinter = new SNM2GDatiPodPrinter(this.configuration, misureType);
        datiPodPrinter.print(className, item, writer);
        MnoResult result = new MnoResult(item, ErroriElaborazione.OK, "");
        status.addSnmEsportato(result);
    }
}

