/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.d479;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Mno2GE;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.d479.Misure2GRDatiPodPrinter;
import biz.elabor.prebilling.services.xml.export.AbstractExportXmlStrategy;
import biz.elabor.prebilling.services.xml.export.ExportXmlHandler;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import biz.elabor.prebilling.web.xml.IsolableServiceStrategy;
import biz.elabor.prebilling.web.xml.Partition;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.classifier.RecordMap;

public class Export2GXmlStrategy
extends AbstractExportXmlStrategy<Mno>
implements IsolableServiceStrategy {
    private final ExportXmlHandler handler;
    private RecordMap<String, Mno2GE> misure2gea;
    private RecordMap<String, Mno2GE> misure2ger;
    private RecordMap<String, Mno2GE> misure2gerc;
    private RecordMap<String, Mno2GE> misure2geri;
    protected final Trattamento trattamento;

    public Export2GXmlStrategy(TipoFlusso tipo, Funzionalita funzionalita, ExportXmlHandler handler, String reseller, PrebillingConfiguration configuration, TalkManager talkManager, String folderSuffix) {
        this(tipo, funzionalita, handler, reseller, configuration, talkManager, folderSuffix, null);
    }

    public Export2GXmlStrategy(TipoFlusso tipo, Funzionalita funzionalita, ExportXmlHandler handler, String reseller, PrebillingConfiguration configuration, TalkManager talkManager, String folderSuffix, Trattamento trattamento) {
        super(tipo, funzionalita, configuration, reseller, talkManager, folderSuffix);
        this.handler = handler;
        this.trattamento = trattamento;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        this.misure2gea = this.handler.getMisure2gEA(status);
        this.misure2ger = this.handler.getMisure2gER(status);
        this.misure2gerc = this.handler.getMisure2gERc(status);
        this.misure2geri = this.handler.getMisure2gERi(status);
        List<Mno> misure2g = this.handler.getMisure2g(status);
        return this.export(Delibera.D479, misure2g, status);
    }

    @Override
    public void printItem(Mno item, ServiceStatus status, PrintWriter writer) {
        RilGiorno rilGiorno = this.getRilGiorno(item);
        Class<?> thisClass = this.getClass();
        String className = thisClass.getSimpleName();
        Map<String, String> misureType = status.getMisureType();
        ExportXmlHelper.fillDatiMisura(item, this.misure2gerc, this.misure2geri, rilGiorno, this.itEnergyFormat);
        this.print(className, item, rilGiorno, misureType, writer);
        MnoResult result = new MnoResult(item, ErroriElaborazione.OK, "");
        this.handler.addEsportato(status, result);
    }

    protected void print(String className, Mno item, RilGiorno rilGiorno, Map<String, String> misureType, PrintWriter writer) {
        Misure2GRDatiPodPrinter datiPodPrinter = new Misure2GRDatiPodPrinter(rilGiorno, null, this.configuration, misureType, this.trattamento);
        datiPodPrinter.print(className, item, writer);
    }

    private RilGiorno getRilGiorno(Mno item) {
        return Export2GXmlStrategy.getRilgiorno(item, this.misure2gea, this.misure2ger, this.misure2gerc, this.misure2geri);
    }

    private static RilGiorno getRilgiorno(Mno item, RecordMap<String, Mno2GE> pno2gea, RecordMap<String, Mno2GE> pno2ger, RecordMap<String, Mno2GE> pno2gerc, RecordMap<String, Mno2GE> pno2geri) {
        String codicePod = item.getCodicePod();
        Date data = item.getDataMisura();
        String key = Mno2GE.getKey(codicePod, data);
        Mno2GE pno2geaPod = pno2gea.get(key);
        Mno2GE pno2gerPod = pno2ger.get(key);
        Mno2GE pno2gercPod = pno2gerc.get(key);
        Mno2GE pno2geriPod = pno2geri.get(key);
        String codiceFlusso = item.getCodiceFlusso();
        String id = item.getFirstId();
        return ExportXmlHelper.buildRilGiorno(data, codiceFlusso, id, pno2geaPod, pno2gerPod, pno2gercPod, pno2geriPod);
    }

    @Override
    public boolean executePartition(ServiceStatus status, Partition partition) {
        return this.execute(status);
    }
}

