/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.d479;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.d479.AbstractDatiPodPrinter;
import biz.elabor.prebilling.services.xml.d479.DataMisuraTrattamentoVisitor;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;

public abstract class AbstractMNODatiPodPrinter
extends AbstractDatiPodPrinter<Mno> {
    private final Trattamento trattamento;
    protected final RilGiorno rilGiorno;

    public AbstractMNODatiPodPrinter(PrebillingConfiguration configuration, Map<String, String> misuraType, Trattamento trattamento, RilGiorno rilGiorno) {
        super(configuration, misuraType);
        this.trattamento = trattamento;
        this.rilGiorno = rilGiorno;
    }

    @Override
    public void printDatiPod(Mno mno, PrintWriter writer) {
        Date dataMisura = mno.getDataMisura();
        Trattamento trattamentoEfficace = this.trattamento == null ? mno.getTrattamento() : this.trattamento;
        trattamentoEfficace.accept(new DataMisuraTrattamentoVisitor(dataMisura, this.rilGiorno, writer));
        String raccolta = mno.getRaccolta();
        if (raccolta != null && (raccolta.equals("S") || raccolta.equals("V") || raccolta.equals("T"))) {
            Date dataPrestazione = mno.getDataPrestazione();
            ExportXmlHelper.printTag("DataPrest", dataPrestazione, writer, this.dataFormat);
        }
        if (raccolta != null && (raccolta.equals("S") || raccolta.equals("V") || raccolta.equals("T"))) {
            String codPratAtt = mno.getCodPratAtt();
            ExportXmlHelper.printTag("CodPrat_SII", codPratAtt, writer);
        }
        this.printDatiPdp(mno, writer);
        if (mno.isForfait()) {
            this.printConsumo(mno, writer);
        } else {
            this.printMisura(mno, writer);
        }
    }

    public final void printConsumo(Mno mno, PrintWriter writer) {
        String idTipoMisura = mno.getIdTipoMisura();
        if (idTipoMisura == null) {
            writer.println("<Consumo>");
        } else {
            writer.println("<Consumo xsi:type=\"" + this.getTipoMisura(idTipoMisura) + "\">");
        }
        ExportXmlHelper.printTag("DataInizioPeriodo", mno.getDataInizioPeriodo(), writer, this.dataFormat);
        this.printDatiMisura(mno, writer, new HashSet<String>());
        writer.println("</Consumo>");
    }

    public void printDatiPdp(Mno mno, PrintWriter writer) {
        writer.println("<DatiPdp>");
        String trattamentoEfficace = mno.getTrattamento().name();
        ExportXmlHelper.printTag("Trattamento", trattamentoEfficace, writer);
        ExportXmlHelper.printTag("Tensione", mno.getTensione(), writer);
        ExportXmlHelper.printTag("Forfait", mno.getForfait(), writer);
        ExportXmlHelper.printTag("GruppoMis", mno.getGruppoMisura(), writer);
        String kaString = mno.getKaSegnale();
        String krString = mno.getKrSegnale();
        String kpString = mno.getKpSegnale();
        double ka = kaString == null ? 0.0 : mno.getKa().doubleValue();
        double kr = krString == null ? 0.0 : mno.getKr().doubleValue();
        double kp = kpString == null ? 0.0 : mno.getKp().doubleValue();
        StrategyHelper.print(false, this.itEnergyFormat, this.configuration, writer, "Ka", kaString, null, this.longDataFormat, this.dataFormat, ka, kr, kp);
        StrategyHelper.print(false, this.itEnergyFormat, this.configuration, writer, "Kr", krString, null, this.longDataFormat, this.dataFormat, ka, kr, kp);
        StrategyHelper.print(false, this.itEnergyFormat, this.configuration, writer, "Kp", kpString, null, this.longDataFormat, this.dataFormat, ka, kr, kp);
        writer.println("</DatiPdp>");
    }
}

