/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.d479;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.model.misure.DatiFunzionali;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.d479.DatiPodPrinter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;

public class AbstractFlussoFDatiPodPrinter<T extends DatiFunzionali>
implements DatiPodPrinter<T> {
    protected final DateFormat dateFormat = StrategyHelper.getDataFormat();
    protected final DecimalFormat itEnergyFormat = StrategyHelper.getItEnergyFormat();

    @Override
    public void print(String context, T item, PrintWriter writer) {
        String codicePod = item.getCodicePod();
        PrebillingContext.setContext(context, "pod: " + codicePod);
        writer.println("<DatiPod>");
        writer.println("<Pod>" + codicePod + "</Pod>");
        String codPratAtt = item.getCodPratAtt();
        writer.println("<CodPrat_SII>" + codPratAtt + "</CodPrat_SII>");
        Date dataInizio = item.getDataInizio();
        String dataString = this.dateFormat.format(dataInizio);
        writer.println("<DataInizio>" + dataString + "</DataInizio>");
        this.printDatiPdp(item, writer);
        writer.println("</DatiPod>");
    }

    protected void printDatiPdp(T item, PrintWriter writer) {
        writer.println("<DatiPdp>");
        writer.println("<PuntoDispacciamento>" + item.getPuntoDispacciamento() + "</PuntoDispacciamento>");
        String tipoMisuratore = item.getTipoMisuratore();
        AbstractFlussoFDatiPodPrinter.printIfAvailable("TipoMisuratore", tipoMisuratore, writer);
        Date dataMessaRegime = item.getDataMessaRegime();
        AbstractFlussoFDatiPodPrinter.printIfAvailable("DataMessaRegime2G", dataMessaRegime, this.dateFormat, writer);
        Trattamento trattamento = item.getTrattamento();
        AbstractFlussoFDatiPodPrinter.printIfAvailable("Trattamento", trattamento.name(), writer);
        writer.println("<Tensione>" + item.getTensione() + "</Tensione>");
        Number potImp = item.getPotImp();
        AbstractFlussoFDatiPodPrinter.printIfAvailable("PotImp", potImp, this.itEnergyFormat, writer);
        Number potDisp = item.getPotDisp();
        AbstractFlussoFDatiPodPrinter.printIfAvailable("PotDisp", potDisp, this.itEnergyFormat, writer);
        this.printNonOrari(item, writer);
        AbstractFlussoFDatiPodPrinter.printIfAvailable("CodiceTariffa", item.getCodiceTariffa(), writer);
        AbstractFlussoFDatiPodPrinter.printIfAvailable("Residenza", item.getResidenza(), writer);
        AbstractFlussoFDatiPodPrinter.printIfAvailable("Disaliment", item.getDisalimentabilita(), writer);
        writer.println("<ServizioTutela>" + item.getServizioTutela() + "</ServizioTutela>");
        writer.println("<ConfMis>" + item.getConfigurazioneMisuratore() + "</ConfMis>");
        writer.println("</DatiPdp>");
    }

    protected void printNonOrari(T item, PrintWriter writer) {
    }

    protected static void printIfAvailable(String name, String value, PrintWriter writer) {
        if (value != null && !value.isEmpty()) {
            writer.println("<" + name + ">" + value + "</" + name + ">");
        }
    }

    protected static void printIfAvailable(String name, Date value, DateFormat format, PrintWriter writer) {
        if (value != null) {
            writer.println("<" + name + ">" + format.format(value) + "</" + name + ">");
        }
    }

    protected static void printIfAvailable(String name, Number value, DecimalFormat format, PrintWriter writer) {
        if (value != null) {
            writer.println("<" + name + ">" + format.format(value) + "</" + name + ">");
        }
    }
}

