/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml;

import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Mno2GE;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.DefaultExportXmlHandler;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.util.Date;
import org.homelinux.elabor.structures.classifier.RecordMap;
import org.homelinux.elabor.structures.listmap.ListMap;

public class RSN2GExportXmlHandler
extends DefaultExportXmlHandler {
    @Override
    public ListMap<Delibera, Mno> getRnos(ServiceStatus status) {
        return status.getRsn2GXml();
    }

    @Override
    public RilGiorno getRilGiorno(Mno item, ServiceStatus status) {
        RilGiorno rilGiorno = null;
        String regime = item.getRegime();
        if (regime.equals("R")) {
            String codicePod = item.getCodicePod();
            Date data = item.getDataMisura();
            String key = Mno2GE.getKey(codicePod, data);
            RecordMap<String, Mno2GE> rsn2gRea = status.getRsn2gRea();
            Mno2GE rsn2geaPod = rsn2gRea.get(key);
            RecordMap<String, Mno2GE> rsn2gRer = status.getRsn2gRer();
            Mno2GE rsn2gerPod = rsn2gRer.get(key);
            RecordMap<String, Mno2GE> rsn2gRerc = status.getRsn2gRerc();
            Mno2GE rsn2gercPod = rsn2gRerc.get(key);
            RecordMap<String, Mno2GE> rsn2gReri = status.getRsn2gReri();
            Mno2GE rsn2geriPod = rsn2gReri.get(key);
            String id = item.getFirstId();
            rilGiorno = ExportXmlHelper.buildRilGiorno(data, "RSN2G", id, rsn2geaPod, rsn2gerPod, rsn2gercPod, rsn2geriPod);
        }
        return rilGiorno;
    }

    @Override
    public String getPotMax(Mno mno) {
        return StrategyHelper.getPotMaxXml(mno, this.itEnergyFormat);
    }

    @Override
    public Date getDataPrest(Mno mno) {
        return mno.getDataPrestazione();
    }

    @Override
    public String getCodPratSii(Mno mno) {
        return mno.getCodPratAtt();
    }
}

