/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Mno2GE;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.Snf;
import biz.elabor.prebilling.model.misure.Sof;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.ManagerXmlSingle;
import biz.elabor.prebilling.services.xml.d479.DatiPodPrinter;
import biz.elabor.prebilling.services.xml.d479.RettificheDatiPodPrinter;
import biz.elabor.prebilling.services.xml.d65.ExtraPrinter;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

class DefaultNonOrariManagerXmlSingle
implements ManagerXmlSingle {
    private static final List<String> FLUSSI = Arrays.asList("RSN2G", "AVR2G", "VPR2G");
    protected DecimalFormat itEnergyFormat;
    protected DateFormat longDataFormat;
    protected DateFormat dataFormat = StrategyHelper.getDataFormat();

    public DefaultNonOrariManagerXmlSingle() {
        this.longDataFormat = StrategyHelper.getFullDateFormat();
        this.itEnergyFormat = StrategyHelper.getItEnergyFormat();
    }

    @Override
    public void printDatiPod(String context, Pdo pdo, PrebillingConfiguration configuration, MisureDao misureDao, Map<String, String> misureType, PrintWriter writer, TalkManager talkManager) {
    }

    @Override
    public void printDatiPod(String context, Mno mno, PrebillingConfiguration configuration, MisureDao misureDao, Map<String, String> misureType, PrintWriter writer) throws DataNotFoundException {
    }

    protected void printDatiPod(String context, Mno mno, ExtraPrinter<Mno> extraPrinter, DatiPodPrinter<Mno> datiPodPrinter, PrebillingConfiguration configuration, PrintWriter writer) {
        if (mno.getDelibera().isDelibera65()) {
            HashSet<String> banned = new HashSet<String>();
            ExportXmlHelper.printDatiPod(context, mno, null, banned, extraPrinter, configuration, writer, this.itEnergyFormat, this.longDataFormat, this.dataFormat);
        } else {
            datiPodPrinter.print(context, mno, writer);
        }
    }

    protected void printDatiPod(Mno mno, RilGiorno rilgiorno, PrebillingConfiguration configuration, Map<String, String> misureType, PrintWriter writer) {
        String className = this.getClass().getSimpleName();
        String potMax = StrategyHelper.getPotMaxXml(mno, this.itEnergyFormat);
        Date dataPrest = mno.getDataPrestazione();
        String codPratSII = mno.getCodPratAtt();
        RettificheDatiPodPrinter datiPodPrinter = new RettificheDatiPodPrinter(potMax, null, dataPrest, codPratSII, rilgiorno, configuration, misureType);
        datiPodPrinter.print(className, mno, writer);
    }

    protected static RilGiorno getRilGiorno(Mno mno, MisureDao misureDao) throws DataNotFoundException {
        String id = mno.getFirstId();
        String regime = mno.getRegime();
        Date data = mno.getDataMisura();
        String codiceFlusso = mno.getCodiceFlusso();
        return DefaultNonOrariManagerXmlSingle.getRilGiorno(id, data, codiceFlusso, regime, misureDao);
    }

    protected static RilGiorno getRilGiorno(String id, Date data, String codiceFlusso, String regime, MisureDao misureDao) throws DataNotFoundException {
        Mno2GE mno2geri;
        Mno2GE mno2gerc;
        Mno2GE mno2ger;
        Mno2GE mno2gea;
        try {
            mno2gea = misureDao.getPno2geaXml(id);
            mno2ger = misureDao.getPno2gerXml(id);
            mno2gerc = misureDao.getPno2gercXml(id);
            mno2geri = misureDao.getPno2geriXml(id);
        }
        catch (DataNotFoundException exc) {
            if ("R".equalsIgnoreCase(regime) && !FLUSSI.contains(codiceFlusso)) {
                throw exc;
            }
            mno2gea = null;
            mno2ger = null;
            mno2gerc = null;
            mno2geri = null;
        }
        return ExportXmlHelper.buildRilGiorno(data, codiceFlusso, id, mno2gea, mno2ger, mno2gerc, mno2geri);
    }

    @Override
    public void printDatiPod(String context, Snf snf, PrebillingConfiguration configuration, MisureDao misureDao, PrintWriter writer) {
    }

    @Override
    public void printDatiPod(String context, Sof sof, PrebillingConfiguration configuration, MisureDao misureDao, PrintWriter writer) {
    }
}

