/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.Mno2GE;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.xml.FlussiGetter;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.d479.FlussiGetter2GE;
import biz.elabor.prebilling.services.xml.periodo.GetPnoXmlGetter;
import biz.elabor.prebilling.services.xml.periodo.TipoRecordExtractor;
import biz.elabor.prebilling.web.xml.Partition;
import biz.elabor.prebilling.web.xml.filtri.FiltriXml;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.homelinux.elabor.structures.listmap.BasicListMap;
import org.homelinux.elabor.structures.listmap.ListMap;

public abstract class AbstractGetXmlStrategy
implements ServiceStrategy {
    private final FiltriXml filtri;
    private final MisureDao misureDao;

    public AbstractGetXmlStrategy(FiltriXml filtri, MisureDao misureDao) {
        this.filtri = filtri;
        this.misureDao = misureDao;
    }

    protected <T> T getFlussi(String azienda, TipoFlusso tipoFlusso, FlussiGetter<T> getter) {
        T items;
        Set<String> flussiFiltro = this.filtri.getFlussi();
        if (flussiFiltro.isEmpty() || flussiFiltro.contains(tipoFlusso.name())) {
            int stato = this.filtri.getStato();
            String statoEsportazione = this.filtri.getStatoEsportazione();
            Date dataInizio = this.filtri.getDataInizio();
            Date dataFine = this.filtri.getDataFine();
            String raccolta = this.filtri.getRaccolta();
            String pod = this.filtri.getPod();
            items = getter.getFlussi(this.misureDao, azienda, tipoFlusso, raccolta, stato, statoEsportazione, dataInizio, dataFine, pod);
        } else {
            items = getter.getEmpty();
        }
        return items;
    }

    protected List<Mno2GE> getFlussi(String azienda, TipoFlusso tipoFlusso, Partition partition, FlussiGetter2GE getter) {
        List<Mno2GE> items;
        Set<String> flussiFiltro = this.filtri.getFlussi();
        if (flussiFiltro.isEmpty() || flussiFiltro.contains(tipoFlusso.name())) {
            int stato = this.filtri.getStato();
            String statoEsportazione = this.filtri.getStatoEsportazione();
            Date dataInizio = this.filtri.getDataInizio();
            Date dataFine = this.filtri.getDataFine();
            String raccolta = this.filtri.getRaccolta();
            String pod = this.filtri.getPod();
            items = getter.getFlussi(this.misureDao, azienda, tipoFlusso, raccolta, stato, statoEsportazione, dataInizio, dataFine, pod, partition);
        } else {
            items = new ArrayList<Mno2GE>();
        }
        return items;
    }

    public <T> List<T> getFlussiRaccolta(String azienda, TipoFlusso tipo, GetPnoXmlGetter<T> getter) {
        String raccolta = this.filtri.getRaccolta();
        String raccoltaGetter = getter.getRaccolta();
        List items = raccolta.isEmpty() || raccolta.equals(raccoltaGetter) ? (List)this.getFlussi(azienda, tipo, getter) : (List)getter.getEmpty();
        return items;
    }

    protected static List<Mno2GE> getMisure(ListMap<String, Mno2GE> misureRMap, String tipoRea) {
        List misure = (List)misureRMap.get(tipoRea);
        return misure == null ? new ArrayList() : misure;
    }

    protected static ListMap<String, Mno2GE> buildMisureMap(List<Mno2GE> pdo2gre) {
        BasicListMap<String, Mno2GE> map = new BasicListMap<String, Mno2GE>();
        TipoRecordExtractor extractor = new TipoRecordExtractor();
        map.addAll(pdo2gre, extractor);
        return map;
    }
}

