/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.Lettura;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.xml.TipoDel65Manager;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;

abstract class AbstractDel65Manager
implements TipoDel65Manager {
    protected final DateFormat giornoFormat = StrategyHelper.getGiornoFormat();
    protected final DecimalFormat meseFormat = StrategyHelper.getMeseNumFormat();
    protected final DecimalFormat itEnergyFormat;
    protected final DateFormat longDataFormat;
    protected final DateFormat dataFormat = StrategyHelper.getDataFormat();

    public AbstractDel65Manager() {
        this.longDataFormat = StrategyHelper.getFullDateFormat();
        this.itEnergyFormat = StrategyHelper.getItEnergyFormat();
    }

    @Override
    public String getRegime(String nomeFile) {
        String[] campi = nomeFile.split("_");
        String last = campi[campi.length - 1];
        String regime = last.toLowerCase().replace(".xml", "");
        regime = regime.equals("r") || regime.equals("nr") ? regime.toUpperCase() : "";
        return regime;
    }

    @Override
    public String getFileRegimeD65Suffix() {
        return "";
    }

    @Override
    public String getFileRegimeD479Suffix() {
        return "R";
    }

    @Override
    public boolean checkRettificaSwitchout(MisuraPod misura, MisureDao misureDao) {
        return false;
    }

    protected static boolean isRettificaSwitchout(MisuraPod misura, MisureDao misureDao) {
        Date dataMisura;
        String codicePod = misura.getCodicePod();
        List<Lettura> letture = misureDao.getLetture(codicePod, dataMisura = misura.getDataMisura());
        return !letture.isEmpty();
    }
}

