/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.volture;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.TipoEstrazione;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.misure.ExtendedLT;
import biz.elabor.prebilling.model.misure.MappaMisureAzienda;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.Misure;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.prebilling.DispatchingFlussi;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.GestFile16Helper;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodCheckException;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.letture.MisuraMno;
import biz.elabor.prebilling.services.letture.MisuraMnoRiall;
import biz.elabor.prebilling.services.letture.MisuraVoltura;
import biz.elabor.prebilling.services.switched.SnmStatoPodHandler;
import biz.elabor.prebilling.services.volture.EnelVnoReferenceHandler;
import biz.elabor.prebilling.services.volture.ExtMno;
import biz.elabor.prebilling.services.volture.MisuraVolturaIV;
import biz.elabor.prebilling.services.volture.model.Voltura;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.safe.SafeMap;

public class SelectVoltureNonOrarieStrategy
implements ServiceStrategy {
    private static final List<String> CHECK_FLUSSI = Arrays.asList("D65");
    private final MisureDao misureDao;
    private final PrebillingConfiguration configuration;
    private final TalkManager talkManager;
    private final SnmStatoPodHandler statoPodHandler;

    public SelectVoltureNonOrarieStrategy(MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager) {
        this.misureDao = misureDao;
        this.configuration = configuration;
        this.talkManager = talkManager;
        this.statoPodHandler = new SnmStatoPodHandler(misureDao, CHECK_FLUSSI, "SE1");
    }

    @Override
    public boolean execute(ServiceStatus status) {
        Misure<Mno> vnosCrm = new Misure<Mno>("vno");
        LinkedHashMap<String, Misure<Voltura>> vnosNoCrm = new LinkedHashMap<String, Misure<Voltura>>();
        Reseller reseller = new Reseller("*", null, null, false, false);
        MappaMisureAzienda pnos = new MappaMisureAzienda(TipoEstrazione.TUTTI, reseller, this.talkManager, this.misureDao);
        Misure<Mno> vno = status.getVno();
        this.execute(vnosCrm, vnosNoCrm, pnos, vno, status);
        Misure<Mno> pdo2grv = status.getPdo2GRV();
        this.execute(vnosCrm, vnosNoCrm, pnos, pdo2grv, status);
        status.setVnosCrm(vnosCrm);
        status.setVnosNoCrm(vnosNoCrm);
        status.setPno(pnos);
        return true;
    }

    private void execute(Misure<Mno> vnosCrm, Map<String, Misure<Voltura>> vnosNoCrm, MappaMisureAzienda pnos, Misure<Mno> mapVnos, ServiceStatus status) {
        for (List list : mapVnos) {
            this.handleVnos(vnosCrm, vnosNoCrm, pnos, list, status);
        }
    }

    private void handleVnos(Misure<Mno> vnosCrm, Map<String, Misure<Voltura>> vnosNoCrm, MappaMisureAzienda pnos, List<Mno> vnos, ServiceStatus status) {
        Date prevDate = null;
        String prevDispatcher = null;
        for (Mno vno : vnos) {
            String dispatcher = vno.getCodContrDisp();
            String codicePod = vno.getCodicePod();
            try {
                MnoResult result;
                String descrizione;
                PodMap podMap = status.getPodMap();
                Pod pod = podMap.get(dispatcher, codicePod);
                String azienda = pod.getAzienda();
                vno.setCdaziend(azienda);
                Date currDate = vno.getDataMisura();
                if (dispatcher.equals(prevDispatcher) && currDate.equals(prevDate) && !this.isEnel(vno)) {
                    Message sentence = new Message("select.volture.strategy", "obsoleto");
                    sentence.addParam(codicePod);
                    sentence.addParam(StrategyHelper.getDataFormat().format(currDate));
                    this.talkManager.addSentence(sentence);
                    descrizione = this.talkManager.getMessage(sentence);
                    result = new MnoResult(vno, ErroriElaborazione.OBSOLETO, descrizione);
                    status.addVnoObsoleto(result);
                } else {
                    try {
                        StatusTransaction transaction = new StatusTransaction(azienda, status, this.configuration);
                        this.handleVno(vnosCrm, vnosNoCrm, pnos, vno, pod, transaction);
                        transaction.commit(codicePod);
                    }
                    catch (RuntimeException exc) {
                        descrizione = StrategyHelper.handleRuntimeException(exc, codicePod, "select.volture.strategy", this.talkManager, status);
                        result = new MnoResult(vno, ErroriElaborazione.EXCLUDING_ERROR, descrizione);
                        status.addVnoSospeso(result);
                    }
                    catch (PraticaAnnullataException | StatoPodCheckException exc) {
                        String message = exc.getMessage();
                        String key = exc.getKey();
                        Message sentence = new Message("select.volture.strategy", message);
                        sentence.addParam(key);
                        String descrizione2 = this.talkManager.getMessage(sentence);
                        ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
                        MnoResult result2 = new MnoResult(vno, errore, descrizione2);
                        status.addVnoObsoleto(result2);
                    }
                }
                prevDate = currDate;
                prevDispatcher = dispatcher;
            }
            catch (DataNotFoundException exc) {
                try {
                    PraticaVolo pratica = StrategyHelper.getPiv(codicePod, null, status);
                    pratica.setHandled(true);
                }
                catch (DataNotFoundException pratica) {
                    // empty catch block
                }
                String message = exc.getMessage();
                String key = exc.getKey();
                Message sentence = new Message("select.volture.strategy", message);
                sentence.setCss("alert-warning");
                sentence.addParam(key);
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                MnoResult result = new MnoResult(vno, ErroriElaborazione.EXCLUDING_ERROR, descrizione);
                status.addVnoSospeso(result);
            }
        }
    }

    private void handleVno(Misure<Mno> vnosCrm, Map<String, Misure<Voltura>> vnosNoCrm, MappaMisureAzienda pnos, Mno vno, Pod pod, StatusTransaction transaction) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException {
        String codicePod = vno.getCodicePod();
        try {
            PraticaVolo pratica = StrategyHelper.getPiv(codicePod, null, transaction);
            pratica.setHandled(true);
            if (this.isEnel(vno)) {
                this.handleVnoEnel(vnosCrm, vnosNoCrm, pnos, vno, pod, transaction, pratica);
            } else {
                this.handleVno(vnosCrm, vnosNoCrm, vno, pod, transaction, pratica);
            }
        }
        catch (DataNotFoundException e2) {
            Date dataMisura = vno.getDataMisura();
            Date dataInizio = pod.getDataInizio(dataMisura);
            Date dataPrestazione = vno.getDataPrestazione();
            String matricola = pod.getMatricolaAttiva();
            if (matricola.startsWith("FITTIZIA") && dataPrestazione.equals(dataInizio)) {
                SelectVoltureNonOrarieStrategy.riconfigurazioneVolturaIV(vno, pod, transaction, this.configuration, this.statoPodHandler);
            }
            Message sentence = new Message("select.volture.strategy", e2.getMessage());
            sentence.addParam(e2.getKey());
            sentence.setCss("alert-danger");
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            MnoResult result = new MnoResult(vno, ErroriElaborazione.PIV_NOTFOUND, descrizione);
            transaction.addVnoSospeso(result);
        }
    }

    public static void riconfigurazioneVolturaIV(Mno vno, Pod pod, StatusTransaction transaction, PrebillingConfiguration configuration, SnmStatoPodHandler statoPodHandler) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException {
        Set<String> tarDisDom = configuration.getTarDisDom();
        Date dataMisura = vno.getDataMisura();
        boolean reattiva = GestFile16Helper.checkReattiva(pod, dataMisura, tarDisDom);
        Date dataInizio = pod.getDataInst(dataMisura);
        MisuraVolturaIV succMno = new MisuraVolturaIV(vno, dataInizio, reattiva);
        MisuraNonoraria prevMno = SelectVoltureNonOrarieStrategy.buildPrevMno(vno, dataMisura);
        ExtendedLT lettura = new ExtendedLT(succMno, prevMno, pod, pod, false, "VT1", "D65", "G");
        transaction.addRiconfigurazioneVolturaIV(lettura);
        MnoResult result = new MnoResult(vno, ErroriElaborazione.OK, "");
        transaction.addVnoElaborato(result);
        transaction.count("prest-D65");
        SafeMap<String, Reseller> resellers = transaction.getResellers();
        String azienda = vno.getCdaziend();
        Reseller reseller = (Reseller)resellers.get(azienda);
        if (reseller.isHandleStato()) {
            MisuraPod misuraPod = SelectVoltureNonOrarieStrategy.buildMisuraPod(vno, pod, configuration);
            String codicePratica = vno.getCodPratAtt();
            Date dataPrestazione = vno.getDataPrestazione();
            Date dataMovimento = CalendarTools.previousDay(dataPrestazione);
            statoPodHandler.handleStato(misuraPod, "VT1", codicePratica, dataMovimento, transaction);
        }
    }

    private static MisuraPod buildMisuraPod(Mno vno, Pod pod, PrebillingConfiguration configuration) {
        Map<String, Map<String, String>> datiPod = vno.getDatiPod();
        Map<String, String> datiPdp = datiPod.get("DatiPdp");
        String matricola = "SNM_" + vno.getFirstId();
        String cifreStd = configuration.getCifreStd();
        if (!SelectVoltureNonOrarieStrategy.isEmpty(vno.getEAF1())) {
            datiPdp.put("MatrAtt", matricola);
            datiPdp.put("CifreAtt", cifreStd);
        }
        if (!SelectVoltureNonOrarieStrategy.isEmpty(vno.getERF1())) {
            datiPdp.put("MatrRea", matricola);
            datiPdp.put("CifreRea", cifreStd);
        }
        if (!SelectVoltureNonOrarieStrategy.isEmpty(vno.getPotF1Orig())) {
            datiPdp.put("MatrPot", matricola);
            datiPdp.put("CifrePot", cifreStd);
        }
        return new MisuraMnoRiall(pod, vno);
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    private static MisuraNonoraria buildPrevMno(Mno vno, Date data) {
        String potf1;
        String erf1;
        String codiceFlusso = vno.getCodiceFlusso();
        Misura misura = new Misura(data, false, 0, codiceFlusso);
        HashMap<String, Map<String, String>> datiPodPrev = new HashMap<String, Map<String, String>>();
        HashMap<String, String> datiPdp = new HashMap<String, String>();
        String eaf1 = vno.getEAF1();
        if (eaf1 != null && !eaf1.isEmpty()) {
            datiPdp.put("MatrAtt", "FITTIZIA");
        }
        if ((erf1 = vno.getERF1()) != null && !erf1.isEmpty()) {
            datiPdp.put("MatrRea", "FITTIZIA");
        }
        if ((potf1 = vno.getPotF1Orig()) != null && !potf1.isEmpty()) {
            datiPdp.put("MatrPot", "FITTIZIA");
        }
        datiPdp.put("Ka", "1");
        datiPdp.put("Kr", "1");
        datiPdp.put("Kp", "1");
        datiPodPrev.put("DatiPdp", datiPdp);
        return new Mno(null, null, null, misura, null, null, null, null, null, data, data, datiPodPrev, null, null, null, null, null, null, null, null, null, null, null, null, null, false, data, false, false, null);
    }

    private boolean isEnel(Mno vno) {
        String pivaDistributoreVoltureSpeciale = this.configuration.getPivaDistributoreVoltureSpeciale();
        String getpIvaDistributore = vno.getPivaDistributore();
        return vno.getCodiceFlusso().equals("VNO") && pivaDistributoreVoltureSpeciale.equals(getpIvaDistributore) && vno.getDelibera().isDelibera65();
    }

    private void handleVnoEnel(Misure<Mno> vnosCrm, Map<String, Misure<Voltura>> vnosNoCrm, MappaMisureAzienda pnos, Mno vno, Pod pod, StatusTransaction transaction, PraticaVolo pratica) {
        String codPratAtt = vno.getCodPratAtt();
        List<Mno> vnos = this.misureDao.getVnos(codPratAtt);
        SelectVoltureNonOrarieStrategy.setAzienda(pod.getAzienda(), vnos);
        StrategyHelper.sortByDate(vnos);
        String idVno = vno.getFirstId();
        Mno firstVno = vnos.get(0);
        String idFirst = firstVno.getFirstId();
        if (idVno.equals(idFirst)) {
            try {
                switch (vnos.size()) {
                    case 1: {
                        this.handleUnaMisuraEnel(vno, pod, pratica, transaction, vnosCrm, vnosNoCrm);
                        break;
                    }
                    case 2: {
                        this.handleDueMisureEnel(vnos, pod, pratica, transaction, vnosCrm, vnosNoCrm, pnos);
                        break;
                    }
                    case 3: {
                        this.handleTreMisureEnel(vnos, pod, pratica, transaction, vnosCrm, vnosNoCrm, pnos);
                        break;
                    }
                    default: {
                        this.addVnoEsclusi(vnos, ErroriElaborazione.TOOMANY_VNO, "toomany.vno", transaction);
                        break;
                    }
                }
            }
            catch (DataNotFoundException exc) {
                ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
                String message = exc.getMessage();
                this.addVnoSospesi(vnos, errore, message, transaction);
            }
        }
    }

    private void handleUnaMisuraEnel(Mno vno, Pod pod, PraticaVolo pratica, StatusTransaction transaction, Misure<Mno> vnosCrm, Map<String, Misure<Voltura>> vnosNoCrm) {
        Date data = vno.getDataVoltura();
        vno.setDataMisura(data);
        this.handleVno(vnosCrm, vnosNoCrm, vno, pod, transaction, pratica);
    }

    private void handleDueMisureEnel(List<Mno> vnos, Pod pod, PraticaVolo pratica, StatusTransaction transaction, Misure<Mno> vnosCrm, Map<String, Misure<Voltura>> vnosNoCrm, MappaMisureAzienda pnos) throws DataNotFoundException {
        if (this.checkPodMultiMisure(vnos, transaction)) {
            if (SelectVoltureNonOrarieStrategy.checkDateContigue(vnos)) {
                if (SelectVoltureNonOrarieStrategy.checkDataInstallazione(vnos)) {
                    Mno first = vnos.get(0);
                    Mno last = vnos.get(1);
                    Date data = first.getDataVoltura();
                    first.setDataMisura(data);
                    this.handleVno(vnosCrm, vnosNoCrm, first, pod, transaction, pratica);
                    String cpGestore = first.getCodPratAtt();
                    String prestazione = pratica.getCodicePrestazione();
                    MisuraMno misuraMno = new MisuraMno(null, first);
                    EnelVnoReferenceHandler handler = new EnelVnoReferenceHandler(2, prestazione, cpGestore, misuraMno);
                    ExtMno firstExt = new ExtMno(first, false, handler);
                    handler = new EnelVnoReferenceHandler(2, prestazione, cpGestore, misuraMno);
                    ExtMno lastExt = new ExtMno(last, true, handler);
                    SelectVoltureNonOrarieStrategy.handleSostituzioneRiprogrammazione(firstExt, lastExt, pnos, transaction);
                } else {
                    this.handleDueMisureEnelDefault(vnos, pod, pratica, transaction, vnosCrm, vnosNoCrm);
                }
            } else if (SelectVoltureNonOrarieStrategy.checkDateVoltureUguali(vnos)) {
                this.addVnoEsclusi(vnos, ErroriElaborazione.DATE_VOLTURA_DIFFERENT, "date.voltura.different", transaction);
            } else {
                this.handleDueMisureEnelDefault(vnos, pod, pratica, transaction, vnosCrm, vnosNoCrm);
            }
        }
    }

    private void handleDueMisureEnelDefault(List<Mno> vnos, Pod pod, PraticaVolo pratica, StatusTransaction transaction, Misure<Mno> vnosCrm, Map<String, Misure<Voltura>> vnosNoCrm) {
        if (SelectVoltureNonOrarieStrategy.stimaUguale(vnos)) {
            this.handleStimaUguale(vnos, pod, transaction, pratica, vnosCrm, vnosNoCrm);
        } else {
            Mno first = vnos.get(0);
            Mno last = vnos.get(1);
            this.handleVnoEnelReale(first, pod, transaction, pratica, vnosCrm, vnosNoCrm);
            this.handleVnoEnelReale(last, pod, transaction, pratica, vnosCrm, vnosNoCrm);
        }
    }

    private void handleStimaUguale(List<Mno> vnos, Pod pod, StatusTransaction transaction, PraticaVolo pratica, Misure<Mno> vnosCrm, Map<String, Misure<Voltura>> vnosNoCrm) {
        Date dataVoltura;
        Mno first = vnos.get(0);
        Mno last = vnos.get(1);
        Date dataMisuraFirst = first.getDataMisura();
        if (dataMisuraFirst.before(dataVoltura = first.getDataVoltura())) {
            this.handleUnaMisuraEnel(last, pod, pratica, transaction, vnosCrm, vnosNoCrm);
            this.addVnoEscluso(first, ErroriElaborazione.BEFORE_DATE_DIFFERENT, "before.date.different", transaction);
        } else {
            this.handleUnaMisuraEnel(first, pod, pratica, transaction, vnosCrm, vnosNoCrm);
            this.addVnoEscluso(last, ErroriElaborazione.AFTER_DATE_DIFFERENT, "after.date.different", transaction);
        }
    }

    private void handleVnoEnelReale(Mno vno, Pod pod, StatusTransaction transaction, PraticaVolo pratica, Misure<Mno> vnosCrm, Map<String, Misure<Voltura>> vnosNoCrm) {
        Misura misura = vno.getMisura();
        if (misura.isStimata()) {
            this.addVnoEscluso(vno, ErroriElaborazione.STIMATA_DATE_DIFFERENT, "stimata.date.different", transaction);
        } else {
            Date data = vno.getDataVoltura();
            vno.setDataMisura(data);
            this.handleUnaMisuraEnel(vno, pod, pratica, transaction, vnosCrm, vnosNoCrm);
        }
    }

    private static boolean stimaUguale(List<Mno> vnos) {
        Mno first = vnos.get(0);
        Mno last = vnos.get(1);
        Misura firstMisura = first.getMisura();
        Misura lastMisura = last.getMisura();
        return firstMisura.isStimata() == lastMisura.isStimata();
    }

    private static void handleSostituzioneRiprogrammazione(ExtMno first, ExtMno last, MappaMisureAzienda pnos, StatusTransaction transaction) throws DataNotFoundException {
        PodMap pods = transaction.getPodMap();
        Mno mno = first.getMno();
        String codicePod = mno.getCodicePod();
        Pod pod = pods.get(codicePod);
        pnos.addSmis(pod, first);
        pnos.addSmis(pod, last);
    }

    private void handleTreMisureEnel(List<Mno> vnos, Pod pod, PraticaVolo pratica, StatusTransaction transaction, Misure<Mno> vnosCrm, Map<String, Misure<Voltura>> vnosNoCrm, MappaMisureAzienda pnos) throws DataNotFoundException {
        if (this.checkPodMultiMisure(vnos, transaction)) {
            StrategyHelper.sortByDate(vnos);
            if (this.checkPodTreMisure(vnos, transaction)) {
                Mno first = vnos.get(0);
                Mno medium = vnos.get(1);
                Mno last = vnos.get(2);
                Date data = first.getDataMisura();
                first.setDataVoltura(data);
                this.handleVno(vnosCrm, vnosNoCrm, first, pod, transaction, pratica);
                String cpGestore = pratica.getCodPratAtt();
                String prestazione = pratica.getCodicePrestazione();
                MisuraMno misuraMno = new MisuraMno(null, medium);
                EnelVnoReferenceHandler handler = new EnelVnoReferenceHandler(2, prestazione, cpGestore, misuraMno);
                ExtMno mediumExt = new ExtMno(medium, true, handler);
                handler = new EnelVnoReferenceHandler(2, prestazione, cpGestore, misuraMno);
                ExtMno lastExt = new ExtMno(last, true, handler);
                SelectVoltureNonOrarieStrategy.handleSostituzioneRiprogrammazione(mediumExt, lastExt, pnos, transaction);
            }
        }
    }

    private boolean checkPodMultiMisure(List<Mno> vnos, StatusTransaction transaction) {
        boolean ok = true;
        Iterator<Mno> iterator = vnos.iterator();
        Mno current = iterator.next();
        String codicePod = current.getCodicePod();
        Date dataVoltura = current.getDataVoltura();
        Date minDataElaborare = CalendarTools.getEndOfTime();
        Date maxDataElaborato = new Date(0L);
        do {
            StatoMisure stato = current.getStato();
            Date dataMisura = current.getDataMisura();
            if (stato.isElaborato()) {
                maxDataElaborato = CalendarTools.max(maxDataElaborato, dataMisura);
            } else {
                minDataElaborare = CalendarTools.min(minDataElaborare, dataMisura);
            }
            if (minDataElaborare.before(maxDataElaborato)) {
                this.addVnoEsclusi(vnos, ErroriElaborazione.DATE_OVERLAPPED, "date.overlapped", transaction);
                ok = false;
            }
            if (!iterator.hasNext()) break;
            current = iterator.next();
            if (!codicePod.equals(current.getCodicePod())) {
                this.addVnoEsclusi(vnos, ErroriElaborazione.POD_DIFFERENT, "pod.different", transaction);
                ok = false;
            }
            if (dataVoltura.equals(current.getDataVoltura())) continue;
            this.addVnoEsclusi(vnos, ErroriElaborazione.DATE_VOLTURA_DIFFERENT, "date.voltura.different", transaction);
            ok = false;
        } while (ok);
        return ok;
    }

    private void addVnoSospesi(List<Mno> vnos, ErroriElaborazione errore, String messaggio, StatusTransaction transaction) {
        for (Mno vno : vnos) {
            StatoMisure stato = vno.getStato();
            if (stato.isElaborato()) continue;
            String descrizione = this.getDescrizione(messaggio, vno);
            MnoResult vnoResult = new MnoResult(vno, errore, descrizione);
            transaction.addVnoSospeso(vnoResult);
        }
    }

    private void addVnoEsclusi(List<Mno> vnos, ErroriElaborazione errore, String messaggio, StatusTransaction transaction) {
        for (Mno vno : vnos) {
            this.addVnoEscluso(vno, errore, messaggio, transaction);
        }
    }

    private void addVnoEscluso(Mno vno, ErroriElaborazione errore, String messaggio, StatusTransaction transaction) {
        StatoMisure stato = vno.getStato();
        if (!stato.isElaborato()) {
            String descrizione = this.getDescrizione(messaggio, vno);
            MnoResult vnoResult = new MnoResult(vno, errore, descrizione);
            transaction.addVnoEscluso(vnoResult);
        }
    }

    private String getDescrizione(String messaggio, Mno vno) {
        Message sentence = new Message("select.volture.strategy", messaggio);
        sentence.setCss("alert-danger");
        sentence.addParam(vno.getCodicePod());
        this.talkManager.addSentence(sentence);
        return this.talkManager.getMessage(sentence);
    }

    private static boolean checkDateContigue(List<Mno> vnos) {
        Mno first = vnos.get(0);
        Mno last = vnos.get(1);
        Date lastDate = last.getDataMisura();
        ElaborCalendar calendar = new ElaborCalendar(lastDate);
        calendar.addGiorni(-1);
        return calendar.getDate().equals(first.getDataMisura());
    }

    private static boolean checkDateVoltureUguali(List<Mno> vnos) {
        Mno first = vnos.get(0);
        Mno last = vnos.get(1);
        return first.getDataMisura().equals(last.getDataMisura());
    }

    private static boolean checkDataInstallazione(List<Mno> vnos) {
        Mno last = vnos.get(1);
        Date lastDate = last.getDataMisura();
        return lastDate.equals(last.getDataInst());
    }

    private boolean checkPodTreMisure(List<Mno> vnos, StatusTransaction transaction) {
        boolean ok = true;
        Mno first = vnos.get(0);
        Mno medium = vnos.get(1);
        Mno last = vnos.get(2);
        if (!first.getDataInst().equals(medium.getDataInst()) || !first.getMatricolaAtt().equals(medium.getMatricolaAtt())) {
            this.addVnoEsclusi(vnos, ErroriElaborazione.DATE_INST_DIFFERENT, "date.inst.different", transaction);
            ok = false;
        } else {
            Date lastDate = last.getDataMisura();
            ElaborCalendar calendar = new ElaborCalendar(lastDate);
            calendar.addGiorni(-1);
            if (!calendar.getDate().equals(medium.getDataMisura()) || !lastDate.equals(last.getDataInst())) {
                this.addVnoEsclusi(vnos, ErroriElaborazione.DATE_INST_DIFFERENT, "date.inst.different", transaction);
                ok = false;
            }
        }
        return ok;
    }

    private void handleVno(Misure<Mno> vnosCrm, Map<String, Misure<Voltura>> vnosNoCrm, Mno vno, Pod pod, StatusTransaction transaction, PraticaVolo pratica) {
        try {
            String destinazione;
            SafeMap<String, Reseller> resellers = transaction.getResellers();
            String azienda = pratica.getCodiceReseller();
            Class<?> strategyClass = this.getClass();
            String className = strategyClass.getSimpleName();
            PrebillingContext.setContext(className, "azienda: " + azienda);
            if (this.configuration.hasCrm()) {
                Reseller reseller = (Reseller)resellers.get(azienda);
                boolean resellerCrm = reseller.isCrm();
                String codicePrestazione = pratica.getCodicePrestazione();
                DispatchingFlussi dispatchingFlussi = transaction.getDispatchingFlussi();
                destinazione = dispatchingFlussi.getDestinazione("E", codicePrestazione, "VNO", azienda, resellerCrm);
            } else {
                destinazione = "";
            }
            if (destinazione == null) {
                vnosCrm.add(vno);
            } else {
                vno.setCdaziend(azienda);
                Misure<Voltura> misure = vnosNoCrm.get(azienda);
                if (misure == null) {
                    misure = new Misure("vno");
                    vnosNoCrm.put(azienda, misure);
                }
                String prestazione = pratica.getCodicePrestazione();
                MisuraMnoRiall misuraMno = new MisuraMnoRiall(pod, vno);
                MisuraVoltura voltura = new MisuraVoltura(prestazione, misuraMno);
                misure.add(voltura);
            }
        }
        catch (DataNotFoundException e2) {
            String message = e2.getMessage();
            String key = e2.getKey();
            Message sentence = new Message("select.volture.strategy", message);
            sentence.addParam(key);
            sentence.setCss("alert-danger");
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            transaction.addVnoSospeso(new MnoResult(vno, ErroriElaborazione.RESELLER_NOT_FOUND, descrizione));
        }
    }

    private static void setAzienda(String azienda, List<Mno> vnos) {
        for (Mno vno : vnos) {
            vno.setCdaziend(azienda);
        }
    }
}

