/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.volture;

import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.services.ServiceStrategy;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;

public class RecordVoltureIVStrategy
implements ServiceStrategy {
    private final MisureDao misureDao;
    private final GiadaDao giadaDao;
    private final String onlyPod;
    private final Date dataFine;

    public RecordVoltureIVStrategy(int anno, Month mese, String onlyPod, MisureDao misureDao, GiadaDao giadaDao) {
        this.onlyPod = onlyPod;
        this.misureDao = misureDao;
        this.giadaDao = giadaDao;
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        calendar.addMesi(1);
        this.dataFine = calendar.getDate();
    }

    @Override
    public boolean execute(ServiceStatus status) {
        List<PraticaVolo> pivVoltureIV = this.giadaDao.getPivVoltureIV(this.onlyPod, this.dataFine);
        this.misureDao.saveVoltureIV(pivVoltureIV);
        return true;
    }
}

