/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.volture;

import biz.elabor.misure.model.WorkingPeriod;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.services.StrategyHelper;
import java.util.Date;
import java.util.Set;

public class MisuraVolturaIV
implements MisuraNonoraria {
    private final Mno mno;
    private final boolean reattiva;
    private final Date dataMisura;

    public MisuraVolturaIV(Mno mno, Date dataMisura, boolean reattiva) {
        if (mno.getKa() == null) {
            mno.setKa("1");
        }
        if (mno.getKr() == null) {
            mno.setKr("1");
        }
        if (mno.getKp() == null) {
            mno.setKp("1");
        }
        this.mno = mno;
        this.dataMisura = dataMisura;
        this.reattiva = reattiva;
    }

    @Override
    public Set<String> getId() {
        return this.mno.getId();
    }

    @Override
    public String getCodiceFlusso() {
        return this.mno.getCodiceFlusso();
    }

    @Override
    public String getPivaDistributore() {
        return this.mno.getPivaDistributore();
    }

    @Override
    public String getPivaUtente() {
        return this.mno.getPivaUtente();
    }

    @Override
    public String getCodContrDisp() {
        return this.mno.getCodContrDisp();
    }

    @Override
    public String getNomeFile() {
        return this.mno.getNomeFile();
    }

    @Override
    public String getCdaziend() {
        return this.mno.getCdaziend();
    }

    @Override
    public void setCdaziend(String cdaziend) {
        this.mno.setCdaziend(cdaziend);
    }

    @Override
    public String getRegime() {
        return this.mno.getRegime();
    }

    @Override
    public String getKey() {
        return this.mno.getKey();
    }

    @Override
    public String getCodicePod() {
        return this.mno.getCodicePod();
    }

    @Override
    public Date getDataMisura() {
        return this.dataMisura;
    }

    @Override
    public Misura getMisura() {
        return this.mno.getMisura();
    }

    @Override
    public String getTipoMisuratore() {
        return this.mno.getTipoMisuratore();
    }

    @Override
    public Number getPotMax() {
        return this.mno.getPotMax();
    }

    @Override
    public boolean hasAttiva() {
        return this.mno.hasAttiva();
    }

    @Override
    public boolean hasReattiva() {
        return this.reattiva;
    }

    @Override
    public boolean hasPotenza() {
        return this.mno.hasPotenza();
    }

    @Override
    public String getMatricolaAtt() {
        return "SNM_" + this.mno.getFirstId();
    }

    @Override
    public String getMatricolaRea() {
        return "SNM_" + this.mno.getFirstId();
    }

    @Override
    public String getMatricolaPot() {
        return "SNM_" + this.mno.getFirstId();
    }

    @Override
    public String getCifreAtt() {
        return this.mno.getCifreAtt();
    }

    @Override
    public String getCifreRea() {
        return this.mno.getCifreRea();
    }

    @Override
    public String getCifrePot() {
        return this.mno.getCifrePot();
    }

    @Override
    public Number getKa() {
        return StrategyHelper.unoifnull(this.mno.getKa());
    }

    @Override
    public Number getKr() {
        return StrategyHelper.unoifnull(this.mno.getKr());
    }

    @Override
    public Number getKp() {
        return StrategyHelper.unoifnull(this.mno.getKp());
    }

    @Override
    public String getTipoDato() {
        return this.mno.getTipoDato();
    }

    @Override
    public String getTensione() {
        return this.mno.getTensione();
    }

    @Override
    public Number getPotContrImp() {
        return this.mno.getPotContrImp();
    }

    @Override
    public Number getPotDisp() {
        return this.mno.getPotDisp();
    }

    @Override
    public Trattamento getTrattamento(Trattamento defaultValue) {
        return this.mno.getTrattamento(defaultValue);
    }

    @Override
    public Trattamento getTrattamento() {
        return this.mno.getTrattamento();
    }

    @Override
    public Date getDataVoltura() {
        return this.mno.getDataVoltura();
    }

    @Override
    public String getEAM() {
        return this.mno.getEAM();
    }

    public String getMotivazioneStima() {
        return this.mno.getMotivazioneStima();
    }

    @Override
    public String getEAF1() {
        return this.mno.getEAF1();
    }

    @Override
    public String getEAF2() {
        return this.mno.getEAF2();
    }

    @Override
    public String getEAF3() {
        return this.mno.getEAF3();
    }

    @Override
    public String getERM() {
        return this.mno.getERM();
    }

    @Override
    public String getERF1() {
        return this.mno.getERF1();
    }

    @Override
    public String getERF2() {
        return this.mno.getERF2();
    }

    @Override
    public String getERF3() {
        return this.mno.getERF3();
    }

    @Override
    public String getPotMOrig() {
        return this.mno.getPotMOrig();
    }

    @Override
    public String getPotF1Orig() {
        return this.mno.getPotF1Orig();
    }

    @Override
    public String getPotF2Orig() {
        return this.mno.getPotF2Orig();
    }

    @Override
    public String getPotF3Orig() {
        return this.mno.getPotF3Orig();
    }

    @Override
    public String getKaSegnale() {
        return this.mno.getKaSegnale();
    }

    @Override
    public String getKrSegnale() {
        return this.mno.getKrSegnale();
    }

    @Override
    public String getKpSegnale() {
        return this.mno.getKpSegnale();
    }

    public boolean equals(Object object) {
        return this.mno.equals(object);
    }

    public int hashCode() {
        return this.mno.hashCode();
    }

    @Override
    public String getCountLabel() {
        return this.mno.getCountLabel();
    }

    @Override
    public String getFlussoFunzionale() {
        return this.mno.getFlussoFunzionale();
    }

    @Override
    public String getKaString() {
        return this.mno.getKaString();
    }

    @Override
    public String getKrString() {
        return this.mno.getKrString();
    }

    @Override
    public String getKpString() {
        return this.mno.getKpString();
    }

    @Override
    public boolean isForfait() {
        return this.mno.isForfait();
    }

    public String toString() {
        return this.mno.toString();
    }

    @Override
    public double getPotMValue() {
        return this.mno.getPotMValue();
    }

    @Override
    public double getPotF1Value() {
        return this.mno.getPotF1Value();
    }

    @Override
    public double getPotF2Value() {
        return this.mno.getPotF2Value();
    }

    @Override
    public double getPotF3Value() {
        return this.mno.getPotF3Value();
    }

    @Override
    public WorkingPeriod getPeriod() {
        return this.mno.getPeriod();
    }

    @Override
    public String getRaccolta() {
        return this.mno.getRaccolta();
    }

    @Override
    public boolean isCalcolata() {
        return false;
    }
}

