/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.volture;

import biz.elabor.prebilling.model.MisuraD65Visitor;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;

class HandleKXVisitor
implements MisuraD65Visitor {
    private final Pod pod;
    private final StatusTransaction transaction;
    private final TalkManager talkManager;
    private boolean ok;

    public HandleKXVisitor(Pod pod, StatusTransaction transaction, TalkManager talkManager) {
        this.pod = pod;
        this.transaction = transaction;
        this.talkManager = talkManager;
        this.ok = true;
    }

    public boolean isOk() {
        return this.ok;
    }

    @Override
    public void visit(Mno mno) {
        try {
            StrategyHelper.handleKX(this.pod, mno);
        }
        catch (DataNotFoundException exc) {
            String message = exc.getMessage();
            String key = exc.getKey();
            Warning sentence = new Warning("export.volture.no.crm", message);
            sentence.setCss("alert-danger");
            sentence.addParam(key);
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
            this.transaction.addVnoSospeso(new MnoResult(mno, errore, descrizione));
            this.ok = false;
        }
    }
}

