/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.volture;

import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.SegnalePrestazione;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.services.common.statopod.ReferenceHandler;
import biz.elabor.prebilling.services.common.statopod.StatoPodHandler;
import biz.elabor.prebilling.services.volture.EnelVnoReferenceStatoPod;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.listmap.SafeListMap;

public class EnelVnoReferenceHandler
implements ReferenceHandler<MisuraPod> {
    private final int offset;
    private final String codPratAtt;
    private final String prestazioneVno;
    private final MisuraPod orig;

    public EnelVnoReferenceHandler(int offset, String prestazioneVno, String codPratAtt, MisuraPod orig) {
        this.offset = offset;
        this.prestazioneVno = prestazioneVno;
        this.codPratAtt = codPratAtt;
        this.orig = orig;
    }

    @Override
    public StatoPod getStatoRiferimento(StatoPodHandler<MisuraPod> statoPodHandler, MisuraPod current, String codicePrestazione, String cpGestore, SegnalePrestazione segnale, SafeListMap<String, Prestazione> prestazioni, String servizio, Date dataMovimento) throws DataNotFoundException {
        String key = Prestazione.getKey(servizio, "VT1", "VNO");
        List prestazioniList = (List)prestazioni.get(key);
        if (prestazioniList.size() < 2) {
            int error = ErroriElaborazione.MOVIMENTORIFERIMENTO_NOTFOUND.ordinal();
            throw new DataNotFoundException("statopod.notfound", key, error);
        }
        SegnalePrestazione segnaleVno = ((Prestazione)prestazioniList.get(1)).getSegnale();
        StatoPod riferimento = statoPodHandler.getStatoRiferimento(this.orig, this.prestazioneVno, this.codPratAtt, segnaleVno, dataMovimento, null);
        return new EnelVnoReferenceStatoPod(riferimento, current);
    }

    @Override
    public int getNuprogre(StatoPodHandler<MisuraPod> statoPodHandler, Date dataMovimento, String codicePod) {
        return statoPodHandler.getNuprogre(dataMovimento, codicePod) + this.offset;
    }

    @Override
    public void setForcedStatoPod(StatoPod statoPod) {
    }
}

