/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.volture;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraD65;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import biz.elabor.prebilling.model.misure.MisuraNonorariaPod;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.Misure;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.DuplicatePivException;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.AbstractExportNoCrmService;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodCheckException;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.volture.HandleKXVisitor;
import biz.elabor.prebilling.services.volture.model.Voltura;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.MultipleRowException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.safe.SafeMap;
import org.homelinux.elabor.tools.StringUtils;

public abstract class AbstractExportVoltureNoCrmStrategy
extends AbstractExportNoCrmService {
    private static final List<String> NO_POTENZA = Arrays.asList("VP", "AV");
    protected final TalkManager talkManager;
    private final Funzionalita funzionalita;

    protected abstract void handleMisura(Voltura var1, boolean var2, StatusTransaction var3) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException, DuplicatePivException;

    public AbstractExportVoltureNoCrmStrategy(Funzionalita funzionalita, PrebillingConfiguration configuration, TalkManager talkManager) {
        super(configuration);
        this.funzionalita = funzionalita;
        this.talkManager = talkManager;
    }

    public Map<String, List<MisuraNonorariaPod>> findToExport(Map<String, ? extends Misure<Voltura>> voltureNOCrm, ServiceStatus status) {
        HashMap<String, List<MisuraNonorariaPod>> misureVoltura = new HashMap<String, List<MisuraNonorariaPod>>();
        for (Map.Entry<String, ? extends Misure<Voltura>> entry : voltureNOCrm.entrySet()) {
            String azienda = entry.getKey();
            PrebillingContext.setContext(this.getClass().getSimpleName(), "select azienda: " + azienda);
            this.addToExport(entry, status, misureVoltura);
        }
        return misureVoltura;
    }

    public boolean exportVnos(Map<String, List<MisuraNonorariaPod>> mapToExport, String partialFileName, String exportMessage, ServiceStatus status) {
        boolean ok = true;
        for (Map.Entry<String, List<MisuraNonorariaPod>> entry : mapToExport.entrySet()) {
            String azienda = entry.getKey();
            PrebillingContext.setContext(this.getClass().getSimpleName(), "export azienda: " + azienda);
            List<MisuraNonorariaPod> misure = entry.getValue();
            ok &= this.exportVnos(partialFileName, exportMessage, azienda, status, misure);
        }
        return ok;
    }

    public boolean exportVnos(String partialFileName, String exportMessage, String azienda, ServiceStatus status, Iterable<MisuraNonorariaPod> misure) {
        String idEsecuzione = status.getIdEsecuzione();
        File folder = ConfigurationHelper.getResellerTmpImportFolder(this.configuration, idEsecuzione, azienda, this.funzionalita);
        String timestamp = this.timestampFormat.format(new Date());
        String fileName = String.valueOf(partialFileName) + azienda + "-" + timestamp + ".csv";
        File file = new File(folder, fileName);
        boolean ok = true;
        try (PrintWriter writer = new PrintWriter(file);){
            writer.println("D65;POD;DATAEVASIO;MATRICOLA1");
            this.print(misure, writer, status);
        }
        catch (FileNotFoundException exc) {
            Warning sentence = new Warning(exportMessage, "file.createFailed");
            sentence.setCss("alert-danger");
            sentence.addParam(file.getAbsolutePath());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    private void addToExport(Map.Entry<String, ? extends Misure<Voltura>> entry, ServiceStatus status, Map<String, List<MisuraNonorariaPod>> misureVoltura) {
        String azienda = entry.getKey();
        SafeMap<String, Reseller> resellers = status.getResellers();
        try {
            Reseller reseller = (Reseller)resellers.get(azienda);
            boolean handleStato = reseller.isHandleStato();
            Misure<Voltura> misure = entry.getValue();
            for (List list : misure) {
                this.addToExport(list, reseller, handleStato, status, misureVoltura);
            }
        }
        catch (DataNotFoundException exc) {
            throw new RuntimeException(exc);
        }
    }

    private void print(Iterable<MisuraNonorariaPod> misure, PrintWriter writer, ServiceStatus status) {
        for (MisuraNonorariaPod vno : misure) {
            Pod pod = vno.getPod();
            String codicePod = pod.getCodice();
            String azienda = pod.getAzienda();
            MisuraNonoraria misura = vno.getMisura();
            try {
                StatusTransaction transaction = new StatusTransaction(azienda, status, this.configuration);
                this.exportVno(writer, vno, transaction);
                status.addLettura(misura);
            }
            catch (RuntimeException exc) {
                String descrizione = StrategyHelper.handleRuntimeException(exc, codicePod, "export.volture.no.crm", this.talkManager, status);
                MnoResult result = new MnoResult(misura, ErroriElaborazione.EXCLUDING_ERROR, descrizione);
                status.addVnoSospeso(result);
            }
        }
    }

    private void addToExport(List<Voltura> volture, Reseller reseller, boolean handleStato, ServiceStatus status, Map<String, List<MisuraNonorariaPod>> misureVoltura) {
        PodMap podMap = status.getPodMap();
        for (Voltura voltura : volture) {
            MisuraPod vno = voltura.getMisuraPod();
            String codicePod = vno.getCodicePod();
            try {
                StatusTransaction transaction = new StatusTransaction(null, status, this.configuration);
                Class<?> thisClass = this.getClass();
                String className = thisClass.getSimpleName();
                PrebillingContext.setContext(className, "pod: " + codicePod);
                Pod pod = podMap.get(codicePod);
                String azienda = pod.getAzienda();
                transaction.setAzienda(azienda);
                this.addMisura(voltura, pod, reseller, handleStato, transaction, misureVoltura);
                transaction.commit(codicePod);
            }
            catch (RuntimeException exc) {
                String descrizione = StrategyHelper.handleRuntimeException(exc, codicePod, "export.volture.no.crm", this.talkManager, status);
                MisuraPod misura = voltura.getMisuraPod();
                MnoResult result = new MnoResult(misura, ErroriElaborazione.EXCLUDING_ERROR, descrizione);
                status.addVnoSospeso(result);
            }
            catch (DataNotFoundException e2) {
                String message = e2.getMessage();
                String key = e2.getKey();
                Warning sentence = new Warning("export.volture.no.crm", message);
                sentence.setCss("alert-danger");
                sentence.addParam(key);
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                status.addVnoSospeso(new MnoResult(vno, ErroriElaborazione.POD_NOTFOUND, descrizione));
            }
        }
    }

    private void addMisura(Voltura voltura, Pod pod, Reseller reseller, boolean handleStato, StatusTransaction transaction, Map<String, List<MisuraNonorariaPod>> misureVoltura) {
        MisuraPod vno = voltura.getMisuraPod();
        String codicePod = vno.getCodicePod();
        try {
            if (this.handleKX(pod, vno, transaction)) {
                if (pod.isAttesaSnm()) {
                    Warning sentence = new Warning("export.volture.no.crm", "attesa.snm");
                    sentence.addParam(codicePod);
                    sentence.setCss("alert-warning");
                    this.talkManager.addSentence(sentence);
                    String descrizione = this.talkManager.getMessage(sentence);
                    transaction.addVnoSospeso(new MnoResult(vno, ErroriElaborazione.INATTESA_SNM, descrizione));
                } else {
                    String azienda = reseller.getCodice();
                    List<MisuraNonorariaPod> misureAzienda = misureVoltura.get(azienda);
                    if (misureAzienda == null) {
                        misureAzienda = new ArrayList<MisuraNonorariaPod>();
                        misureVoltura.put(azienda, misureAzienda);
                    }
                    this.handleMisura(voltura, handleStato, transaction);
                    String prestazione = voltura.getPrestazione();
                    MisuraNonorariaPod misuraNonorariaPod = new MisuraNonorariaPod(prestazione, pod, vno);
                    misureAzienda.add(misuraNonorariaPod);
                    MnoResult result = new MnoResult(vno, ErroriElaborazione.OK, "");
                    transaction.addVnoElaborato(result);
                    String label = vno.getCountLabel();
                    transaction.count(label);
                }
            }
        }
        catch (MultipleRowException e2) {
            Warning sentence = new Warning("export.volture.no.crm", "giada.error.multiplerow");
            sentence.addParam(codicePod);
            sentence.setCss("alert-danger");
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            MnoResult result = new MnoResult(vno, ErroriElaborazione.SQL_ERROR, descrizione);
            transaction.addVnoSospeso(result);
        }
        catch (DuplicatePivException | DataNotFoundException exc) {
            String message = exc.getMessage();
            Message sentence = new Message("export.volture.no.crm", message);
            String key = exc.getKey();
            sentence.addParam(String.valueOf(codicePod) + " - " + key);
            sentence.setCss("alert-danger");
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            MnoResult result = new MnoResult(vno, ErroriElaborazione.SQL_ERROR, descrizione);
            transaction.addVnoSospeso(result);
        }
        catch (StatoPodCheckException exc) {
            String message = exc.getMessage();
            Message sentence = new Message("export.volture.no.crm", message);
            sentence.addParam(codicePod);
            sentence.setCss("alert-danger");
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            MnoResult result = new MnoResult(vno, ErroriElaborazione.SQL_ERROR, descrizione);
            transaction.addVnoSospeso(result);
        }
        catch (PraticaAnnullataException exc) {
            String message = exc.getMessage();
            String prestazione = exc.getSpecification();
            Message sentence = new Message("export.volture.no.crm", message);
            sentence.addParam(codicePod);
            sentence.addParam(prestazione);
            ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            MnoResult result = new MnoResult(vno, errore, descrizione);
            transaction.addVnoObsoleto(result);
        }
    }

    private boolean handleKX(Pod pod, MisuraD65 misura, StatusTransaction transaction) {
        HandleKXVisitor visitor = new HandleKXVisitor(pod, transaction, this.talkManager);
        misura.accept(visitor);
        return visitor.isOk();
    }

    private void exportVno(PrintWriter writer, MisuraNonorariaPod misuraPod, StatusTransaction transaction) {
        boolean potenza;
        boolean reattiva;
        boolean attiva;
        MisuraNonoraria misura;
        Pod pod = misuraPod.getPod();
        MisuraNonoraria vno = misura = misuraPod.getMisura();
        transaction.addVnoElaborato(new MnoResult(vno, ErroriElaborazione.OK, ""));
        String label = vno.getCountLabel();
        transaction.count(label);
        if (pod.isAllineato()) {
            attiva = vno.hasAttiva();
            reattiva = vno.hasReattiva();
            potenza = vno.hasPotenza();
        } else {
            Date date = misura.getDataMisura();
            attiva = pod.isMisuraAttiva(date);
            reattiva = pod.isMisuraReattiva(date);
            potenza = pod.isMisuraPotenza(date);
        }
        String prestazione = misuraPod.getPrestazione();
        if (prestazione.contains("_")) {
            prestazione = prestazione.substring(0, prestazione.indexOf("_"));
        }
        double[] lastAttiva = pod.getLastAttiva();
        double[] lastReattiva = pod.getLastReattiva();
        double potContrattuale = pod.getPotImp();
        double potDisponibile = pod.getPotDisponibile();
        this.printMno(writer, prestazione, vno, "", "", attiva, reattiva, potenza, lastAttiva, lastReattiva, potContrattuale, potDisponibile);
    }

    private void printMno(PrintWriter writer, String prestazione, MisuraNonoraria mno, String codiceTariffa, String servizioTutela, boolean attiva, boolean reattiva, boolean potenza, double[] lastAttiva, double[] lastReattiva, double potContrattuale, double potDisponibile) {
        double ka = StrategyHelper.getK(mno.getKa());
        double kr = StrategyHelper.getK(mno.getKr());
        double kp = StrategyHelper.getK(mno.getKp());
        int nCifreAttiva = this.configuration.getNCifreAttiva(ka);
        int nCifreReattiva = this.configuration.getNCifreReattiva(kr);
        int nCifrePotenza = this.configuration.getNCifrePotenza(kp);
        writer.print(";");
        String codicePod = mno.getCodicePod();
        writer.print(codicePod.trim());
        writer.print(";");
        Date dataVoltura = mno.getDataVoltura();
        if (dataVoltura == null) {
            dataVoltura = mno.getDataMisura();
        }
        writer.print(this.dataFormat.format(dataVoltura));
        writer.print(";");
        writer.print(";");
        if (attiva) {
            writer.print(";");
            writer.print(";");
            writer.print(";");
            double lastAttivaF1 = lastAttiva[FasciaOraria.F1.ordinal()];
            if (mno.getTrattamento().isMono()) {
                String eam = mno.getEAM();
                String eAM = this.getDato(eam, DECIMAL_FORMAT_MISURE, lastAttivaF1, nCifreAttiva);
                writer.print(eAM);
                writer.print(";");
                writer.print(";");
                writer.print(";");
            } else {
                String eaf1 = mno.getEAF1();
                String eaF1 = this.getDato(eaf1, DECIMAL_FORMAT_MISURE, lastAttivaF1, nCifreAttiva);
                writer.print(eaF1);
                writer.print(";");
                String eaf2 = mno.getEAF2();
                double lastAttivaF2 = lastAttiva[FasciaOraria.F2.ordinal()];
                String eaF2 = this.getDato(eaf2, DECIMAL_FORMAT_MISURE, lastAttivaF2, nCifreAttiva);
                writer.print(eaF2);
                writer.print(";");
                String eaf3 = mno.getEAF3();
                double lastAttivaF3 = lastAttiva[FasciaOraria.F3.ordinal()];
                String eaF3 = this.getDato(eaf3, DECIMAL_FORMAT_MISURE, lastAttivaF3, nCifreAttiva);
                writer.print(eaF3);
                writer.print(";");
            }
        } else {
            writer.print(";;;;;;");
        }
        writer.print(";");
        if (reattiva) {
            writer.print(";");
            writer.print(";");
            writer.print(";");
            double lastReativaF1 = lastReattiva[FasciaOraria.F1.ordinal()];
            if (mno.getTrattamento().isMono()) {
                String erm = mno.getERM();
                String erM = this.getDato(erm, DECIMAL_FORMAT_MISURE, lastReativaF1, nCifreReattiva);
                writer.print(erM);
                writer.print(";");
                writer.print(";");
                writer.print(";");
            } else {
                String erF1 = this.getDato(mno.getERF1(), DECIMAL_FORMAT_MISURE, lastReativaF1, nCifreReattiva);
                writer.print(erF1);
                writer.print(";");
                double lastReattivaF2 = lastReattiva[FasciaOraria.F2.ordinal()];
                String erF2 = this.getDato(mno.getERF2(), DECIMAL_FORMAT_MISURE, lastReattivaF2, nCifreReattiva);
                writer.print(erF2);
                writer.print(";");
                double lastReattivaF3 = lastReattiva[FasciaOraria.F3.ordinal()];
                String erF3 = this.getDato(mno.getERF3(), DECIMAL_FORMAT_MISURE, lastReattivaF3, nCifreReattiva);
                writer.print(erF3);
                writer.print(";");
            }
        } else {
            writer.print(";;;;;;");
        }
        writer.print(";");
        if (potenza) {
            writer.print(";");
            writer.print(";");
            writer.print(";");
            if (mno.getTrattamento().isMono()) {
                String potMOrig = mno.getPotMOrig();
                double potMValue = mno.getPotMValue();
                String potM = this.getDato(potMOrig, potMValue, DECIMAL_FORMAT_MISURE, 0.0, nCifrePotenza);
                writer.print(potM);
                writer.print(";");
                writer.print(";");
                writer.print(";");
            } else {
                String potF1Orig = mno.getPotF1Orig();
                double potF1Value = mno.getPotF1Value();
                String potF1 = this.getDato(potF1Orig, potF1Value, DECIMAL_FORMAT_MISURE, 0.0, nCifrePotenza);
                writer.print(potF1);
                writer.print(";");
                String potF2Orig = mno.getPotF2Orig();
                double potF2Value = mno.getPotF2Value();
                String potF2 = this.getDato(potF2Orig, potF2Value, DECIMAL_FORMAT_MISURE, 0.0, nCifrePotenza);
                writer.print(potF2);
                writer.print(";");
                String potF3String = mno.getPotF3Orig();
                double potF3Value = mno.getPotF3Value();
                String potF3 = this.getDato(potF3String, potF3Value, DECIMAL_FORMAT_MISURE, 0.0, nCifrePotenza);
                writer.print(potF3);
                writer.print(";");
            }
        } else {
            writer.print(";;;;;;");
        }
        writer.print(";");
        Misura misura = mno.getMisura();
        if (misura.hasCommerciale()) {
            writer.print(";");
            writer.print(";");
            writer.print(";");
            String EaF1 = AbstractExportVoltureNoCrmStrategy.getDato(misura.getCommerciale(FasciaOraria.F1).getNetto(), DECIMAL_FORMAT_MISURE, 0.0);
            writer.print(EaF1);
            writer.print(";");
            String EaF2 = AbstractExportVoltureNoCrmStrategy.getDato(misura.getCommerciale(FasciaOraria.F2).getNetto(), DECIMAL_FORMAT_MISURE, 0.0);
            writer.print(EaF2);
            writer.print(";");
            String EaF3 = AbstractExportVoltureNoCrmStrategy.getDato(misura.getCommerciale(FasciaOraria.F3).getNetto(), DECIMAL_FORMAT_MISURE, 0.0);
            writer.print(EaF3);
            writer.print(";");
        } else {
            writer.print(";;;;;;");
        }
        writer.print(mno.getTrattamento().getFasce());
        writer.print(";");
        writer.print(";");
        writer.print(";");
        if (attiva) {
            String kaSegnale = mno.getKaSegnale();
            writer.print(this.getDato(kaSegnale, DECIMAL_FORMAT_K_OUT, 0.0, 0));
        }
        writer.print(";");
        writer.print(";");
        writer.print(prestazione);
        writer.print(";");
        if (reattiva) {
            String krSegnale = mno.getKrSegnale();
            writer.print(this.getDato(krSegnale, DECIMAL_FORMAT_K_OUT, 0.0, 0));
        }
        writer.print(";");
        if (potenza) {
            String kpSegnale = mno.getKpSegnale();
            writer.print(this.getDato(kpSegnale, DECIMAL_FORMAT_K_OUT, 0.0, 0));
        }
        writer.print(";");
        String tipoDato = mno.getTipoDato();
        writer.print(StringUtils.isEmpty(tipoDato) ? "E" : tipoDato);
        writer.print(";");
        writer.print(codiceTariffa.trim());
        writer.print(";");
        writer.print(servizioTutela.trim());
        writer.print(";");
        writer.print((Object)mno.getTrattamento());
        writer.print(";");
        writer.print(mno.getTensione().trim());
        writer.print(";");
        AbstractExportVoltureNoCrmStrategy.printPotenza(writer, prestazione, potContrattuale);
        writer.print(";");
        AbstractExportVoltureNoCrmStrategy.printPotenza(writer, prestazione, potDisponibile);
        writer.print(";");
        writer.println("*");
    }

    private static void printPotenza(PrintWriter writer, String prestazione, double potenza) {
        if (!NO_POTENZA.contains(prestazione.toUpperCase().substring(0, 2))) {
            writer.print(DECIMAL_FORMAT_OUT.format(potenza));
        }
    }
}

