/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.variazionipotenza;

import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.TipoEstrazione;
import biz.elabor.prebilling.services.StrategiesManager;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.CheckStatusStrategy;
import biz.elabor.prebilling.services.common.FileCopyStrategy;
import biz.elabor.prebilling.services.common.GetPivStrategy;
import biz.elabor.prebilling.services.common.GetPrestazioniStrategy;
import biz.elabor.prebilling.services.common.GetResellersStrategy;
import biz.elabor.prebilling.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.services.letture.GetDispatchingFlussiStrategy;
import biz.elabor.prebilling.services.letture.GetSmisStrategy;
import biz.elabor.prebilling.services.letture.RecordLettureStrategy;
import biz.elabor.prebilling.services.letture.RecordStatoLettureStrategy;
import biz.elabor.prebilling.services.rettifiche.InitialiseLetturePeriodoStrategy;
import biz.elabor.prebilling.services.variazionipotenza.ExportVariazioniPotenzaStrategy;
import biz.elabor.prebilling.services.variazionipotenza.VariazioniPotenzaOrfaneStrategy;
import biz.elabor.prebilling.web.common.AbstractStrategiesHandler;
import java.util.Date;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class VariazioniPotenzaStrategiesHandler
extends AbstractStrategiesHandler {
    public VariazioniPotenzaStrategiesHandler(ConfigurationInstance instance, TalkManager talkManager) {
        super(instance, talkManager);
    }

    @Override
    public StrategiesManager buildStrategiesManager() {
        StrategiesManager manager = new StrategiesManager(this.configuration);
        Date toDay = this.configuration.getToDay();
        ElaborCalendar calendar = new ElaborCalendar(toDay);
        calendar.addMesi(1);
        int anno = calendar.getAnno();
        Month mese = calendar.getMese();
        manager.addStrategy(new CheckStatusStrategy(Funzionalita.VARIAZIONI_POTENZA, "*", "letture.check", this.configuration, this.prebillingDao, this.talkManager));
        manager.addStrategy(new GetPrestazioniStrategy(this.misureDao));
        manager.addStrategy(new GetResellersStrategy(this.prebillingDao));
        manager.addStrategy(new GetDispatchingFlussiStrategy(this.prebillingDao));
        manager.addStrategy(new GetPivStrategy(anno, mese, "", "", this.giadaDao, StrategyHelper.VARIAZIONI_POTENZA_CDUNIPRE_LIST));
        manager.addStrategy(new InitialiseLetturePeriodoStrategy());
        manager.addStrategy(new GetSmisStrategy(anno, mese, "", TipoEstrazione.TUTTI, null, this.misureDao, this.talkManager));
        manager.addStrategy(new ExportVariazioniPotenzaStrategy(this.configuration, this.misureDao, this.talkManager));
        manager.addStrategy(new VariazioniPotenzaOrfaneStrategy(anno, mese, this.misureDao, this.talkManager));
        manager.addStrategy(new RecordLettureStrategy(this.misureDao, this.talkManager));
        manager.addStrategy(new RecordStatoLettureStrategy(this.misureDao, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.VARIAZIONI_POTENZA, "*", TipoStato.COPIA_FILE, this.configuration, this.prebillingDao));
        manager.addStrategy(new FileCopyStrategy(Funzionalita.VARIAZIONI_POTENZA, this.configuration, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.VARIAZIONI_POTENZA, "*", TipoStato.NO_ESECUZIONE, this.configuration, this.prebillingDao));
        return manager;
    }
}

