/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.variazionipotenza;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statopod.AbstractBasicStatoPod;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.services.AbstractMnoStatoPodHandler;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.attivazioni.PrestazioneStatoPod;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodChecker;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.variazionipotenza.VP3ReferenceHandler;
import java.util.Date;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.db.DataNotFoundException;

public class VariazionePotenzaStatoPodHandler
extends AbstractMnoStatoPodHandler {
    private final int defaultNCifre;

    public VariazionePotenzaStatoPodHandler(MisureDao misureDao, PrebillingConfiguration configuration) {
        super("E", misureDao);
        this.defaultNCifre = configuration.getDefaultCifreContatore();
    }

    @Override
    public AbstractBasicStatoPod buildStatoPod(Prestazione prestazione, String flusso, String cpGestore, String cpUtente, Mno current, StatoPod riferimento, Date dataMovimento, String idMovimento, int nuprogre) {
        double[] lastAttiva = new double[]{0.0, 0.0, 0.0};
        double[] lastReattiva = new double[]{0.0, 0.0, 0.0};
        return new PrestazioneStatoPod(prestazione, current, dataMovimento, riferimento, lastAttiva, lastReattiva, nuprogre, this.defaultNCifre);
    }

    @Override
    public void handleStato(Mno current, String codicePrestazione, String codicePratica, StatusTransaction transaction, StatoPodChecker<Mno> checker) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException {
        String flusso = this.getCodiceFlusso(current);
        Date dataMovimento = current.getDataPrestazione();
        Date dataMisura = CalendarTools.previousDay(dataMovimento);
        VP3ReferenceHandler referenceHandler = new VP3ReferenceHandler();
        this.handleStato(current, codicePrestazione, flusso, codicePratica, dataMovimento, dataMisura, null, transaction, checker, referenceHandler);
    }
}

