/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe.model;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisureHelper;
import biz.elabor.prebilling.services.tariffe.LetturaSegnanti;
import biz.elabor.prebilling.services.tariffe.RilevazioneTariffa;
import java.util.Date;

public class BasicRilevazioneTariffa
implements RilevazioneTariffa,
LetturaSegnanti {
    private final Misura misura;
    private final String matricola;
    private final String cifreAtt;
    private final Number ka;
    private final String pivaDistributore;

    public BasicRilevazioneTariffa(double[] segnante, Date dataRilevazione, String matricola, int cifreAtt, Number ka, String pivaDistributore) {
        this.matricola = matricola;
        this.pivaDistributore = pivaDistributore;
        this.misura = new Misura(dataRilevazione, false, 3, null);
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            int ordinal = fascia.ordinal();
            this.misura.setAttiva(fascia, segnante[ordinal], 0.0);
            ++n3;
        }
        this.cifreAtt = String.valueOf(cifreAtt);
        this.ka = ka;
    }

    @Override
    public Misura getMisura() {
        return this.misura;
    }

    @Override
    public Date getDataMisura() {
        return this.misura.getDate();
    }

    @Override
    public String getMatricolaAtt() {
        return this.matricola;
    }

    @Override
    public String getCifreAtt() {
        return this.cifreAtt;
    }

    @Override
    public boolean isSmisMontaggio() {
        return false;
    }

    @Override
    public String getPivaDistributore() {
        return this.pivaDistributore;
    }

    @Override
    public double getAttiva(FasciaOraria fascia) {
        return this.misura.getAttiva(fascia).getNetto();
    }

    @Override
    public double[] getAttiva() {
        return MisureHelper.getNetti(this.misura.getAttiva());
    }

    @Override
    public Number getKa() {
        return this.ka;
    }

    @Override
    public String getCodiceFlusso() {
        return this.misura.getCodiceFlusso();
    }

    @Override
    public boolean isStimata() {
        return false;
    }
}

