/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.misure.model.fasce.CalendarioFasceGiornaliero;
import biz.elabor.misure.model.fasce.CalendarioFasceMensile;
import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.InconsistentOptionException;
import biz.elabor.prebilling.common.MisuraException;
import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.PrebillingError;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.TariffeCommonHelper;
import biz.elabor.prebilling.common.dao.MultipuntoEntry;
import biz.elabor.prebilling.common.dao.MultipuntoOption;
import biz.elabor.prebilling.common.model.Applicazione;
import biz.elabor.prebilling.common.model.ContrattiHelper;
import biz.elabor.prebilling.common.model.Contratto;
import biz.elabor.prebilling.common.model.PrezziMedi;
import biz.elabor.prebilling.common.model.TipoFlat;
import biz.elabor.prebilling.common.model.TipoProfilo;
import biz.elabor.prebilling.common.model.TipoTrattamento;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.ContrattoEle;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.dao.Multipunto;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.InvalidCurvaRilevazioniException;
import biz.elabor.prebilling.model.MissingCoeffPerditeException;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.StatoCalcoloHandler;
import biz.elabor.prebilling.model.calendar.CalendarMap;
import biz.elabor.prebilling.model.calendar.CalendarioCommercialeHelper;
import biz.elabor.prebilling.model.giada.ContrattiPodList;
import biz.elabor.prebilling.model.giada.MappaContratti;
import biz.elabor.prebilling.model.indici.CurvaIndiciGiornaliera;
import biz.elabor.prebilling.model.indici.CurvaIndiciMensile;
import biz.elabor.prebilling.model.indici.IndiceOrario;
import biz.elabor.prebilling.model.indici.InvalidCurvaIndiciException;
import biz.elabor.prebilling.model.indici.MappaIndici;
import biz.elabor.prebilling.model.misure.Lettura;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.model.misure.RilQuartoType;
import biz.elabor.prebilling.model.prebilling.Offerta;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.tariffe.DettaglioTariffa;
import biz.elabor.prebilling.model.tariffe.MisuraFasceQuantita;
import biz.elabor.prebilling.model.tariffe.TariffaApplicazione;
import biz.elabor.prebilling.model.tariffe.TariffaMonoraria;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.FileCopyStrategy;
import biz.elabor.prebilling.services.common.IncoherentKException;
import biz.elabor.prebilling.services.common.TariffeAccumulator;
import biz.elabor.prebilling.services.letture.ConsumiHelper;
import biz.elabor.prebilling.services.tariffe.CalendarException;
import biz.elabor.prebilling.services.tariffe.CodicePodExtractor;
import biz.elabor.prebilling.services.tariffe.ConsumiException;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.InvalidSegnantiException;
import biz.elabor.prebilling.services.tariffe.InvalidValidityException;
import biz.elabor.prebilling.services.tariffe.MisureHandler;
import biz.elabor.prebilling.services.tariffe.MnoElaboratiHandler;
import biz.elabor.prebilling.services.tariffe.MnoSospesiHandler;
import biz.elabor.prebilling.services.tariffe.NullPrezzoExtractor;
import biz.elabor.prebilling.services.tariffe.PdoRfoElaboratiHandler;
import biz.elabor.prebilling.services.tariffe.PdoRfoSospesiHandler;
import biz.elabor.prebilling.services.tariffe.PenaleExtractor;
import biz.elabor.prebilling.services.tariffe.RecordStatoTariffeStrategy;
import biz.elabor.prebilling.services.tariffe.RilMeseTot;
import biz.elabor.prebilling.services.tariffe.SmisException;
import biz.elabor.prebilling.services.tariffe.StatoCalcoloPod;
import biz.elabor.prebilling.services.tariffe.TariffaMultiApplicazione;
import biz.elabor.prebilling.services.tariffe.TariffaPenale;
import biz.elabor.prebilling.services.tariffe.TariffeHelper;
import biz.elabor.prebilling.services.tariffe.TipoCalcolo;
import biz.elabor.prebilling.services.tariffe.TipoFlatPrezzoExtractor;
import biz.elabor.prebilling.services.tariffe.ValorePicco;
import biz.elabor.prebilling.util.EleProfiler;
import biz.elabor.prebilling.util.EleTipoProfiloVisitor;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.homelinux.elabor.arrays.Condition;
import org.homelinux.elabor.arrays.Filter;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.DaysOfMonthIterable;
import org.homelinux.elabor.calendar.DaysOfMonthIterator;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.StructuresHelper;
import org.homelinux.elabor.structures.TappoIterator;
import org.homelinux.elabor.structures.listmap.BasicListMap;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.safe.SafeMap;
import org.homelinux.elabor.tools.MathUtils;
import org.homelinux.elabor.tools.MemoryTools;
import org.homelinux.elabor.tools.StringUtils;

public class TariffeBuilder {
    private static final Double ZERO = 0.0;
    private static final ValorePicco TAPPO = new ValorePicco(CalendarTools.getEndOfTime(), 0.0, 0.0);
    private final int anno;
    private final Month mese;
    private final TipoCalcolo tipo;
    private final Destinatari destinatari;
    private final Set<String> podSet;
    private final MappaContratti contratti;
    private final MisureDao misureDao;
    private final PrebillingConfiguration configuration;
    private final TalkManager talkManager;
    private final ServiceStatus status;
    private final Month meseStart;
    private final int annoStart;
    private final Month meseRif;
    private final int annoRif;
    private final boolean scivoloEnabled;
    private final boolean scivoloForced;
    private final String onlyPod;
    private final TipoTrattamento onlyTipoTrattamento;
    private final int maxBatches;
    private final boolean ricalcolo;
    private final boolean batchCommit;
    private final int batchAggregate;
    private final boolean bloccoIndice;
    private int batchCount;
    private ListMap<String, TariffaMultiApplicazione> tariffe;
    private Map<String, RilMeseTot> mappaMultiConsumi;
    private Map<String, Multipunto> multiPodMap;
    private Set<Date> orePicco;
    private List<ValorePicco> valoriPicco;
    private PrezziMedi prezziMedi;

    public TariffeBuilder(int anno, Month mese, TipoCalcolo tipo, Destinatari destinatari, Set<String> podSet, MappaContratti contratti, Map<String, Multipunto> multiPodMap, MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager, ServiceStatus status, int annoStart, Month meseStart, int annoRif, Month meseRif, boolean scivoloEnabled, boolean scivoloForced, String onlyPod, TipoTrattamento onlyTipoTrattamento, boolean ricalcolo, boolean bloccoIndice) throws CalendarNotFoundException {
        this.anno = anno;
        this.mese = mese;
        this.tipo = tipo;
        this.destinatari = destinatari;
        this.podSet = podSet;
        this.contratti = contratti;
        this.misureDao = misureDao;
        this.configuration = configuration;
        this.talkManager = talkManager;
        this.status = status;
        this.tariffe = new BasicListMap<String, TariffaMultiApplicazione>();
        this.meseStart = meseStart;
        this.annoStart = annoStart;
        this.annoRif = annoRif;
        this.meseRif = meseRif;
        this.scivoloEnabled = scivoloEnabled;
        this.scivoloForced = scivoloForced;
        this.onlyPod = onlyPod;
        this.onlyTipoTrattamento = onlyTipoTrattamento;
        this.maxBatches = configuration.getMaxBatches();
        this.ricalcolo = ricalcolo;
        this.batchCommit = this.configuration.isBatchCommit();
        this.batchAggregate = this.configuration.getBatchAggregation();
        this.multiPodMap = multiPodMap;
        this.bloccoIndice = bloccoIndice;
        this.fillConsumiCumulativi();
        this.prezziMedi = new PrezziMedi("E", anno, mese, misureDao);
    }

    public ListMap<String, TariffaMultiApplicazione> buildTariffe() throws CalendarNotFoundException, InconsistentOptionException {
        boolean requestedMonth = this.annoRif == this.anno && this.meseRif == this.mese;
        this.batchCount = 0;
        for (Map.Entry<String, ContrattiPodList> entry : this.contratti.entrySet()) {
            this.elaboraContrattiAzienda(entry);
            if (this.batchCount > this.maxBatches && requestedMonth) break;
        }
        if (this.batchCommit && this.batchCount % this.batchAggregate != 0) {
            this.commitTariffeBatch(this.batchCount / this.batchAggregate);
        }
        return this.tariffe;
    }

    private void elaboraContrattiAzienda(Map.Entry<String, ContrattiPodList> entry) throws CalendarNotFoundException, InconsistentOptionException {
        String reseller = entry.getKey();
        ContrattiPodList contrattiAzienda = entry.getValue();
        String className = this.getClass().getSimpleName();
        PrebillingContext.setContext(className, "azienda: " + reseller);
        Logger logger = this.status.getLogger();
        String message = "azienda " + reseller + " - " + contrattiAzienda.size() + " contratti";
        if (this.configuration.isLogMemory()) {
            MemoryTools.logMemory(logger, message);
        } else {
            logger.info(message);
        }
        Set<String> erroriTariffe = this.status.getErroriTariffe();
        this.elaboraContrattiAzienda(reseller, contrattiAzienda, erroriTariffe);
    }

    private void elaboraContrattiAzienda(String reseller, ContrattiPodList contrattiReseller, Set<String> errori) throws CalendarNotFoundException, InconsistentOptionException {
        ArrayList<ContrattoEle> contrattiBatch = new ArrayList<ContrattoEle>();
        ArrayList<ContrattoEle> candidatiScivoloBatch = new ArrayList<ContrattoEle>();
        for (List contrattiPod : contrattiReseller) {
            this.add(contrattiBatch, candidatiScivoloBatch, contrattiPod);
            if (contrattiBatch.size() + candidatiScivoloBatch.size() <= this.configuration.getContrattiBatchSize()) continue;
            this.elaboraContrattiPod(reseller, contrattiBatch, candidatiScivoloBatch, errori);
        }
        if (!contrattiBatch.isEmpty() || !candidatiScivoloBatch.isEmpty()) {
            this.elaboraContrattiPod(reseller, contrattiBatch, candidatiScivoloBatch, errori);
        }
    }

    private void add(List<ContrattoEle> contrattiBatch, List<ContrattoEle> candidatiScivoloBatch, List<ContrattoEle> contrattiPod) {
        for (ContrattoEle contratto : contrattiPod) {
            String codicePod = contratto.getCodice();
            if (contratto.getTipoApplicazione() == 0) {
                Message sentence = new Message("compute.tariffe", "cctarif.zero");
                sentence.addParam(codicePod);
                sentence.addParam(String.valueOf(this.anno) + "/" + this.mese.name());
                this.talkManager.addSentence(sentence);
                continue;
            }
            if (this.podSet.isEmpty() || this.podSet.contains(codicePod) || this.onlyPod.equals(codicePod)) {
                contrattiBatch.add(contratto);
                continue;
            }
            if (!this.scivoloEnabled) continue;
            candidatiScivoloBatch.add(contratto);
        }
    }

    private static Set<String> buildPodBatch(List<ContrattoEle> contrattiPod) {
        CodicePodExtractor extractor = new CodicePodExtractor();
        HashSet<String> podBatch = new HashSet<String>();
        StructuresHelper.buildCollection(podBatch, contrattiPod, extractor);
        return podBatch;
    }

    private void elaboraContrattiPod(String reseller, List<ContrattoEle> contrattiBatch, List<ContrattoEle> candidatiScivoloBatch, Set<String> errori) throws CalendarNotFoundException, InconsistentOptionException {
        DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
        ++this.batchCount;
        Logger logger = this.status.getLogger();
        if (!candidatiScivoloBatch.isEmpty()) {
            Set<String> podCandidatiScivoloBatch = TariffeBuilder.buildPodBatch(candidatiScivoloBatch);
            Set<String> podTariffeCalcolate = this.misureDao.getPodTariffeElaborate(podCandidatiScivoloBatch, this.anno, this.mese, this.destinatari);
            TariffeBuilder.completeBatch(contrattiBatch, candidatiScivoloBatch, podTariffeCalcolate);
        }
        if (!contrattiBatch.isEmpty()) {
            Set<String> podBatch = TariffeBuilder.buildPodBatch(contrattiBatch);
            ListMap<String, Pdo> pdoMap = this.misureDao.getPdoTariffe(this.destinatari, podBatch, this.anno, this.mese);
            ListMap<String, Mno> pnoMap = this.misureDao.getPnoTariffe(this.destinatari, podBatch, this.annoStart, this.meseStart, this.annoRif, this.meseRif);
            String message = "azienda " + reseller + " anno " + this.anno + " mese " + this.mese.getIndex() + " batch " + contrattiBatch.size() + " scivolo " + candidatiScivoloBatch.size() + " count " + this.batchCount + " pno " + pnoMap.size() + " pdo " + pdoMap.size();
            if (this.configuration.isLogMemory()) {
                MemoryTools.logMemory(logger, message);
            } else {
                logger.info(message);
            }
            ElaborCalendar calendar = new ElaborCalendar(this.anno, this.mese);
            Date inizioMese = calendar.getDate();
            calendar.addMesi(1);
            Date inizioMeseSucc = calendar.getDate();
            Set<String> podDaElaborare = TariffeBuilder.buildPodBatch(contrattiBatch);
            Set<String> podTariffeCalcolate = this.misureDao.getPodTariffeElaborate(podDaElaborare, this.anno, this.mese, this.destinatari);
            StatoCalcoloPod statoCalcolo = null;
            String prevCodicePod = null;
            for (ContrattoEle contratto : contrattiBatch) {
                String codicePod = contratto.getCodice();
                if (!codicePod.equals(prevCodicePod)) {
                    prevCodicePod = codicePod;
                    statoCalcolo = StatoCalcoloPod.OK;
                }
                String className = this.getClass().getSimpleName();
                String context = String.valueOf(codicePod) + " - " + dateFormat.format(inizioMese);
                PrebillingContext.setContext(className, context);
                statoCalcolo = this.elaboraContratto(inizioMese, inizioMeseSucc, pdoMap, pnoMap, reseller, contratto, podTariffeCalcolate, errori, contrattiBatch, statoCalcolo);
            }
        }
        String message = String.valueOf(contrattiBatch.size()) + " contratti elaborati per azienda " + reseller;
        if (this.configuration.isLogMemory()) {
            MemoryTools.logMemory(logger, message);
        } else {
            logger.info(message);
        }
        contrattiBatch.clear();
        candidatiScivoloBatch.clear();
        if (this.batchCommit && this.batchCount % this.batchAggregate == 0) {
            this.commitTariffeBatch(this.batchCount / this.batchAggregate);
        }
    }

    private void commitTariffeBatch(int commitCount) {
        this.status.setCommitCount(commitCount);
        this.destinatari.setTariffe(this.status, this.tariffe);
        boolean requestedMonth = this.annoRif == this.anno && this.meseRif == this.mese;
        Date dataMax = requestedMonth ? null : CalendarTools.getEndDate(this.anno, this.mese);
        ServiceStrategy exportTariffeStrategy = this.destinatari.getExportTariffeStrategy(this.anno, this.mese, dataMax, this.tipo, this.configuration, this.talkManager);
        exportTariffeStrategy.execute(this.status);
        RecordStatoTariffeStrategy recordStatoTariffeStrategy = new RecordStatoTariffeStrategy(this.misureDao, this.talkManager);
        recordStatoTariffeStrategy.execute(this.status);
        this.status.resetTariffeBatch();
        this.tariffe = new BasicListMap<String, TariffaMultiApplicazione>();
        this.destinatari.setTariffe(this.status, this.tariffe);
        FileCopyStrategy fileCopyStrategy = new FileCopyStrategy(Funzionalita.TARIFFE, this.configuration, this.talkManager);
        fileCopyStrategy.execute(this.status);
        this.status.setCommitCount(commitCount + 1);
    }

    private static void completeBatch(List<ContrattoEle> contrattiBatch, List<ContrattoEle> candidatiScivoloBatch, Set<String> podTariffeCalcolate) {
        for (ContrattoEle contratto : candidatiScivoloBatch) {
            String codicePod = contratto.getCodice();
            if (podTariffeCalcolate.contains(codicePod)) continue;
            contrattiBatch.add(contratto);
        }
    }

    private StatoCalcoloPod elaboraContratto(Date inizioMese, Date inizioMeseSucc, ListMap<String, Pdo> pdoMap, ListMap<String, Mno> pnoMap, String azienda, ContrattoEle contratto, Set<String> podTariffeCalcolate, Set<String> errori, List<ContrattoEle> contrattiBatch, StatoCalcoloPod statoCalcolo) throws CalendarNotFoundException, InconsistentOptionException {
        String codicePod = contratto.getCodice();
        Applicazione applicazione = this.status.getApplicazione(contratto);
        TipoFlat tipoFlat = applicazione.getTipoFlat();
        StatoCalcoloPod newStatoCalcolo = statoCalcolo;
        if (tipoFlat.isSpread()) {
            Pdo pdo = TariffeBuilder.getMisura(codicePod, pdoMap);
            PdoRfoElaboratiHandler handler = new PdoRfoElaboratiHandler(this.status, this.destinatari, "");
            TariffeBuilder.handlePdoRfo(handler, pdo, azienda);
        } else {
            SafeMap<String, Offerta> offerte = this.status.getOfferte();
            MappaIndici mappaIndici = this.status.getMappaIndici();
            if (TariffeCommonHelper.checkTrattamento(contratto, this.anno, this.mese, applicazione, this.onlyTipoTrattamento)) {
                TipoProfilo tipoProfilo = applicazione.getTipoProfilo();
                newStatoCalcolo = this.addTariffe(inizioMese, inizioMeseSucc, offerte, mappaIndici, contratto, tipoFlat, tipoProfilo, pdoMap, pnoMap, podTariffeCalcolate, errori, contrattiBatch, statoCalcolo);
            }
        }
        return newStatoCalcolo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StatoCalcoloPod addTariffe(Date inizioMese, Date inizioMeseSucc, SafeMap<String, Offerta> offerte, MappaIndici mappaIndici, ContrattoEle contratto, TipoFlat tipoFlat, TipoProfilo tipoProfilo, ListMap<String, Pdo> pdoMap, ListMap<String, Mno> pnoMap, Set<String> podTariffeCalcolate, Set<String> errori, List<ContrattoEle> contrattiBatch, StatoCalcoloPod statoCalcolo) throws CalendarNotFoundException, InconsistentOptionException {
        String codIndiceEnergetico = contratto.getCodIndiceEnergetico();
        String codicePod = contratto.getCodice();
        String codiceOfferta = contratto.getCodiceOfferta();
        String azienda = contratto.getReseller();
        String rowEnd = String.valueOf(azienda) + ";" + this.anno + ";" + this.mese.getIndex() + ";";
        Pdo pdo = TariffeBuilder.getMisura(codicePod, pdoMap);
        StatoCalcoloPod newStatoCalcolo = statoCalcolo;
        ArrayList<Mno> mnoList = (ArrayList<Mno>)pnoMap.get(codicePod);
        if (!(!StringUtils.isEmpty(this.onlyPod) || this.ricalcolo || pdo == null && mnoList == null || pdo != null && !this.destinatari.isElaborato(pdo))) {
            if (mnoList == null) return newStatoCalcolo;
            if (this.destinatari.isElaborati((List<Mno>)mnoList)) return newStatoCalcolo;
        }
        EleTipoProfiloVisitor tipoProfiloVisitor = new EleTipoProfiloVisitor(this.anno);
        tipoProfilo.accept(tipoProfiloVisitor);
        EleProfiler profiler = tipoProfiloVisitor.getProfiler();
        try {
            double coeffPerdite = this.getCoeffPerdite(contratto, inizioMese);
            try {
                String userMessage;
                TariffaMultiApplicazione tariffaMulti;
                block52: {
                    TariffeBuilder.checkValidity(contratto);
                    double coeffUM = this.configuration.getCoeffUMPrezzi();
                    double[] prezziDefault = contratto.getPrezziDefault();
                    double qtConFla = contratto.getQtConFla();
                    double consumoFlatOra = profiler.getConsumoFlatOra(qtConFla);
                    boolean rettifica = podTariffeCalcolate.contains(codicePod);
                    Offerta offerta = (Offerta)offerte.get(codIndiceEnergetico);
                    boolean perdite = offerta.isCalcoloPerdite();
                    tariffaMulti = null;
                    userMessage = "";
                    if (statoCalcolo.isForced()) {
                        tariffaMulti = this.eseguiScivolo(contratto, inizioMese, inizioMeseSucc, tipoFlat, coeffPerdite, coeffUM, consumoFlatOra, rettifica, perdite, offerte);
                    } else if (statoCalcolo.isOk()) {
                        try {
                            TariffaApplicazione penale;
                            List<Object> opzioniFixingSwap;
                            double consumoTotaleFixingSwap;
                            ArrayList<Mno> mnoTarList;
                            double kAttiva;
                            RilMese rilMese;
                            RilMeseTot rilMeseMulti;
                            double kAttivaPod;
                            RilMese rilMesePod;
                            CurvaIndiciMensile curvaIndici;
                            block51: {
                                curvaIndici = mappaIndici.get(offerta, this.talkManager);
                                userMessage = this.checkIndice(contratto, offerta, tipoFlat, curvaIndici, offerte, errori, rowEnd);
                                if (pdo == null) {
                                    if (contratto.isRegime(inizioMese)) {
                                        if (tipoFlat.isFixingSwap() && this.scivoloEnabled) {
                                            rilMesePod = null;
                                            kAttivaPod = 0.0;
                                            break block51;
                                        } else {
                                            mnoList = null;
                                            throw new InvalidCurvaRilevazioniException(inizioMese, true);
                                        }
                                    }
                                    Date inizioConsumi = ContrattiHelper.getInizioTariffa(contratto, this.anno, this.mese);
                                    Date fineConsumi = ContrattiHelper.getFineTariffa(this.anno, this.mese, contratto);
                                    boolean forfait = TariffeBuilder.isForfait((List<Mno>)mnoList);
                                    boolean complessivo = this.configuration.isConsumoComplessivo();
                                    if (this.configuration.isConsumoComplessivo()) {
                                        List<Lettura> letture = this.misureDao.getLetture(codicePod, inizioConsumi);
                                        List<Lettura> letturaDataSingola = TariffeHelper.getRilevazioniDataSingola(letture);
                                        rilMesePod = TariffeHelper.buildRilmeseFromLetture(contratto, forfait, inizioConsumi, fineConsumi, letturaDataSingola, contrattiBatch, complessivo, this.status);
                                        kAttivaPod = TariffeHelper.getKa(letturaDataSingola).doubleValue();
                                    } else {
                                        List<Mno> mnoListNoVno = TariffeBuilder.getMnoListNoMno((List<Mno>)mnoList);
                                        rilMesePod = TariffeHelper.buildRilmeseFromLetture(contratto, forfait, inizioConsumi, fineConsumi, mnoListNoVno, contrattiBatch, complessivo, this.status);
                                        kAttivaPod = TariffeHelper.getKa(mnoList).doubleValue();
                                    }
                                } else {
                                    rilMesePod = pdo.getRilMese();
                                    String pivaDistr = pdo.getPivaDistributore();
                                    Date dataLetPre = contratto.getDataUltimaLettura();
                                    this.fixMissingDays(rilMesePod, contratto, pivaDistr, (List<Mno>)mnoList, dataLetPre);
                                    kAttivaPod = pdo.getKa();
                                }
                            }
                            RilMeseTot rilMeseTot = rilMeseMulti = contratto.isFixing() || tipoFlat.isFixing() || tipoFlat.isFixingSwap() ? this.mappaMultiConsumi.get(codicePod) : null;
                            if ((rilMeseMulti == null || !this.scivoloEnabled) && (rilMesePod == null || !this.scivoloEnabled && rilMeseMulti != null && rilMeseMulti.isScivolo())) break block52;
                            if (rilMeseMulti == null) {
                                rilMese = rilMesePod;
                                kAttiva = kAttivaPod;
                                mnoTarList = mnoList;
                                consumoTotaleFixingSwap = 0.0;
                                opzioniFixingSwap = new ArrayList();
                            } else {
                                rilMese = rilMeseMulti;
                                kAttiva = 1.0;
                                mnoTarList = new ArrayList<Mno>();
                                consumoTotaleFixingSwap = rilMeseMulti.getConsumoTotaleFixingSwap();
                                opzioniFixingSwap = rilMeseMulti.getOpzioniFixingSwap();
                            }
                            if (tipoFlat.isFixingSwap()) {
                                this.checkQtindene(contratto, errori, rowEnd);
                            }
                            if (tipoFlat.isFixingSwap() && opzioniFixingSwap.isEmpty()) {
                                ErroriElaborazione error = ErroriElaborazione.MISSING_OPTIONS;
                                String message = error.getMessage();
                                int ordinal = error.ordinal();
                                DecimalFormat meseNumFormat = StrategyHelper.getMeseNumFormat();
                                String meseNum = meseNumFormat.format(this.mese.getIndex());
                                String key = String.valueOf(codicePod) + " " + this.anno + "/" + meseNum;
                                throw new DataNotFoundException(message, key, ordinal);
                            }
                            CalendarioFasceMensile calendarioFasce = this.getCalendarioFasce(contratto);
                            Date inizioContratto = ContrattiHelper.getInizioTariffa(contratto, this.anno, this.mese);
                            double emspread = tipoFlat.getEmspread(contratto, consumoTotaleFixingSwap, opzioniFixingSwap);
                            double emspreneg = contratto.getEmspreneg();
                            double emtaruni = contratto.getEmtaruni();
                            TariffeAccumulator accumulator = this.tipo.getAccumulator(rilMese, calendarioFasce, coeffUM, inizioContratto, consumoFlatOra, kAttiva, prezziDefault, perdite, coeffPerdite, emtaruni, emspread, emspreneg, mnoTarList);
                            accumulator.init(curvaIndici);
                            Date tariffaStartDate = TariffeBuilder.handleStartDate(inizioMese, inizioContratto, accumulator);
                            Date endDate = TariffeBuilder.getEndDate(inizioMeseSucc, contratto);
                            ArrayList<TariffaApplicazione> subTariffe = new ArrayList<TariffaApplicazione>();
                            boolean scivolo = this.buildSubTariffe(mappaIndici, inizioMese, endDate, contratto, offerte, accumulator, subTariffe);
                            tariffaMulti = new TariffaMultiApplicazione((Contratto)contratto, tariffaStartDate, perdite, coeffPerdite, scivolo, rettifica, subTariffe);
                            if (tariffaMulti.getQtMisura() == 0.0 && (penale = this.calcolaPenale(contratto, mappaIndici, offerte, coeffUM)) != null) {
                                TariffaPenale tariffaPenale = new TariffaPenale((Contratto)contratto, tariffaStartDate, perdite, coeffPerdite, false, rettifica, penale);
                                tariffaMulti.setPenale(tariffaPenale);
                            }
                            if (rilMeseMulti != null) {
                                double qtMisura = tipoFlat.isFixingSwap() ? TariffeBuilder.getQtMisuraFixingSwap(contratto, consumoTotaleFixingSwap, opzioniFixingSwap) : this.getQtMisura(rilMesePod, contratto);
                                tariffaMulti.setQtMisura(qtMisura);
                            }
                        }
                        catch (InvalidCurvaRilevazioniException | ConsumiException exc) {
                            boolean forced = false;
                            if (!this.scivoloEnabled) {
                                if (!this.scivoloForced) {
                                    newStatoCalcolo = ((StatoCalcoloHandler)((Object)exc)).getStatoCalcolo();
                                    throw exc;
                                }
                                forced = true;
                                newStatoCalcolo = StatoCalcoloPod.FORCED;
                            }
                            tariffaMulti = this.eseguiScivolo(contratto, inizioMese, inizioMeseSucc, tipoFlat, coeffPerdite, coeffUM, consumoFlatOra, rettifica, perdite, offerte);
                            if (forced) {
                                this.tariffe.add(azienda, tariffaMulti);
                                throw exc;
                            }
                        }
                        catch (InconsistentOptionException | MisuraException | InvalidCurvaIndiciException | IncoherentKException | InvalidSegnantiException | SmisException | DataNotFoundException exc) {
                            if (this.scivoloForced && !this.bloccoIndice) {
                                newStatoCalcolo = StatoCalcoloPod.FORCED;
                                tariffaMulti = this.eseguiScivolo(contratto, inizioMese, inizioMeseSucc, tipoFlat, coeffPerdite, coeffUM, consumoFlatOra, rettifica, perdite, offerte);
                                this.tariffe.add(azienda, tariffaMulti);
                                throw exc;
                            }
                            newStatoCalcolo = StatoCalcoloPod.BLOCKED;
                            throw exc;
                        }
                    }
                }
                if (tariffaMulti == null) return newStatoCalcolo;
                this.tariffe.add(azienda, tariffaMulti);
                if (statoCalcolo.isForced()) return newStatoCalcolo;
                PdoRfoElaboratiHandler pdoRfoHandler = new PdoRfoElaboratiHandler(this.status, this.destinatari, userMessage);
                TariffeBuilder.handlePdoRfo(pdoRfoHandler, pdo, azienda);
                MnoElaboratiHandler mnoHandler = new MnoElaboratiHandler(this.status, this.destinatari, this.anno, this.mese, userMessage);
                TariffeBuilder.handleMno((List<Mno>)mnoList, mnoHandler);
                return newStatoCalcolo;
            }
            catch (InvalidValidityException exc) {
                String message = exc.getMessage();
                Message sentence = new Message("compute.tariffe", message);
                sentence.addParam(exc.getKey());
                DateFormat dataFormat = StrategyHelper.getDataFormat();
                sentence.addParam(dataFormat.format(exc.getValidityDate()));
                sentence.addParam(dataFormat.format(exc.getBeginDate()));
                String userMessage = this.talkManager.getMessage(sentence);
                if (errori.add(String.valueOf(codicePod) + ";" + userMessage + ";" + rowEnd)) {
                    this.talkManager.addSentence(sentence);
                }
                ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
                PdoRfoSospesiHandler handler = new PdoRfoSospesiHandler(this.status, this.destinatari, errore, userMessage);
                TariffeBuilder.handlePdoRfo(handler, pdo, azienda);
                MnoSospesiHandler mnoHandler = new MnoSospesiHandler(this.status, this.destinatari, errore, userMessage, this.anno, this.mese);
                TariffeBuilder.handleMno((List<Mno>)mnoList, mnoHandler);
                return newStatoCalcolo;
            }
            catch (InvalidCurvaIndiciException exc) {
                String message = exc.getMessage();
                Message sentence = new Message("compute.tariffe", message);
                sentence.addParam(codicePod);
                String userMessage = this.talkManager.getMessage(sentence);
                if (errori.add(String.valueOf(codicePod) + ";" + userMessage + ";" + rowEnd)) {
                    this.talkManager.addSentence(sentence);
                }
                ErroriElaborazione errore = ErroriElaborazione.CURVAINDICI_NOTVALID;
                PdoRfoSospesiHandler handler = new PdoRfoSospesiHandler(this.status, this.destinatari, errore, userMessage);
                TariffeBuilder.handlePdoRfo(handler, pdo, azienda);
                MnoSospesiHandler mnoHandler = new MnoSospesiHandler(this.status, this.destinatari, errore, userMessage, this.anno, this.mese);
                TariffeBuilder.handleMno((List<Mno>)mnoList, mnoHandler);
                return newStatoCalcolo;
            }
            catch (InvalidCurvaRilevazioniException exc) {
                String formattedDate;
                String message = exc.getMessage();
                Date date = exc.getDate();
                Message sentence = new Message("compute.tariffe", message);
                sentence.addParam(codicePod);
                String string = formattedDate = date == null ? "sconosciuta" : StrategyHelper.getDataFormat().format(date);
                if (exc.isRegime()) {
                    formattedDate = String.valueOf(formattedDate) + " (a regime)";
                }
                sentence.addParam(formattedDate);
                sentence.setCss("alert-danger");
                String userMessage = this.talkManager.getMessage(sentence);
                if (errori.add(String.valueOf(codicePod) + ";" + userMessage + ";" + rowEnd)) {
                    this.talkManager.addSentence(sentence);
                }
                ErroriElaborazione errore = ErroriElaborazione.CURVA_NOTVALID;
                PdoRfoSospesiHandler handler = new PdoRfoSospesiHandler(this.status, this.destinatari, errore, userMessage);
                TariffeBuilder.handlePdoRfo(handler, pdo, azienda);
                MnoSospesiHandler mnoHandler = new MnoSospesiHandler(this.status, this.destinatari, errore, userMessage, this.anno, this.mese);
                TariffeBuilder.handleMno((List<Mno>)mnoList, mnoHandler);
                return newStatoCalcolo;
            }
            catch (MisuraException exc) {
                String message = exc.getMessage();
                Message sentence = new Message("compute.tariffe", message);
                sentence.addParam(exc.getKey());
                DateFormat dataFormat = StrategyHelper.getDataFormat();
                sentence.addParam(dataFormat.format(exc.getData()));
                sentence.addParam(exc.getFlusso());
                this.talkManager.addSentence(sentence);
                PrebillingError errore = exc.getErrore();
                String userMessage = this.talkManager.getMessage(sentence);
                PdoRfoSospesiHandler handler = new PdoRfoSospesiHandler(this.status, this.destinatari, errore, userMessage);
                TariffeBuilder.handlePdoRfo(handler, pdo, azienda);
                MnoSospesiHandler mnoHandler = new MnoSospesiHandler(this.status, this.destinatari, errore, userMessage, this.anno, this.mese);
                TariffeBuilder.handleMno((List<Mno>)mnoList, mnoHandler);
                return newStatoCalcolo;
            }
            catch (DataNotFoundException exc) {
                String message = exc.getMessage();
                Message sentence = new Message("compute.tariffe", message);
                String key = exc.getKey();
                sentence.addParam(key);
                sentence.addParam(codicePod);
                String userMessage = this.talkManager.getMessage(sentence);
                if (errori.add(String.valueOf(codicePod) + ";" + userMessage + ";" + rowEnd)) {
                    this.talkManager.addSentence(sentence);
                }
                ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
                PdoRfoSospesiHandler handler = new PdoRfoSospesiHandler(this.status, this.destinatari, errore, userMessage);
                TariffeBuilder.handlePdoRfo(handler, pdo, azienda);
                MnoSospesiHandler mnoHandler = new MnoSospesiHandler(this.status, this.destinatari, errore, userMessage, this.anno, this.mese);
                TariffeBuilder.handleMno((List<Mno>)mnoList, mnoHandler);
                this.remove(azienda, codicePod);
                return newStatoCalcolo;
            }
            catch (ConsumiException exc) {
                String message = exc.getMessage();
                Message sentence = new Message("compute.tariffe", message);
                sentence.setParams(exc.getParams());
                String userMessage = this.talkManager.getMessage(sentence);
                if (errori.add(String.valueOf(codicePod) + ";" + userMessage + ";" + rowEnd)) {
                    this.talkManager.addSentence(sentence);
                }
                ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
                PdoRfoSospesiHandler handler = new PdoRfoSospesiHandler(this.status, this.destinatari, errore, userMessage);
                TariffeBuilder.handlePdoRfo(handler, pdo, azienda);
                MnoSospesiHandler mnoHandler = new MnoSospesiHandler(this.status, this.destinatari, errore, userMessage, this.anno, this.mese);
                TariffeBuilder.handleMno((List<Mno>)mnoList, mnoHandler);
                return newStatoCalcolo;
            }
            catch (SmisException exc) {
                String message = exc.getMessage();
                Message sentence = new Message("compute.tariffe", message);
                sentence.addParam(codicePod);
                DateFormat dataFormat = StrategyHelper.getDataFormat();
                Date dataRilevazione = exc.getDataRilevazione();
                sentence.addParam(dataFormat.format(dataRilevazione));
                String userMessage = this.talkManager.getMessage(sentence);
                if (errori.add(String.valueOf(codicePod) + ";" + userMessage + ";" + rowEnd)) {
                    this.talkManager.addSentence(sentence);
                }
                ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
                PdoRfoSospesiHandler handler = new PdoRfoSospesiHandler(this.status, this.destinatari, errore, userMessage);
                TariffeBuilder.handlePdoRfo(handler, pdo, azienda);
                MnoSospesiHandler mnoHandler = new MnoSospesiHandler(this.status, this.destinatari, errore, userMessage, this.anno, this.mese);
                TariffeBuilder.handleMno((List<Mno>)mnoList, mnoHandler);
                return newStatoCalcolo;
            }
            catch (CalendarException exc) {
                String calendarId = TariffeHelper.getCalendarId(codiceOfferta, this.status);
                ErroriElaborazione errore = ErroriElaborazione.INCOMPATIBLE_CALENDAR;
                String message = errore.getMessage();
                Message sentence = new Message("compute.tariffe", message);
                DateFormat dataFormat = StrategyHelper.getDataFormat();
                sentence.addParam(dataFormat.format(exc.getStart()));
                sentence.addParam(dataFormat.format(exc.getEnd()));
                sentence.addParam(codicePod);
                sentence.addParam(calendarId);
                String userMessage = this.talkManager.getMessage(sentence);
                if (errori.add(String.valueOf(codicePod) + ";" + userMessage + ";" + rowEnd)) {
                    this.talkManager.addSentence(sentence);
                }
                PdoRfoSospesiHandler handler = new PdoRfoSospesiHandler(this.status, this.destinatari, errore, userMessage);
                TariffeBuilder.handlePdoRfo(handler, pdo, azienda);
                MnoSospesiHandler mnoHandler = new MnoSospesiHandler(this.status, this.destinatari, errore, userMessage, this.anno, this.mese);
                TariffeBuilder.handleMno((List<Mno>)mnoList, mnoHandler);
                return newStatoCalcolo;
            }
        }
        catch (DataNotFoundException exc) {
            String message = exc.getMessage();
            Message sentence = new Message("compute.tariffe", message);
            String key = exc.getKey();
            sentence.addParam(key);
            sentence.addParam(codicePod);
            String userMessage = this.talkManager.getMessage(sentence);
            if (errori.add(String.valueOf(codicePod) + ";" + userMessage + ";" + rowEnd)) {
                this.talkManager.addSentence(sentence);
            }
            ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
            PdoRfoSospesiHandler handler = new PdoRfoSospesiHandler(this.status, this.destinatari, errore, userMessage);
            TariffeBuilder.handlePdoRfo(handler, pdo, azienda);
            MnoSospesiHandler mnoHandler = new MnoSospesiHandler(this.status, this.destinatari, errore, userMessage, this.anno, this.mese);
            TariffeBuilder.handleMno((List<Mno>)mnoList, mnoHandler);
            return newStatoCalcolo;
        }
        catch (MissingCoeffPerditeException exc) {
            String message = exc.getMessage();
            Date date = exc.getData();
            int livello = exc.getLivello();
            Message sentence = new Message("compute.tariffe", message);
            sentence.addParam(codicePod);
            DateFormat dataFormat = StrategyHelper.getDataFormat();
            sentence.addParam(dataFormat.format(date));
            sentence.addParam(String.valueOf(livello));
            String userMessage = this.talkManager.getMessage(sentence);
            if (errori.add(String.valueOf(codicePod) + ";" + userMessage + ";" + rowEnd)) {
                this.talkManager.addSentence(sentence);
            }
            ErroriElaborazione errore = ErroriElaborazione.MISSING_ALIQUOTA;
            PdoRfoSospesiHandler handler = new PdoRfoSospesiHandler(this.status, this.destinatari, errore, userMessage);
            TariffeBuilder.handlePdoRfo(handler, pdo, azienda);
            MnoSospesiHandler mnoHandler = new MnoSospesiHandler(this.status, this.destinatari, errore, userMessage, this.anno, this.mese);
            TariffeBuilder.handleMno((List<Mno>)mnoList, mnoHandler);
            return newStatoCalcolo;
        }
        catch (IncoherentKException exc) {
            Message sentence = new Message("compute.tariffe", "incoherent.k");
            sentence.addParam(codicePod);
            Date data = exc.getData();
            DateFormat dataFormat = StrategyHelper.getDataFormat();
            sentence.addParam(dataFormat.format(data));
            String userMessage = this.talkManager.getMessage(sentence);
            if (errori.add(String.valueOf(codicePod) + ";" + userMessage + ";" + rowEnd)) {
                this.talkManager.addSentence(sentence);
            }
            ErroriElaborazione errore = ErroriElaborazione.INCOHERENT_K;
            PdoRfoSospesiHandler handler = new PdoRfoSospesiHandler(this.status, this.destinatari, errore, userMessage);
            TariffeBuilder.handlePdoRfo(handler, pdo, azienda);
            MnoSospesiHandler mnoHandler = new MnoSospesiHandler(this.status, this.destinatari, errore, userMessage, this.anno, this.mese);
            TariffeBuilder.handleMno((List<Mno>)mnoList, mnoHandler);
            return newStatoCalcolo;
        }
        catch (InvalidSegnantiException exc) {
            String message = exc.getMessage();
            Message sentence = new Message("compute.tariffe", message);
            sentence.addParam(codicePod);
            DateFormat dataFormat = StrategyHelper.getDataFormat();
            Date dataIniziale = exc.getDataIniziale();
            sentence.addParam(dataFormat.format(dataIniziale));
            Date dataFinale = exc.getDataFinale();
            sentence.addParam(dataFormat.format(dataFinale));
            String userMessage = this.talkManager.getMessage(sentence);
            if (errori.add(String.valueOf(codicePod) + ";" + userMessage + ";" + rowEnd)) {
                this.talkManager.addSentence(sentence);
            }
            ErroriElaborazione errore = ErroriElaborazione.INCOHERENT_K;
            PdoRfoSospesiHandler handler = new PdoRfoSospesiHandler(this.status, this.destinatari, errore, userMessage);
            TariffeBuilder.handlePdoRfo(handler, pdo, azienda);
            MnoSospesiHandler mnoHandler = new MnoSospesiHandler(this.status, this.destinatari, errore, userMessage, this.anno, this.mese);
            TariffeBuilder.handleMno((List<Mno>)mnoList, mnoHandler);
            return newStatoCalcolo;
        }
        catch (InconsistentOptionException exc) {
            PrebillingError errore = exc.getErrore();
            String userMessage = exc.getUserMessage();
            PdoRfoSospesiHandler handler = new PdoRfoSospesiHandler(this.status, this.destinatari, errore, userMessage);
            TariffeBuilder.handlePdoRfo(handler, pdo, azienda);
            MnoSospesiHandler mnoHandler = new MnoSospesiHandler(this.status, this.destinatari, errore, userMessage, this.anno, this.mese);
            TariffeBuilder.handleMno((List<Mno>)mnoList, mnoHandler);
            if (!this.bloccoIndice) return newStatoCalcolo;
            throw exc;
        }
    }

    private String checkIndice(ContrattoEle contratto, Offerta offerta, TipoFlat tipoFlat, CurvaIndiciMensile curvaIndici, SafeMap<String, Offerta> offerte, Set<String> errori, String rowEnd) throws DataNotFoundException, InconsistentOptionException {
        String userMessage = "";
        if (this.configuration.isCheckPrezzi()) {
            userMessage = tipoFlat.isFixingSwap() ? this.checkIndiciFixingSwap(contratto, offerta, curvaIndici, errori, rowEnd) : this.checkIndiciDefault(contratto, offerta, curvaIndici, offerte, errori, rowEnd);
        }
        return userMessage;
    }

    private String checkIndiciFixingSwap(ContrattoEle contratto, Offerta offerta, CurvaIndiciMensile curvaIndici, Set<String> errori, String rowEnd) throws InconsistentOptionException, DataNotFoundException {
        double prezzoRiferimento;
        String riferimento;
        Date inizioMese = CalendarTools.getDate(this.anno, this.mese, 1);
        String codicePod = contratto.getCodice();
        Date dtIndice = contratto.getDtindice();
        String indice = offerta.getCodIndiceEnergetico();
        int mercato = offerta.getMercato();
        int zona = offerta.getZona();
        String key = String.valueOf(indice) + "/" + mercato + "/" + zona;
        String userMessage = this.checkDtIndice(codicePod, dtIndice, inizioMese, key, offerta, errori, rowEnd);
        double coeffUM = this.configuration.getCoeffUMPrezzi();
        double tolleranza = this.configuration.getTolleranzaPrezzi();
        double prezzoMedioIndice = curvaIndici.getPrezzoMedio() * coeffUM;
        if (offerta.isCmc()) {
            riferimento = "picco/fpicco";
            prezzoRiferimento = this.getPrezzoMedioCMC();
        } else {
            riferimento = "scivolo";
            prezzoRiferimento = contratto.getPrezzoMedio();
            if (prezzoRiferimento < 1.0E-8) {
                ErroriElaborazione errore = ErroriElaborazione.QTINDENE_ZERO;
                String message = errore.getMessage();
                userMessage = this.handleInconsistentPrezzi(message, codicePod, key, dtIndice, inizioMese, 0.0, 0.0, "", "", errori, rowEnd);
                throw new InconsistentOptionException(key, dtIndice, null, 0.0, 0.0, errore, userMessage);
            }
        }
        if (Math.abs(prezzoRiferimento - prezzoMedioIndice) > tolleranza) {
            ErroriElaborazione errore = ErroriElaborazione.INCONSISTENT_PREZZO_MEDIO;
            String message = errore.getMessage();
            userMessage = this.handleInconsistentPrezzi(message, codicePod, key, dtIndice, inizioMese, prezzoMedioIndice, prezzoRiferimento, riferimento, "", errori, rowEnd);
            if (this.bloccoIndice) {
                throw new InconsistentOptionException(key, dtIndice, inizioMese, prezzoMedioIndice, prezzoRiferimento, errore, userMessage);
            }
        }
        return userMessage;
    }

    private String checkDtIndice(String codicePod, Date dtIndice, Date inizioMese, String key, Offerta offerta, Set<String> errori, String rowEnd) throws InconsistentOptionException {
        String userMessage = "";
        if (!inizioMese.equals(dtIndice) && !offerta.isCmc()) {
            ErroriElaborazione errore = dtIndice == null ? ErroriElaborazione.MISSING_DTINDICE : ErroriElaborazione.INCONSISTENT_DTINDICE;
            String message = errore.getMessage();
            userMessage = this.handleInconsistentPrezzi(message, codicePod, key, dtIndice, inizioMese, 0.0, 0.0, "", "", errori, rowEnd);
            if (this.bloccoIndice) {
                throw new InconsistentOptionException(key, dtIndice, inizioMese, 0.0, 0.0, errore, userMessage);
            }
        }
        return userMessage;
    }

    private String checkIndiciDefault(ContrattoEle contratto, Offerta offerta, CurvaIndiciMensile curvaIndici, SafeMap<String, Offerta> offerte, Set<String> errori, String rowEnd) throws DataNotFoundException, InconsistentOptionException {
        double prezzoMedioRiferimento;
        String codIndRiferimento;
        String riferimento;
        Date inizioMese = CalendarTools.getDate(this.anno, this.mese, 1);
        String reseller = this.destinatari.getAzienda(contratto);
        String codIndEne = contratto.getCodIndiceEnergetico();
        String codIndScivolo = TariffeBuilder.getCodIndiceScivolo(offerte, codIndEne);
        String codicePod = contratto.getCodice();
        int mercato = offerta.getMercato();
        int zona = offerta.getZona();
        String userMessage = "";
        double prezzoMedioIndice = curvaIndici.getPrezzoMedio();
        if (offerta.isCmc()) {
            riferimento = "picco/fpicco";
            codIndRiferimento = codIndEne;
            prezzoMedioRiferimento = this.getPrezzoMedioCMC();
        } else {
            riferimento = "scivolo";
            codIndRiferimento = codIndScivolo;
            prezzoMedioRiferimento = this.getPrezzoMedioContratto(codicePod, inizioMese, codIndScivolo, prezzoMedioIndice, reseller, errori, rowEnd);
        }
        String codice = String.valueOf(codicePod) + " - " + codIndEne + "/" + mercato + "/" + zona;
        double tolleranza = this.configuration.getTolleranzaPrezzi();
        if (Math.abs(prezzoMedioRiferimento - prezzoMedioIndice) > tolleranza) {
            ErroriElaborazione errore = ErroriElaborazione.INCONSISTENT_PREZZO_MEDIO;
            String message = errore.getMessage();
            userMessage = this.handleInconsistentPrezzi(message, codicePod, codIndRiferimento, inizioMese, null, prezzoMedioIndice, prezzoMedioRiferimento, riferimento, "", errori, rowEnd);
            if (this.bloccoIndice) {
                throw new InconsistentOptionException(codice, inizioMese, null, prezzoMedioIndice, prezzoMedioRiferimento, errore, userMessage);
            }
        }
        return userMessage;
    }

    private double getPrezzoMedioContratto(String codicePod, Date inizioMese, String codIndScivolo, double prezzoMedioIndice, String reseller, Set<String> errori, String rowEnd) throws InconsistentOptionException {
        double prezzoMedioContratto;
        try {
            double coeffUmPrezzi = this.configuration.getCoeffUMPrezzi();
            prezzoMedioContratto = this.prezziMedi.getPrezzo(reseller, codIndScivolo) / coeffUmPrezzi;
        }
        catch (DataNotFoundException exc) {
            String key = exc.getKey();
            ErroriElaborazione errore = ErroriElaborazione.MISSING_DTINDICE;
            String message = errore.getMessage();
            String userMessage = this.handleInconsistentPrezzi(message, codicePod, key, null, inizioMese, 0.0, 0.0, "", " in PREZZI_SCIVOLO", errori, rowEnd);
            if (this.bloccoIndice) {
                throw new InconsistentOptionException(key, inizioMese, null, 0.0, 0.0, errore, userMessage);
            }
            prezzoMedioContratto = prezzoMedioIndice;
        }
        return prezzoMedioContratto;
    }

    private String handleInconsistentPrezzi(String message, String codicePod, String key, Date date, Date refDate, double price, double refPrice, String riferimento, String tabella, Set<String> errori, String rowEnd) {
        Message sentence = new Message("compute.tariffe", message);
        sentence.addParam(codicePod);
        sentence.addParam(key);
        DateFormat dataFormat = StrategyHelper.getDataFormat();
        DecimalFormat doubleFormat = StrategyCommonHelper.getPriceFormat();
        sentence.addParam(date == null ? null : dataFormat.format(date));
        sentence.addParam(refDate == null ? null : dataFormat.format(refDate));
        sentence.addParam(doubleFormat.format(price));
        sentence.addParam(doubleFormat.format(refPrice));
        sentence.addParam(riferimento);
        sentence.addParam(tabella);
        String userMessage = this.talkManager.getMessage(sentence);
        if (errori.add(String.valueOf(codicePod) + ";" + userMessage + ";" + rowEnd)) {
            this.talkManager.addSentence(sentence);
        }
        return userMessage;
    }

    private static String getCodIndiceScivolo(SafeMap<String, Offerta> offerte, String codIndiceEnergetico) throws DataNotFoundException {
        String codIndiceScivolo;
        if (offerte == null || StringUtils.isEmpty(codIndiceEnergetico) || codIndiceEnergetico.equals("0")) {
            codIndiceScivolo = codIndiceEnergetico;
        } else {
            Offerta offerta = (Offerta)offerte.get(codIndiceEnergetico);
            codIndiceScivolo = offerta.getCodIndiceScivolo();
        }
        return codIndiceScivolo;
    }

    private double getPrezzoMedioCMC() throws DataNotFoundException {
        ValorePicco next;
        Date start;
        if (this.orePicco == null) {
            this.orePicco = this.misureDao.getOrePicco(this.anno, this.mese);
        }
        if (this.valoriPicco == null) {
            this.valoriPicco = this.misureDao.getValoriPicco();
        }
        TappoIterator<ValorePicco> valoriPiccoIterator = new TappoIterator<ValorePicco>(this.valoriPicco, TAPPO);
        Date endDate = CalendarTools.getNextMese(this.anno, this.mese);
        ElaborCalendar calendar = new ElaborCalendar(this.anno, this.mese);
        Date date = calendar.getDate();
        ValorePicco valorePicco = null;
        while (!(start = (next = valoriPiccoIterator.next()).getStart()).after(date)) {
            valorePicco = next;
        }
        if (valorePicco == null) {
            ErroriElaborazione errore = ErroriElaborazione.MISSING_VALORI_PICCO;
            String message = errore.getMessage();
            int error = errore.ordinal();
            String key = StrategyCommonHelper.getStandardDateFormat().format(date);
            throw new DataNotFoundException(message, key, error);
        }
        double totale = 0.0;
        int numero = 0;
        do {
            Date start2;
            if (!(start2 = next.getStart()).after(date)) {
                valorePicco = next;
                next = valoriPiccoIterator.next();
            }
            double valore = this.orePicco.contains(date) ? valorePicco.getValorePicco() : valorePicco.getValoreNonPicco();
            totale += valore;
            ++numero;
            calendar.addOre(1);
        } while ((date = calendar.getDate()).before(endDate));
        return totale / (double)numero;
    }

    private void remove(String azienda, String codicePod) {
        List tariffeAzienda = (List)this.tariffe.get(azienda);
        if (tariffeAzienda != null) {
            Iterator iterator = tariffeAzienda.iterator();
            while (iterator.hasNext()) {
                TariffaMultiApplicazione current = (TariffaMultiApplicazione)iterator.next();
                if (!current.getContratto().getCodice().equals(codicePod)) continue;
                iterator.remove();
            }
        }
    }

    private static boolean isForfait(List<Mno> mnoList) throws MisuraException {
        boolean forfait = false;
        if (mnoList != null && !mnoList.isEmpty()) {
            Iterator<Mno> iterator = mnoList.iterator();
            Mno mno = iterator.next();
            forfait = mno.isForfait();
            while (iterator.hasNext()) {
                mno = iterator.next();
                if (forfait == mno.isForfait()) continue;
                throw new MisuraException(ErroriElaborazione.FORFAIT_CHANGED, mno.getCodicePod(), mno.getDataMisura(), mno.getCodiceFlusso());
            }
        }
        return forfait;
    }

    private void checkQtindene(ContrattoEle contratto, Set<String> errori, String rowEnd) throws InconsistentOptionException, DataNotFoundException {
        String reseller = contratto.getReseller();
        ContrattiPodList contrattiAzienda = (ContrattiPodList)this.contratti.get(reseller);
        String codicePod = contratto.getCodice();
        RilMeseTot rilMeseTot = this.mappaMultiConsumi.get(codicePod);
        List<MultipuntoOption> opzioniFixingSwap = rilMeseTot.getOpzioniFixingSwap();
        if (!opzioniFixingSwap.isEmpty()) {
            MultipuntoOption multipuntoOption = opzioniFixingSwap.get(0);
            String codiceRaggruppamento = multipuntoOption.getKey();
            Multipunto multiPunto = this.multiPodMap.get(codiceRaggruppamento);
            for (MultipuntoEntry entry : multiPunto.getEntries()) {
                String key = entry.getKey();
                if (!contrattiAzienda.contains(key)) continue;
                List contrattiPod = (List)contrattiAzienda.get(key);
                for (ContrattoEle contrattoPod : contrattiPod) {
                    if (contrattoPod.getPrezzoMedio() != 0.0) continue;
                    Date inizioMese = CalendarTools.getDate(this.anno, this.mese, 1);
                    Date tariffaStartDate = ContrattiHelper.getInizioTariffa(contratto, inizioMese);
                    ErroriElaborazione errore = ErroriElaborazione.QTINDENE_ZERO;
                    String message = errore.getMessage();
                    String codIndiceEnergetico = contratto.getCodIndiceEnergetico();
                    String userMessage = this.handleInconsistentPrezzi(message, codicePod, codIndiceEnergetico, tariffaStartDate, null, 0.0, 0.0, "", "", errori, rowEnd);
                    throw new InconsistentOptionException(codIndiceEnergetico, tariffaStartDate, null, 0.0, 0.0, errore, userMessage);
                }
            }
        }
    }

    private TariffaMultiApplicazione eseguiScivolo(ContrattoEle contratto, Date inizioMese, Date inizioMeseSucc, TipoFlat tipoFlat, double coeffPerdite, double coeffUM, double consumoFlatOra, boolean rettifica, boolean perdite, SafeMap<String, Offerta> offerte) throws DataNotFoundException, CalendarNotFoundException {
        TariffaApplicazione tariffaScivolo = contratto.isFixing() || tipoFlat.isFixing() ? this.buildTariffaScivoloFixing(contratto, coeffUM, offerte) : this.buildTariffaScivolo(inizioMese, inizioMeseSucc, contratto, tipoFlat, coeffUM, consumoFlatOra, offerte);
        Date tariffaStartDate = ContrattiHelper.getInizioTariffa(contratto, inizioMese);
        return new TariffaMultiApplicazione((Contratto)contratto, tariffaStartDate, perdite, coeffPerdite, true, rettifica, tariffaScivolo);
    }

    private static List<Mno> getMnoListNoMno(List<Mno> mnoList) {
        List<Mno> mnoListNoVno;
        if (mnoList == null) {
            mnoListNoVno = null;
        } else {
            Condition<Mno> condition = new Condition<Mno>(){

                @Override
                public boolean check(Mno item) {
                    return !item.getCodiceFlusso().contains("VNO");
                }
            };
            Filter<Mno> filter = new Filter<Mno>(condition);
            mnoListNoVno = filter.filter(mnoList);
        }
        return mnoListNoVno;
    }

    private static double getQtMisuraFixingSwap(Contratto contratto, double consumoTotaleFixingSwap, List<MultipuntoOption> opzioniFixingSwap) {
        double volume = 0.0;
        for (MultipuntoOption option : opzioniFixingSwap) {
            volume += option.getVolume();
        }
        double qtConsum = contratto.getQtconsum();
        return volume * qtConsum / consumoTotaleFixingSwap;
    }

    private double getQtMisura(RilMese rilMese, ContrattoEle contratto) {
        Date inizio = ContrattiHelper.getInizioTariffa(contratto, this.anno, this.mese);
        Date fine = ContrattiHelper.getFineTariffa(this.anno, this.mese, contratto);
        double qtMisura = 0.0;
        for (RilGiorno rilGiorno : rilMese) {
            Date data = rilGiorno.getDate();
            if (data.before(inizio) || data.after(fine)) continue;
            qtMisura += TariffeBuilder.getQtMisura(rilGiorno);
        }
        return qtMisura;
    }

    private static double getQtMisura(RilGiorno rilGiorno) {
        double qtMisura = 0.0;
        for (RilQuarto rilQuarto : rilGiorno) {
            Double attiva = rilQuarto.getAttiva();
            qtMisura += (attiva == null ? 0.0 : attiva) * rilQuarto.getKa();
        }
        return qtMisura;
    }

    private TariffaApplicazione buildTariffaScivoloFixing(Contratto contratto, double coeffUM, SafeMap<String, Offerta> offerte) throws DataNotFoundException {
        String codIndiceEnergetico = contratto.getCodIndiceEnergetico();
        int tipoApplicazione = contratto.getTipoApplicazione();
        double emtaruni = contratto.getEmtaruni();
        Date dataTariffa = ContrattiHelper.getInizioTariffa(contratto, this.anno, this.mese);
        double qtconfla = contratto.getQtConFla();
        double[] prezziDefault = new double[3];
        double emspread = contratto.getEmspread();
        double emspreneg = contratto.getEmspreneg();
        TipoFlatPrezzoExtractor extractor = new TipoFlatPrezzoExtractor(TipoFlat.NON_FLAT);
        TariffaMonoraria misura = new TariffaMonoraria(dataTariffa, coeffUM, qtconfla, prezziDefault, emtaruni, emspread, emspreneg, extractor);
        DaysOfMonthIterator dIterator = new DaysOfMonthIterator(this.anno, this.mese);
        while (dIterator.hasNext()) {
            int giorno = dIterator.next();
            Date data = CalendarTools.getDate(this.anno, this.mese, giorno);
            int hoursOfDay = CalendarTools.getHoursOfDay(this.anno, this.mese, giorno);
            int ora = 0;
            while (ora < hoursOfDay) {
                double valoreOra = qtconfla * emtaruni;
                DettaglioTariffa dettaglio = new DettaglioTariffa(data, ora, 1.0, qtconfla, emtaruni, null, 0.0, qtconfla, valoreOra, 0.0);
                misura.addDettaglio(dettaglio);
                ++ora;
            }
        }
        Offerta offerta = (Offerta)offerte.get(codIndiceEnergetico);
        String codIndiceScivolo = offerta.getCodIndiceScivolo();
        return new TariffaApplicazione(misura, tipoApplicazione, codIndiceScivolo);
    }

    private TariffaApplicazione calcolaPenale(ContrattoEle contratto, MappaIndici mappaIndici, SafeMap<String, Offerta> offerte, double coeffUM) throws DataNotFoundException {
        TariffaApplicazione tariffa = null;
        int tipoAppPenale = contratto.getTipoAppPenale();
        if (tipoAppPenale != 0) {
            double qtConFla = contratto.getQtConFla();
            double prezzoFlat = contratto.getEmtaruni();
            double emspread = contratto.getEmspread();
            double emspreneg = contratto.getEmspreneg();
            String cdindneg = contratto.getCdindneg();
            Offerta offertaPenale = (Offerta)offerte.get(cdindneg);
            CurvaIndiciMensile indici = mappaIndici.get(offertaPenale, this.talkManager);
            Iterator pIterator = indici.iterator();
            Date dataTariffa = CalendarTools.getDate(this.anno, this.mese, 1);
            PenaleExtractor extractor = new PenaleExtractor();
            TariffaMonoraria misura = new TariffaMonoraria(dataTariffa, 0.0, qtConFla, null, prezzoFlat, emspread, emspreneg, extractor);
            DaysOfMonthIterator dIterator = new DaysOfMonthIterator(this.anno, this.mese);
            while (dIterator.hasNext() && pIterator.hasNext()) {
                int giorno = dIterator.next();
                CurvaIndiciGiornaliera curvaIndGiorno = (CurvaIndiciGiornaliera)pIterator.next();
                Date data = CalendarTools.getDate(this.anno, this.mese, giorno);
                int hoursOfDay = CalendarTools.getHoursOfDay(this.anno, this.mese, giorno);
                int ora = 0;
                while (ora < hoursOfDay) {
                    IndiceOrario indiceOrario = (IndiceOrario)curvaIndGiorno.get(ora);
                    double prezzo = indiceOrario.getPrezzo();
                    double prezzoOraReale = MathUtils.round(prezzo * coeffUM, 8);
                    double prezzoPenaleOra = Math.max(0.0, prezzoFlat - prezzoOraReale + emspreneg);
                    double valorePenaleOra = qtConFla * prezzoPenaleOra;
                    DettaglioTariffa dettaglio = new DettaglioTariffa(data, ora, 1.0, qtConFla, prezzoPenaleOra, null, qtConFla, qtConFla, valorePenaleOra, 0.0);
                    misura.addDettaglio(dettaglio);
                    ++ora;
                }
            }
            tariffa = new TariffaApplicazione(misura, tipoAppPenale, cdindneg);
        }
        return tariffa;
    }

    private CalendarioFasceMensile getCalendarioFasce(ContrattoEle contratto) throws CalendarNotFoundException {
        String codicePod = contratto.getCodice();
        String codiceOfferta = contratto.getCodiceOfferta();
        String idCalendario = TariffeHelper.getCalendarId(codiceOfferta, this.status);
        CalendarMap calendarMap = this.status.getCalendarMap();
        return CalendarioCommercialeHelper.getCalendario(idCalendario, this.anno, this.mese, codicePod, calendarMap);
    }

    private TariffaApplicazione buildTariffaScivolo(Date inizioMese, Date inizioMeseSucc, ContrattoEle contratto, TipoFlat tipoFlat, double coeffUM, double qtconfla, SafeMap<String, Offerta> offerte) throws DataNotFoundException, CalendarNotFoundException {
        Date date;
        CalendarioFasceMensile calendarioFasce = this.getCalendarioFasce(contratto);
        String codIndiceEnergetico = contratto.getCodIndiceEnergetico();
        Offerta offerta = (Offerta)offerte.get(codIndiceEnergetico);
        double[] prezziDefault = new double[]{0.0, 0.0, 0.0};
        double emtaruni = contratto.getEmtaruni();
        double emspread = contratto.getEmspread();
        double emspreneg = contratto.getEmspreneg();
        TipoFlatPrezzoExtractor extractor = new TipoFlatPrezzoExtractor(tipoFlat);
        TariffaMonoraria tariffa = new TariffaMonoraria(null, coeffUM, qtconfla, prezziDefault, emtaruni, emspread, emspreneg, extractor);
        ElaborCalendar calendar = new ElaborCalendar(inizioMese);
        while ((date = calendar.getDate()).before(inizioMeseSucc)) {
            int giorno = calendar.getGiorno();
            CalendarioFasceGiornaliero calendarioFasceGiornaliero = calendarioFasce.getFasciaGiornaliera(giorno);
            int hour = 1;
            int hourIndex = 1;
            while (hourIndex <= CalendarTools.getHoursOfDay(date)) {
                FasciaOraria fascia = calendarioFasceGiornaliero.getFascia(hour);
                double prezzoFascia = prezziDefault[fascia.ordinal()];
                DettaglioTariffa dettaglio = new DettaglioTariffa(date, hour, 1.0, 0.0, prezzoFascia, null, qtconfla, 0.0, 0.0, 0.0);
                tariffa.addDettaglio(dettaglio);
                if (!CalendarTools.isLegalToSolarHour(this.anno, this.mese, giorno, hourIndex)) {
                    ++hour;
                }
                ++hourIndex;
            }
            calendar.addGiorni(1);
        }
        String codIndiceScivolo = offerta.getCodIndiceScivolo();
        offerte.get(codIndiceScivolo);
        int tipoApplicazione = contratto.getTipoApplicazione();
        return new TariffaApplicazione(tariffa, tipoApplicazione, codIndiceScivolo);
    }

    private boolean buildSubTariffe(MappaIndici mappaIndici, Date inizioMese, Date endDate, ContrattoEle contratto, SafeMap<String, Offerta> offerte, TariffeAccumulator accumulator, List<TariffaApplicazione> subTariffe) throws InvalidCurvaRilevazioniException, InvalidCurvaIndiciException, IncoherentKException, SmisException, DataNotFoundException {
        Date inizioContratto = ContrattiHelper.getInizioTariffa(contratto, this.anno, this.mese);
        List<Applicazione> subApplicazioni = this.getSubApplicazioni(contratto);
        boolean scivolo = false;
        for (Applicazione subApp : subApplicazioni) {
            TipoFlat tipoFlat = subApp.getTipoFlat();
            String codIndEne = tipoFlat.getCodiceIndiceEnergetico(contratto);
            Offerta offerta = (Offerta)offerte.get(codIndEne);
            CurvaIndiciMensile curvaIndici = mappaIndici.get(offerta, this.talkManager);
            accumulator.init(curvaIndici);
            TariffeBuilder.handleStartDate(inizioMese, inizioContratto, accumulator);
            TipoFlatPrezzoExtractor extractor = new TipoFlatPrezzoExtractor(tipoFlat);
            MisuraFasceQuantita misura = accumulator.buildMisura(endDate, extractor);
            if (tipoFlat.isFixingSwap()) {
                misura.clearDettagli();
            }
            String codIndiceEnergetico = offerta.getCodIndiceEnergetico();
            boolean scivoloApp = misura.getQtMisura() == 0.0;
            String codIndiceApplicato = scivoloApp ? offerta.getCodIndiceScivolo() : codIndiceEnergetico;
            scivolo |= scivoloApp;
            int tipoApplicazione = subApp.getTipo();
            TariffaApplicazione tariffa = new TariffaApplicazione(misura, tipoApplicazione, codIndiceApplicato);
            subTariffe.add(tariffa);
        }
        return scivolo;
    }

    private static void checkValidity(ContrattoEle contratto) throws InvalidValidityException {
        Date dataInizio = contratto.getDataInizio();
        Date dataValidita = contratto.getDataValidita();
        if (dataValidita.before(dataInizio)) {
            String codicePod = contratto.getCodice();
            String azienda = contratto.getReseller();
            throw new InvalidValidityException(codicePod, azienda, dataValidita, dataInizio);
        }
    }

    private List<Applicazione> getSubApplicazioni(ContrattoEle contratto) throws DataNotFoundException {
        List<Applicazione> subApplicazioni;
        Applicazione applicazione = this.status.getApplicazione(contratto);
        TipoFlat tipoFlat = applicazione.getTipoFlat();
        if (contratto.isFixing() || tipoFlat.isFixing()) {
            subApplicazioni = TariffeCommonHelper.getSubapplicazioni(applicazione, this.anno, this.mese, this.status, this.misureDao);
            if (subApplicazioni.isEmpty()) {
                if (tipoFlat.isFixing()) {
                    ErroriElaborazione errore = ErroriElaborazione.SUBAPP_NOTFOUND;
                    String message = errore.getMessage();
                    int idTipoApp = applicazione.getTipo();
                    int ordinal = errore.ordinal();
                    throw new DataNotFoundException(message, idTipoApp, ordinal);
                }
                subApplicazioni.add(applicazione);
            }
        } else {
            subApplicazioni = Arrays.asList(applicazione);
        }
        return subApplicazioni;
    }

    private static Date handleStartDate(Date inizioMese, Date inizioContratto, TariffeAccumulator accumulator) throws InvalidCurvaRilevazioniException, InvalidCurvaIndiciException, IncoherentKException, SmisException {
        Date tariffaStartDate;
        if (inizioContratto.after(inizioMese)) {
            MisuraFasceQuantita misura;
            NullPrezzoExtractor extractor = new NullPrezzoExtractor();
            ElaborCalendar prevCalendar = new ElaborCalendar(inizioContratto);
            prevCalendar.addGiorni(-1);
            Date prevDate = prevCalendar.getDate();
            while ((misura = accumulator.buildMisura(prevDate, extractor)) != null && misura.getDate().before(prevDate)) {
            }
            tariffaStartDate = inizioContratto;
        } else {
            tariffaStartDate = inizioMese;
        }
        return tariffaStartDate;
    }

    private static void handleMno(List<Mno> mnoList, MisureHandler<Mno> handler) {
        if (mnoList != null) {
            for (Mno mno : mnoList) {
                handler.handleMisura(mno, null);
            }
        }
    }

    public static <T> T getMisura(String codicePod, ListMap<String, T> map) {
        List list = (List)map.get(codicePod);
        return list == null ? null : (T)list.get(0);
    }

    private double getCoeffPerdite(Contratto contratto, Date data) throws MissingCoeffPerditeException, DataNotFoundException {
        int livello = contratto.getLivello();
        return this.status.getCoeffPerdite(livello, data);
    }

    private static Date getEndDate(Date end, Contratto contratto) {
        Date dataFine = contratto.getDataFine();
        Date dataScadenza = contratto.getDataSospensione();
        Date endDate = end;
        if (dataScadenza != null && endDate.after(dataScadenza)) {
            endDate = dataScadenza;
        }
        if (dataFine != null && endDate.after(dataFine)) {
            endDate = dataFine;
        }
        return endDate;
    }

    private static void handlePdoRfo(MisureHandler<Pdo> handler, Pdo pdo, String azienda) {
        if (pdo != null) {
            handler.handleMisura(pdo, azienda);
        }
    }

    private void fillConsumiCumulativi() throws CalendarNotFoundException {
        this.mappaMultiConsumi = new HashMap<String, RilMeseTot>();
        for (Multipunto multiPodList : this.multiPodMap.values()) {
            RilMeseTot rilMeseTot = null;
            for (MultipuntoEntry multipuntoEntry : multiPodList.getEntries()) {
                String codicePod = multipuntoEntry.getKey();
                if (rilMeseTot == null) {
                    rilMeseTot = this.buildRilMeseTot(multiPodList);
                }
                this.mappaMultiConsumi.put(codicePod, rilMeseTot);
            }
        }
    }

    private RilMeseTot buildRilMeseTot(Multipunto multipunto) throws CalendarNotFoundException {
        HashSet<String> podBatch = new HashSet<String>();
        Set<String> erroriTariffe = this.status.getErroriTariffe();
        List<MultipuntoEntry> entries = multipunto.getEntries();
        StructuresHelper.buildCollection(podBatch, entries);
        ListMap<String, Pdo> pdoMap = this.misureDao.getPdoTariffe(this.destinatari, podBatch, this.anno, this.mese);
        ListMap<String, Mno> pnoMap = this.misureDao.getPnoTariffe(this.destinatari, podBatch, this.annoStart, this.meseStart, this.annoRif, this.meseRif);
        RilMeseTot rilMeseTot = this.initRilMese();
        double consumoTotaleFixingSwap = 0.0;
        for (MultipuntoEntry multipuntoEntry : entries) {
            Date date;
            Message sentence;
            String message;
            String codicePod = multipuntoEntry.getKey();
            PrebillingContext.setContext("buildRilMeseTot", String.valueOf(codicePod) + " - " + this.anno + "/" + this.mese.getIndex());
            Date startDate = multipuntoEntry.getInizio();
            Date endDate = multipuntoEntry.getFine();
            String rowEnd = null;
            try {
                List<ContrattoEle> contrattiPod = this.getContrattiPod(codicePod);
                consumoTotaleFixingSwap += this.getConsumoFixingSwap(contrattiPod);
                ContrattoEle contratto = contrattiPod.get(0);
                String azienda = contratto.getReseller();
                rowEnd = String.valueOf(azienda) + ";" + this.anno + ";" + this.mese.getIndex() + ";";
                RilMese rilMese = this.getRilMese(contratto, pdoMap, pnoMap, contrattiPod);
                Date inizioLetture = ContrattiHelper.getInizioTariffa(contratto, this.anno, this.mese);
                double coeffPerdite = 1.0 + this.getCoeffPerdite(contratto, inizioLetture) / 100.0;
                rilMeseTot.merge(rilMese, startDate, endDate, coeffPerdite);
            }
            catch (MisuraException exc) {
                message = exc.getMessage();
                sentence = new Message("consumi.complessivi", message);
                sentence.addParam(exc.getKey());
                DateFormat dataFormat = StrategyHelper.getDataFormat();
                sentence.addParam(dataFormat.format(exc.getData()));
                sentence.addParam(exc.getFlusso());
                this.talkManager.addSentence(sentence);
                rilMeseTot.setScivolo(true);
            }
            catch (CalendarException | SmisException exc) {
                message = exc.getMessage();
                sentence = new Message("consumi.complessivi", message);
                this.talkManager.addSentence(sentence);
                rilMeseTot.setScivolo(true);
            }
            catch (DataNotFoundException exc) {
                message = exc.getMessage();
                if (message.startsWith("contratto")) continue;
                sentence = new Message("compute.tariffe", message);
                String key = exc.getKey();
                sentence.addParam(key);
                sentence.addParam(codicePod);
                sentence.addParam(String.valueOf(this.anno) + "/" + (Object)((Object)this.mese));
                this.talkManager.addSentence(sentence);
                rilMeseTot.setScivolo(true);
            }
            catch (ConsumiException exc) {
                message = exc.getMessage();
                sentence = new Message("compute.tariffe", message);
                sentence.setParams(exc.getParams());
                this.talkManager.addSentence(sentence);
                rilMeseTot.setScivolo(true);
            }
            catch (InvalidSegnantiException exc) {
                message = exc.getMessage();
                sentence = new Message("compute.tariffe", message);
                sentence.addParam(codicePod);
                DateFormat dataFormat = StrategyHelper.getDataFormat();
                Date dataIniziale = exc.getDataIniziale();
                sentence.addParam(dataFormat.format(dataIniziale));
                Date dataFinale = exc.getDataFinale();
                sentence.addParam(dataFormat.format(dataFinale));
                this.talkManager.addSentence(sentence);
                rilMeseTot.setScivolo(true);
            }
            catch (InvalidCurvaRilevazioniException exc) {
                message = exc.getMessage();
                date = exc.getDate();
                Message sentence2 = new Message("compute.tariffe", message);
                sentence2.addParam(codicePod);
                DateFormat dataFormat = StrategyHelper.getDataFormat();
                sentence2.addParam(date == null ? "sconosciuta" : dataFormat.format(date));
                this.talkManager.addSentence(sentence2);
                rilMeseTot.setScivolo(true);
            }
            catch (MissingCoeffPerditeException exc) {
                message = exc.getMessage();
                date = exc.getData();
                int livello = exc.getLivello();
                Message sentence3 = new Message("compute.tariffe", message);
                sentence3.addParam(codicePod);
                DateFormat dataFormat = StrategyHelper.getDataFormat();
                sentence3.addParam(dataFormat.format(date));
                sentence3.addParam(String.valueOf(livello));
                String userMessage = this.talkManager.getMessage(sentence3);
                if (erroriTariffe.add(String.valueOf(codicePod) + ";" + userMessage + ";" + rowEnd)) {
                    this.talkManager.addSentence(sentence3);
                }
                rilMeseTot.setScivolo(true);
            }
        }
        rilMeseTot.setConsumoTotaleFixingSwap(consumoTotaleFixingSwap);
        List<MultipuntoOption> options = multipunto.getOptions(this.anno, this.mese);
        rilMeseTot.setOpzioniFixingSwap(options);
        return rilMeseTot;
    }

    private double getConsumoFixingSwap(List<ContrattoEle> contrattiPod) {
        double consumoFixingSwap = 0.0;
        for (Contratto contratto : contrattiPod) {
            Applicazione applicazione = this.status.getApplicazione(contratto);
            TipoFlat tipoFlat = applicazione.getTipoFlat();
            if (!tipoFlat.isFixingSwap()) continue;
            consumoFixingSwap = contratto.getQtconsum();
        }
        return consumoFixingSwap;
    }

    private RilMese getRilMese(ContrattoEle contratto, ListMap<String, Pdo> pdoMap, ListMap<String, Mno> pnoMap, List<ContrattoEle> contrattiPod) throws DataNotFoundException, ConsumiException, CalendarNotFoundException, CalendarException, SmisException, InvalidCurvaRilevazioniException, MisuraException, InvalidSegnantiException {
        RilMese rilMese;
        String codicePod = contratto.getCodice();
        Pdo pdo = TariffeBuilder.getMisura(codicePod, pdoMap);
        Date inizioConsumi = ContrattiHelper.getInizioTariffa(contratto, this.anno, this.mese);
        List<Lettura> letture = this.misureDao.getLetture(codicePod, inizioConsumi);
        List mnoList = (List)pnoMap.get(codicePod);
        if (pdo == null) {
            List<Lettura> letturaDataSingola = TariffeHelper.getRilevazioniDataSingola(letture);
            Date fineConsumi = ContrattiHelper.getFineTariffa(this.anno, this.mese, contratto);
            boolean complessivo = this.configuration.isConsumoComplessivo();
            boolean forfait = TariffeBuilder.isForfait(mnoList);
            rilMese = TariffeHelper.buildRilmeseFromLetture(contratto, forfait, inizioConsumi, fineConsumi, letturaDataSingola, contrattiPod, complessivo, this.status);
        } else {
            rilMese = pdo.getRilMese();
            String pivaDistr = pdo.getPivaDistributore();
            Date dataLetPre = contratto.getDataUltimaLettura();
            this.fixMissingDays(rilMese, contratto, pivaDistr, mnoList, dataLetPre);
        }
        return rilMese;
    }

    private void fixMissingDays(RilMese rilMese, ContrattoEle contratto, String pivaDistr, List<Mno> mnoList, Date dataLetPre) throws DataNotFoundException, InvalidSegnantiException, SmisException, CalendarException, CalendarNotFoundException, InvalidCurvaRilevazioniException {
        String codicePod = contratto.getCodice();
        Date inizioConsumi = ContrattiHelper.getInizioTariffa(contratto, this.anno, this.mese);
        Date fineConsumi = ContrattiHelper.getFineTariffa(this.anno, this.mese, contratto);
        String codiceOfferta = contratto.getCodiceOfferta();
        String codComIst = contratto.getCdComIst();
        ConsumiHelper.fixMissingDays(rilMese, codicePod, inizioConsumi, fineConsumi, pivaDistr, codComIst, codiceOfferta, mnoList, dataLetPre, this.annoRif, this.meseRif, this.status, this.destinatari, this.misureDao, this.configuration, true);
    }

    private List<ContrattoEle> getContrattiPod(String codicePod) throws DataNotFoundException {
        List contrattiPod = null;
        for (Map.Entry entry : this.contratti.entrySet()) {
            ContrattiPodList contrattiAzienda = (ContrattiPodList)entry.getValue();
            try {
                contrattiPod = (List)contrattiAzienda.get(codicePod);
                break;
            }
            catch (DataNotFoundException dataNotFoundException) {
                // empty catch block
            }
        }
        if (contrattiPod == null) {
            throw new DataNotFoundException("contratto.notFound", codicePod, 0);
        }
        return contrattiPod;
    }

    private RilMeseTot initRilMese() {
        RilMeseTot rilMese = new RilMeseTot(null, this.anno, this.mese, null);
        for (int day : new DaysOfMonthIterable(this.anno, this.mese)) {
            Date date = CalendarTools.getDate(this.anno, this.mese, day);
            RilGiorno rilGiorno = new RilGiorno(date);
            int index = 0;
            while (index < CalendarTools.getHoursOfDay(date) * 4) {
                RilQuarto rilQuarto = new RilQuarto(index, "", "", ZERO, ZERO, ZERO, ZERO, 1.0, RilQuartoType.REALE);
                rilGiorno.add(rilQuarto);
                ++index;
            }
            rilMese.add(rilGiorno);
        }
        return rilMese;
    }
}

