/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.prebilling.common.model.Contratto;
import biz.elabor.prebilling.model.tariffe.DettaglioTariffa;
import biz.elabor.prebilling.services.tariffe.ContrattoWrapper;
import biz.elabor.prebilling.services.tariffe.TariffaMultiApplicazione;
import java.util.Date;
import java.util.List;

public class Tariffa {
    private final Contratto contratto;
    private final ContrattoWrapper wrapper;
    private final TariffaMultiApplicazione tariffa;
    private final double aqconsum;
    private final Date dataScadenza;
    private final boolean rettifica;

    public Tariffa(Contratto contratto, ContrattoWrapper wrapper, TariffaMultiApplicazione tariffa, double aqconsum, Date dataScadenza, boolean rettifica) {
        this.contratto = contratto;
        this.wrapper = wrapper;
        this.tariffa = tariffa;
        this.aqconsum = aqconsum;
        this.dataScadenza = dataScadenza;
        this.rettifica = rettifica;
    }

    public String getCodIndiceApplicato() {
        return this.tariffa.getCodIndiceApplicato();
    }

    public double getAqconsum() {
        return this.aqconsum;
    }

    public String getCodicePod() {
        return this.contratto.getCodice();
    }

    public String getCodIndiceEnergetico() {
        return this.contratto.getCodIndiceEnergetico();
    }

    public Integer getCodZona() {
        return this.wrapper.getCodZona();
    }

    public Integer getCodUtente() {
        return this.wrapper.getCodUtente();
    }

    public Integer getCodAzienda() {
        return this.wrapper.getCodAzienda();
    }

    public Date getDataRevoca() {
        return this.contratto.getDataRevoca();
    }

    public Date getDataScadenza() {
        return this.dataScadenza;
    }

    public Date getStartDate() {
        return this.tariffa.getStartDate();
    }

    public String getAzienda() {
        return this.contratto.getReseller();
    }

    public boolean isRettifica() {
        return this.rettifica;
    }

    public List<DettaglioTariffa> getFirstDettagli() {
        return this.tariffa.getFirstDettagli();
    }

    public TariffaMultiApplicazione getTariffa() {
        return this.tariffa;
    }

    public Contratto getContratto() {
        return this.contratto;
    }

    public ContrattoWrapper getWrapper() {
        return this.wrapper;
    }

    public Date getDataSospensione() {
        return this.contratto.getDataSospensione();
    }
}

