/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.prebilling.common.model.Contratto;
import biz.elabor.prebilling.services.tariffe.ContrattoWrapper;
import org.homelinux.elabor.exceptions.DataException;

class ResellerCW
implements ContrattoWrapper {
    private Integer codAzienda;
    private Integer codZona;
    private Integer codUtente;

    public ResellerCW(Contratto contratto) {
        try {
            String cdUteRif = contratto.getCdUteRif();
            if (cdUteRif == null || cdUteRif.length() < 15) {
                throw new DataException("cduterif");
            }
            this.codAzienda = ResellerCW.getInteger(cdUteRif.substring(0, 3));
            this.codZona = ResellerCW.getInteger(cdUteRif.substring(3, 6));
            this.codUtente = ResellerCW.getInteger(cdUteRif.substring(6, 15));
        }
        catch (DataException exc) {
            this.codAzienda = null;
            this.codUtente = null;
            this.codZona = null;
        }
    }

    @Override
    public Integer getCodAzienda() {
        return this.codAzienda;
    }

    @Override
    public Integer getCodZona() {
        return this.codZona;
    }

    @Override
    public Integer getCodUtente() {
        return this.codUtente;
    }

    private static Integer getInteger(String string) throws DataException {
        Integer value;
        try {
            value = Integer.valueOf(string);
        }
        catch (NumberFormatException exc) {
            throw new DataException("cduterif");
        }
        return value;
    }
}

