/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.misure.model.fasce.CalendarioFasceMensile;
import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.tariffe.DettaglioTariffa;
import biz.elabor.prebilling.model.tariffe.MisuraFasceQuantita;
import biz.elabor.prebilling.model.tariffe.TariffaApplicazione;
import biz.elabor.prebilling.services.common.TariffeAccumulator;
import biz.elabor.prebilling.services.common.TariffeFasceAccumulator;
import biz.elabor.prebilling.services.tariffe.TariffaMultiApplicazione;
import biz.elabor.prebilling.services.tariffe.TipoCalcoloManager;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;

class FasceManager
implements TipoCalcoloManager {
    FasceManager() {
    }

    @Override
    public TariffeAccumulator getAccumulator(RilMese rilMese, CalendarioFasceMensile calendarioFasce, double coeffUM, Date startDate, double qtconfla, double KAttiva, double[] prezziDefault, boolean perdite, double coeffPerdite, double emtaruni, double emspread, double emspreneg, List<Mno> mnoList) {
        return new TariffeFasceAccumulator(rilMese, calendarioFasce, coeffUM, startDate, qtconfla, KAttiva, prezziDefault, perdite, coeffPerdite, emtaruni, emspread, emspreneg, mnoList);
    }

    @Override
    public void printSommaImportiOrari(TariffaMultiApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            double totale = tariffa.getSommaImportiOrari(fascia);
            writer.println(String.valueOf(label) + " " + fascia.name() + ";" + format.format(totale));
            ++n3;
        }
    }

    @Override
    public void printSommaImportiOrari(TariffaApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            MisuraFasceQuantita misura = tariffa.getTariffa();
            double totale = misura.getTotale(fascia);
            writer.println(String.valueOf(label) + " " + fascia.name() + ";" + format.format(totale));
            ++n3;
        }
    }

    @Override
    public void printSommaConsumi(TariffaMultiApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            double qtMisura = tariffa.getQtMisura(fascia);
            writer.println(String.valueOf(label) + " " + fascia.name() + ";" + format.format(qtMisura));
            ++n3;
        }
    }

    @Override
    public void printSommaConsumiEffettivi(TariffaMultiApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            double qtMisura = tariffa.getQtMisuraEffettiva(fascia);
            writer.println(String.valueOf(label) + " " + fascia.name() + ";" + format.format(qtMisura));
            ++n3;
        }
    }

    @Override
    public void printSommaConsumiCompl(TariffaMultiApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            double qtMisura = tariffa.getQtMisura(fascia);
            writer.println(String.valueOf(label) + " " + fascia.name() + ";" + format.format(qtMisura));
            ++n3;
        }
    }

    @Override
    public void printSommaConsumi(TariffaApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            double qtMisura = tariffa.getQtMisuraEffettiva(fascia);
            writer.println(String.valueOf(label) + " " + fascia.name() + ";" + format.format(qtMisura));
            ++n3;
        }
    }

    @Override
    public void printPrezzoMedioPonderatoPerdite(TariffaMultiApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            double prezzo = tariffa.getPrezzoMedioPonderatoPerdite(fascia);
            writer.println(String.valueOf(label) + " " + fascia.name() + ";" + format.format(prezzo));
            ++n3;
        }
    }

    @Override
    public void printPrezzoMedioPonderatoNetto(TariffaMultiApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            double prezzo = tariffa.getPrezzoMedioPonderatoNetto(fascia);
            writer.println(String.valueOf(label) + " " + fascia.name() + ";" + format.format(prezzo));
            ++n3;
        }
    }

    @Override
    public void printPrezzoMedioPonderatoNetto(TariffaApplicazione tariffa, String label, DecimalFormat format, PrintWriter writer) {
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            MisuraFasceQuantita misura = tariffa.getTariffa();
            double prezzo = misura.getPrezzoMedioPonderatoNetto(fascia);
            writer.println(String.valueOf(label) + " " + fascia.name() + ";" + format.format(prezzo));
            ++n3;
        }
    }

    @Override
    public void printFascia(DettaglioTariffa dettaglio, PrintWriter writer) {
        FasciaOraria fascia = dettaglio.getFascia();
        writer.print(String.valueOf(fascia.name()) + ";");
    }
}

