/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.tariffe.AbstractExportTariffeStrategy;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.TariffaMultiApplicazione;
import biz.elabor.prebilling.services.tariffe.TariffeMesePod;
import biz.elabor.prebilling.services.tariffe.TipoCalcolo;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public class ExportTariffeDispatcherStrategy
extends AbstractExportTariffeStrategy {
    public ExportTariffeDispatcherStrategy(int anno, Month mese, Date dataMax, TipoCalcolo tipo, PrebillingConfiguration configuration, TalkManager talkManager) {
        super(anno, mese, dataMax, Destinatari.DISPATCHER, tipo, configuration, talkManager);
    }

    @Override
    public void exportTariffe(ListMap<String, TariffaMultiApplicazione> tariffe, String fileName, ServiceStatus status) throws IOException {
        String idEsecuzione = status.getIdEsecuzione();
        Map<String, TariffeMesePod> mappaTariffe = this.buildMappaTariffe(tariffe);
        this.checkDettagli(mappaTariffe, status);
        status.addTariffeElaborateDispatcher(mappaTariffe);
        this.printTariffe("dispatcher", mappaTariffe, fileName, status);
        if (this.configuration.hasDettaglioDispatcher()) {
            File parent = ConfigurationHelper.getDispatcherTmpFolder(this.configuration, idEsecuzione, Funzionalita.TARIFFE);
            parent.mkdirs();
            this.printDettagliTariffe(mappaTariffe, parent, false);
        }
    }

    private Map<String, TariffeMesePod> buildMappaTariffe(ListMap<String, TariffaMultiApplicazione> mappaTariffe) {
        LinkedHashMap<String, TariffeMesePod> tariffeMese = new LinkedHashMap<String, TariffeMesePod>();
        for (List list : mappaTariffe) {
            this.fillTariffe(list, tariffeMese);
        }
        return tariffeMese;
    }

    @Override
    protected ListMap<String, TariffaMultiApplicazione> getTariffe(ServiceStatus status) {
        return status.getTariffeMedieMensiliDispatcher();
    }

    @Override
    protected File getFolder(String idEsecuzione, String azienda) {
        return ConfigurationHelper.getDispatcherTmpImportFolder(this.configuration, idEsecuzione, Funzionalita.TARIFFE);
    }
}

