/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.prebilling.common.model.TipoTrattamento;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.IndiciDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.tariffe.ExportRettificheTariffeDispatcherStrategy;
import biz.elabor.prebilling.services.tariffe.ExportRettificheTariffeResellerStrategy;
import biz.elabor.prebilling.services.tariffe.TipoCalcolo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class ExportRettificheTariffeTuttiStrategy
implements ServiceStrategy {
    private final List<ServiceStrategy> strategies = new ArrayList<ServiceStrategy>();

    public ExportRettificheTariffeTuttiStrategy(int anno, Month mese, TipoCalcolo tipo, String onlyPod, String codiceReseller, boolean scivoloEnabled, boolean scivoloForced, TipoTrattamento onlyTipoTrattamento, boolean bloccoIndice, PrebillingConfiguration configuration, GiadaDao giadaDao, MisureDao misureDao, IndiciDao indiciDao, TalkManager talkManager) {
        this.strategies.add(new ExportRettificheTariffeDispatcherStrategy(anno, mese, tipo, onlyPod, codiceReseller, scivoloEnabled, scivoloForced, onlyTipoTrattamento, bloccoIndice, configuration, giadaDao, misureDao, indiciDao, talkManager));
        this.strategies.add(new ExportRettificheTariffeResellerStrategy(anno, mese, tipo, onlyPod, codiceReseller, scivoloEnabled, scivoloForced, onlyTipoTrattamento, bloccoIndice, configuration, giadaDao, misureDao, indiciDao, talkManager));
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok = true;
        Iterator<ServiceStrategy> iterator = this.strategies.iterator();
        while (ok && iterator.hasNext()) {
            ServiceStrategy strategy = iterator.next();
            ok = strategy.execute(status);
        }
        return ok;
    }
}

