/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.DataContratto;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.PdoResult;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class ExcludeMisureStrategy
implements ServiceStrategy {
    private final int anno;
    private final Month mese;
    private final String onlyPod;
    private final GiadaDao giadaDao;
    private final MisureDao misureDao;
    private final PrebillingConfiguration configuration;
    private final TalkManager talkManager;

    public ExcludeMisureStrategy(int anno, Month mese, String onlyPod, GiadaDao giadaDao, MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager) {
        this.anno = anno;
        this.mese = mese;
        this.onlyPod = onlyPod;
        this.giadaDao = giadaDao;
        this.misureDao = misureDao;
        this.configuration = configuration;
        this.talkManager = talkManager;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        if (this.onlyPod == null || this.onlyPod.isEmpty()) {
            ElaborCalendar calendar = new ElaborCalendar(this.anno, this.mese);
            int mesiContrattiAttivi = this.configuration.getMesiContrattiAttivi();
            calendar.addMesi(-mesiContrattiAttivi);
            Date startDate = calendar.getDate();
            Map<String, DataContratto> contrattiDispatcher = this.giadaDao.getContrattiDispatcher(startDate);
            this.updateMisure(Destinatari.DISPATCHER, contrattiDispatcher, startDate, status);
            Map<String, DataContratto> contrattiReseller = this.giadaDao.getContrattiReseller(startDate);
            this.updateMisure(Destinatari.RESELLER, contrattiReseller, startDate, status);
        }
        return true;
    }

    private void updateMisure(Destinatari destinatari, Map<String, DataContratto> contratti, Date startDate, ServiceStatus status) {
        Logger logger = status.getLogger();
        logger.info("inizio update misure per " + destinatari.name());
        int maxRows = this.configuration.getNumMaxMisureTariffe();
        int mesiRitenzione = this.configuration.getMesiRitenzione();
        ElaborCalendar calendar = new ElaborCalendar(this.anno, this.mese);
        calendar.addMesi(-mesiRitenzione);
        Date endDate = calendar.getDate();
        while (true) {
            List<Pdo> misure = this.misureDao.getTestateTariffe(destinatari, this.anno, this.mese, maxRows);
            logger.info("lette " + misure.size() + " misure");
            if (this.fillResults(destinatari, contratti, startDate, endDate, misure, status)) break;
            this.misureDao.recordStatoTariffe(status, this.talkManager);
            status.resetLetture();
        }
        logger.info("fine update misure per " + destinatari.name());
    }

    private boolean fillResults(Destinatari destinatari, Map<String, DataContratto> contratti, Date startDate, Date endDate, List<Pdo> misure, ServiceStatus status) {
        boolean end = true;
        for (Pdo misura : misure) {
            String codicePod = misura.getCodicePod();
            Date dataImport = misura.getDataImport();
            Date dataMisura = misura.getPeriod().getStartDate();
            DataContratto contratto = contratti.get(codicePod);
            Date dataPrimoContratto = contratto == null ? endDate : contratto.getData();
            Date dataLimite = CalendarTools.max(startDate, dataPrimoContratto);
            if (!dataImport.before(dataLimite) && (!dataImport.before(endDate) || !dataMisura.before(dataPrimoContratto))) continue;
            end = false;
            Message sentence = new Message("compute.tariffe", "misura.senzacontratto");
            sentence.addParam(codicePod);
            String descrizione = this.talkManager.getMessage(sentence);
            PdoResult result = new PdoResult(misura, ErroriElaborazione.MISURA_SENZA_CONTRATTO, descrizione);
            status.addTariffeOrarieResult(destinatari, StatoMisure.ESCLUSO, result);
        }
        return end;
    }
}

