/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.prebilling.InconsistentOptionException;
import biz.elabor.prebilling.common.model.Contratto;
import biz.elabor.prebilling.common.model.TipoTrattamento;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.ContrattoEle;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.IndiciDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.dao.Multipunto;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.tariffe.ContrattoWrapper;
import biz.elabor.prebilling.services.tariffe.DestinatariManager;
import biz.elabor.prebilling.services.tariffe.DispatcherManager;
import biz.elabor.prebilling.services.tariffe.MissingIndiceException;
import biz.elabor.prebilling.services.tariffe.ResellerManager;
import biz.elabor.prebilling.services.tariffe.TariffaMultiApplicazione;
import biz.elabor.prebilling.services.tariffe.TipoCalcolo;
import biz.elabor.prebilling.services.tariffe.TuttiManager;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.exceptions.DataException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public enum Destinatari {
    DISPATCHER(new DispatcherManager()),
    RESELLER(new ResellerManager()),
    TUTTI(new TuttiManager());

    private static final Destinatari[] BASE_VALUES;
    private DestinatariManager manager;

    static {
        BASE_VALUES = new Destinatari[]{DISPATCHER, RESELLER};
    }

    private Destinatari(DestinatariManager manager) {
        this.manager = manager;
    }

    public ServiceStrategy getExportTariffeStrategy(int anno, Month mese, Date dataMax, TipoCalcolo tipo, PrebillingConfiguration configuration, TalkManager talkManager) {
        return this.manager.getExportTariffeStrategy(anno, mese, dataMax, tipo, configuration, talkManager);
    }

    public ServiceStrategy getExportRettificheTariffeStrategy(int anno, Month mese, TipoCalcolo tipo, String onlyPod, String codiceReseller, boolean scivoloEnabled, boolean scivoloForced, TipoTrattamento onlyTipoTrattamento, boolean bloccoIndice, PrebillingConfiguration configuration, GiadaDao giadaDao, MisureDao misureDao, IndiciDao indiciDao, TalkManager talkManager) {
        return this.manager.getExportRettificheTariffeStrategy(anno, mese, tipo, onlyPod, codiceReseller, scivoloEnabled, scivoloForced, onlyTipoTrattamento, bloccoIndice, configuration, giadaDao, misureDao, indiciDao, talkManager);
    }

    public ContrattoWrapper getWrapper(Contratto contratto) throws DataException {
        return this.manager.getHandler(contratto);
    }

    public void compute(ServiceStatus status, int anno, Month mese, TipoCalcolo tipo, Set<String> podSet, String onlyPod, Map<String, Multipunto> multiPodMap, String codiceReseller, MisureDao misureDao, GiadaDao giadaDao, PrebillingConfiguration configuration, TalkManager talkManager, int annoStart, Month meseStart, int annoRif, Month meseRif, boolean scivoloEnabled, boolean scivoloForced, TipoTrattamento onlyTipoTrattamento, boolean bloccoIndice) throws CalendarNotFoundException, MissingIndiceException, InconsistentOptionException {
        this.manager.compute(status, anno, mese, tipo, podSet, onlyPod, multiPodMap, codiceReseller, misureDao, giadaDao, configuration, talkManager, annoStart, meseStart, annoRif, meseRif, scivoloEnabled, scivoloForced, onlyTipoTrattamento, bloccoIndice);
    }

    public static Destinatari[] baseValues() {
        return BASE_VALUES;
    }

    public String getStatoFieldName() {
        return "stato_tariffe" + this.manager.getSuffix();
    }

    public String getCodErroreFieldName() {
        return "cod_errore_tariffe" + this.manager.getSuffix();
    }

    public String getDescErroreFieldName() {
        return "desc_errore_tariffe" + this.manager.getSuffix();
    }

    public boolean isDispatcher() {
        return this == DISPATCHER;
    }

    public boolean hasReseller() {
        return this.manager.hasReseller();
    }

    public boolean hasDispatcher() {
        return this.manager.hasDispatcher();
    }

    public boolean isElaborato(Pdo pdo) {
        return this.manager.isTariffaElaborata(pdo);
    }

    boolean isElaborati(List<Mno> mnoList) {
        return this.manager.isTariffeElaborate(mnoList);
    }

    public List<ContrattoEle> getContratti(GiadaDao giadaDao, int anno, Month mese, String codicePod, String codiceReseller) {
        return this.manager.getContratti(giadaDao, anno, mese, codicePod, codiceReseller);
    }

    public void setTariffe(ServiceStatus status, ListMap<String, TariffaMultiApplicazione> tariffe) {
        this.manager.setTariffe(status, tariffe);
    }

    public List<String> getAmbiti(String azienda) {
        return this.manager.getAmbiti(azienda);
    }

    String getAzienda(ContrattoEle contratto) {
        return this.manager.getAzienda(contratto);
    }
}

