/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.prebilling.common.dao.MultipuntoEntry;
import biz.elabor.prebilling.common.model.Applicazione;
import biz.elabor.prebilling.common.model.TipoFlat;
import biz.elabor.prebilling.dao.ContrattoEle;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.Multipunto;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.ContrattiPodList;
import biz.elabor.prebilling.model.giada.MappaContratti;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.MissingIndiceException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.tools.StringUtils;

public class ContrattiEleHelper {
    public static MappaContratti getContrattiDispatcher(int anno, Month mese, Set<String> podSet, String reseller, GiadaDao giadaDao) {
        List<ContrattoEle> contratti = giadaDao.getContrattiDispatcher(anno, mese, podSet);
        return ContrattiEleHelper.buildMappaContratti(contratti, reseller);
    }

    public static MappaContratti getContrattiReseller(int anno, Month mese, Set<String> podSet, String reseller, GiadaDao giadaDao) {
        List<ContrattoEle> contratti = giadaDao.getContrattiReseller(anno, mese, podSet);
        return ContrattiEleHelper.buildMappaContratti(contratti, reseller);
    }

    public static MappaContratti getContratti(Destinatari destinatari, int anno, Month mese, String onlyPod, Map<String, Multipunto> multiPodMap, String codiceReseller, GiadaDao giadaDao, ServiceStatus status) throws MissingIndiceException {
        MappaContratti mappaContratti = new MappaContratti();
        boolean podFound = false;
        for (Multipunto multipunto : multiPodMap.values()) {
            for (MultipuntoEntry pod : multipunto.getEntries()) {
                if (!pod.getKey().equals(onlyPod)) continue;
                podFound = true;
                for (MultipuntoEntry entry : multipunto.getEntries()) {
                    String codicePod = entry.getKey();
                    ContrattiEleHelper.fillMappaContratti(destinatari, giadaDao, anno, mese, onlyPod, codicePod, codiceReseller, mappaContratti, status);
                }
            }
            if (podFound) break;
        }
        if (!podFound) {
            ContrattiEleHelper.fillMappaContratti(destinatari, giadaDao, anno, mese, onlyPod, onlyPod, codiceReseller, mappaContratti, status);
        }
        if (mappaContratti.isEmpty()) {
            throw new MissingIndiceException(anno, mese, onlyPod);
        }
        return mappaContratti;
    }

    private static void fillMappaContratti(Destinatari destinatari, GiadaDao giadaDao, int anno, Month mese, String onlyPod, String codicePod, String codiceReseller, MappaContratti mappaContratti, ServiceStatus status) {
        List<ContrattoEle> contratti = destinatari.getContratti(giadaDao, anno, mese, codicePod, codiceReseller);
        if (codicePod.equals(onlyPod) || ContrattiEleHelper.isFixing(contratti, status)) {
            ContrattiEleHelper.fillMappaContratti(contratti, codiceReseller, mappaContratti);
        }
    }

    private static boolean isFixing(List<ContrattoEle> contratti, ServiceStatus status) {
        boolean fixing = false;
        for (ContrattoEle contratto : contratti) {
            Applicazione applicazione = status.getApplicazione(contratto);
            TipoFlat tipoFlat = applicazione.getTipoFlat();
            if (!contratto.isFixing() && !tipoFlat.isFixing() && !tipoFlat.isFixingSwap()) continue;
            fixing = true;
            break;
        }
        return fixing;
    }

    private static MappaContratti buildMappaContratti(List<ContrattoEle> contratti, String reseller) {
        MappaContratti mappaContratti = new MappaContratti();
        ContrattiEleHelper.fillMappaContratti(contratti, reseller, mappaContratti);
        return mappaContratti;
    }

    private static void fillMappaContratti(List<ContrattoEle> contratti, String reseller, MappaContratti mappaContratti) {
        for (ContrattoEle contratto : contratti) {
            ContrattiPodList contrattiPod;
            String azienda = contratto.getReseller();
            if (!StringUtils.isEmpty(reseller) && !reseller.equals(azienda)) continue;
            try {
                contrattiPod = (ContrattiPodList)mappaContratti.get(azienda);
            }
            catch (DataNotFoundException e2) {
                contrattiPod = new ContrattiPodList(azienda);
                mappaContratti.add(contrattiPod);
            }
            contrattiPod.add(contratto);
        }
    }
}

