/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.prebilling.InconsistentOptionException;
import biz.elabor.prebilling.common.model.TipoTrattamento;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.dao.Multipunto;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.MissingIndiceException;
import biz.elabor.prebilling.services.tariffe.TariffaMultiApplicazione;
import biz.elabor.prebilling.services.tariffe.TipoCalcolo;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.BasicListMap;

public class CalcolaMedieStrategy {
    private final Destinatari destinatari;
    private final int anno;
    private final Month mese;
    private final TipoCalcolo tipo;
    private final Set<String> podSet;
    private final String onlyPod;
    private final String codiceReseller;
    private final TalkManager talkManager;
    private final PrebillingConfiguration configuration;
    private final MisureDao misureDao;
    private final GiadaDao giadaDao;
    private final boolean scivoloEnabled;
    private final boolean scivoloForced;
    private int annoStart;
    private Month meseStart;
    private int annoRif;
    private Month meseRif;
    private final TipoTrattamento onlyTipoTrattamento;
    private final boolean bloccoIndice;

    public CalcolaMedieStrategy(Destinatari destinatari, int anno, Month mese, TipoCalcolo tipo, Set<String> podSet, String onlyPod, String codiceReseller, MisureDao misureDao, GiadaDao giadadao, PrebillingConfiguration configuration, TalkManager talkManager, int annoStart, Month meseStart, int annoRif, Month meseRif, boolean scivoloEnabled, boolean scivoloForced, TipoTrattamento onlyTipoTrattamento, boolean bloccoIndice) {
        this.destinatari = destinatari;
        this.anno = anno;
        this.mese = mese;
        this.tipo = tipo;
        this.podSet = podSet;
        this.codiceReseller = codiceReseller;
        this.onlyPod = onlyPod;
        this.misureDao = misureDao;
        this.giadaDao = giadadao;
        this.talkManager = talkManager;
        this.configuration = configuration;
        this.annoStart = annoStart;
        this.meseStart = meseStart;
        this.annoRif = annoRif;
        this.meseRif = meseRif;
        this.scivoloEnabled = scivoloEnabled;
        this.scivoloForced = scivoloForced;
        this.onlyTipoTrattamento = onlyTipoTrattamento;
        this.bloccoIndice = bloccoIndice;
    }

    public boolean execute(ServiceStatus status) throws InconsistentOptionException {
        boolean ok;
        block3: {
            ok = true;
            try {
                CalcolaMedieStrategy.initTariffe(status);
                this.compute(status);
            }
            catch (CalendarNotFoundException exc) {
                String message = exc.getMessage();
                Message sentence = new Message("compute.tariffe", message);
                sentence.addParam(exc.getKey());
                sentence.addParam(exc.getCodicePod());
                this.talkManager.addSentence(sentence);
            }
            catch (MissingIndiceException exc) {
                if (this.anno != this.annoRif || !this.mese.equals((Object)this.meseRif)) break block3;
                Date date = CalendarTools.getDate(this.anno, this.mese, 1);
                Message sentence = new Message("compute.tariffe", "missing.indice");
                DateFormat dataFormat = StrategyHelper.getDataFormat();
                String formattedDate = dataFormat.format(date);
                sentence.addParam(formattedDate);
                this.talkManager.addSentence(sentence);
            }
        }
        return ok;
    }

    private static void initTariffe(ServiceStatus status) {
        BasicListMap<String, TariffaMultiApplicazione> tariffe = new BasicListMap<String, TariffaMultiApplicazione>();
        status.setTariffeMedieMensiliDispatcher(tariffe);
        status.setTariffeMedieMensiliReseller(tariffe);
    }

    private void compute(ServiceStatus status) throws CalendarNotFoundException, MissingIndiceException, InconsistentOptionException {
        Map<String, Multipunto> multiPodMap = this.misureDao.getMultiPodMap(this.anno, this.mese);
        this.destinatari.compute(status, this.anno, this.mese, this.tipo, this.podSet, this.onlyPod, multiPodMap, this.codiceReseller, this.misureDao, this.giadaDao, this.configuration, this.talkManager, this.annoStart, this.meseStart, this.annoRif, this.meseRif, this.scivoloEnabled, this.scivoloForced, this.onlyTipoTrattamento, this.bloccoIndice);
    }
}

